/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.hud.element;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.Sprite;
import wayoftime.bloodmagic.client.hud.element.HUDElement;

public abstract class ElementTileInformation<T extends BlockEntity>
extends HUDElement {
    protected final Class<T> tileClass;
    private final List<Pair<Sprite, Function<T, String>>> information;

    public ElementTileInformation(int width, int lines, Class<T> tileClass) {
        super(width, 18 * lines - 2);
        this.tileClass = tileClass;
        this.information = Lists.newArrayList();
        this.gatherInformation(this.information::add);
    }

    public abstract void gatherInformation(Consumer<Pair<Sprite, Function<T, String>>> var1);

    @Override
    public void draw(PoseStack matrixStack, float partialTicks, int drawX, int drawY) {
        HitResult trace = Minecraft.m_91087_().f_91077_;
        if (trace == null || trace.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockEntity tile = Minecraft.m_91087_().f_91073_.m_7702_(((BlockHitResult)trace).m_82425_());
        int yOffset = 0;
        for (Pair<Sprite, Function<T, String>> sprite : this.information) {
            ((Sprite)sprite.getLeft()).draw(matrixStack, drawX, drawY + yOffset);
            int textY = drawY + yOffset + ((Sprite)sprite.getLeft()).getTextureHeight() / 4;
            Minecraft.m_91087_().f_91062_.m_92750_(matrixStack, tile != null && tile.getClass() == this.tileClass ? (String)((Function)sprite.getRight()).apply(tile) : "?", (float)(drawX + ((Sprite)sprite.getLeft()).getTextureWidth() + 2), (float)textY, Color.WHITE.getRGB());
            yOffset += ((Sprite)sprite.getLeft()).getTextureHeight() + 2;
        }
    }

    @Override
    public boolean shouldRender(Minecraft minecraft) {
        HitResult trace = Minecraft.m_91087_().f_91077_;
        if (trace == null || trace.m_6662_() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockEntity tile = Minecraft.m_91087_().f_91073_.m_7702_(((BlockHitResult)trace).m_82425_());
        return tile != null && this.tileClass.isAssignableFrom(tile.getClass());
    }
}

