/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.anointment;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import wayoftime.bloodmagic.anointment.Anointment;
import wayoftime.bloodmagic.anointment.AnointmentData;
import wayoftime.bloodmagic.core.AnointmentRegistrar;

public class AnointmentHolder {
    private final Map<Anointment, AnointmentData> anointments;

    public AnointmentHolder(Map<Anointment, AnointmentData> anointments) {
        this.anointments = anointments;
    }

    public AnointmentHolder() {
        this(Maps.newHashMap());
    }

    public boolean isEmpty() {
        return this.anointments.isEmpty();
    }

    public boolean applyAnointment(ItemStack stack, Anointment anointment, AnointmentData data) {
        if (this.canApplyAnointment(stack, anointment, data)) {
            this.anointments.put(anointment, data);
            anointment.applyAnointment(this, stack, data.getLevel());
            return true;
        }
        return false;
    }

    public boolean canApplyAnointment(ItemStack stack, Anointment anointment, AnointmentData data) {
        ResourceLocation key = anointment.getKey();
        for (Anointment containedAnoint : this.anointments.keySet()) {
            ResourceLocation containedKey = containedAnoint.getKey();
            if (anointment.isCompatible(containedKey) && containedAnoint.isCompatible(key)) continue;
            return false;
        }
        if (this.anointments.containsKey((Object)anointment)) {
            AnointmentData prevData = this.anointments.get((Object)anointment);
            int level = prevData.getLevel();
            int remainingDur = prevData.getMaxDamage() - prevData.getDamage();
            return level < data.getLevel() || level == data.getLevel() && remainingDur < data.getMaxDamage() - data.getDamage();
        }
        return true;
    }

    public int getAnointmentLevel(Anointment anointment) {
        if (this.anointments.containsKey((Object)anointment)) {
            return this.anointments.get((Object)anointment).getLevel();
        }
        return 0;
    }

    public boolean consumeAnointmentDurabilityOnHit(ItemStack weaponStack, EquipmentSlot type, LivingEntity user) {
        boolean didConsume = false;
        ArrayList<Anointment> removedAnointments = new ArrayList<Anointment>();
        for (Map.Entry<Anointment, AnointmentData> entry : this.anointments.entrySet()) {
            Anointment annointment = entry.getKey();
            if (!annointment.consumeOnAttack()) continue;
            AnointmentData data = entry.getValue();
            data.damage(1);
            didConsume = true;
            if (!data.isMaxDamage()) continue;
            removedAnointments.add(annointment);
        }
        for (Anointment anointment : removedAnointments) {
            this.removeAnointment(weaponStack, type, anointment, user);
        }
        return didConsume;
    }

    public boolean consumeAnointmentDurabilityOnUseFinish(ItemStack weaponStack, EquipmentSlot type, LivingEntity user) {
        boolean didConsume = false;
        ArrayList<Anointment> removedAnointments = new ArrayList<Anointment>();
        for (Map.Entry<Anointment, AnointmentData> entry : this.anointments.entrySet()) {
            Anointment annointment = entry.getKey();
            if (!annointment.consumeOnUseFinish()) continue;
            AnointmentData data = entry.getValue();
            data.damage(1);
            didConsume = true;
            if (!data.isMaxDamage()) continue;
            removedAnointments.add(annointment);
        }
        for (Anointment anointment : removedAnointments) {
            this.removeAnointment(weaponStack, type, anointment, user);
        }
        return didConsume;
    }

    public boolean consumeAnointmentDurabilityOnHarvest(ItemStack weaponStack, EquipmentSlot type, LivingEntity user) {
        boolean didConsume = false;
        ArrayList<Anointment> removedAnointments = new ArrayList<Anointment>();
        for (Map.Entry<Anointment, AnointmentData> entry : this.anointments.entrySet()) {
            Anointment annointment = entry.getKey();
            if (!annointment.consumeOnHarvest()) continue;
            AnointmentData data = entry.getValue();
            data.damage(1);
            didConsume = true;
            if (!data.isMaxDamage()) continue;
            removedAnointments.add(annointment);
        }
        for (Anointment anointment : removedAnointments) {
            this.removeAnointment(weaponStack, type, anointment, user);
        }
        return didConsume;
    }

    public boolean removeAnointment(ItemStack weaponStack, EquipmentSlot type, Anointment anointment, LivingEntity user) {
        this.anointments.remove((Object)anointment);
        anointment.removeAnointment(this, weaponStack, type);
        SoundEvent soundevent = SoundEvents.f_12436_;
        user.f_19853_.m_5594_(null, user.m_142538_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (user.f_19853_ instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)user.f_19853_;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123755_, user.m_20185_(), user.m_20186_() + 1.0, user.m_20189_(), 16, 0.3, 0.0, 0.3, 0.0);
        }
        return true;
    }

    public Map<Anointment, AnointmentData> getAnointments() {
        return ImmutableMap.copyOf(this.anointments);
    }

    public double getAdditionalDamage(Player player, ItemStack weapon, double damage, LivingEntity attacked) {
        double additionalDamage = 0.0;
        for (Map.Entry<Anointment, AnointmentData> entry : this.anointments.entrySet()) {
            Anointment.IDamageProvider prov = entry.getKey().getDamageProvider();
            if (prov == null) continue;
            additionalDamage += prov.getAdditionalDamage(player, weapon, damage, this, attacked, entry.getKey(), entry.getValue().getLevel());
        }
        return additionalDamage;
    }

    public CompoundTag serialize() {
        CompoundTag compound = new CompoundTag();
        ListTag statList = new ListTag();
        this.anointments.forEach((k, v) -> {
            CompoundTag anoint = new CompoundTag();
            anoint.m_128359_("key", k.getKey().toString());
            anoint.m_128405_("level", v.getLevel());
            anoint.m_128405_("damage", v.getDamage());
            anoint.m_128405_("max_damage", v.getMaxDamage());
            statList.add((Object)anoint);
        });
        compound.m_128365_("anointments", (Tag)statList);
        return compound;
    }

    public void deserialize(CompoundTag nbt) {
        ListTag statList = nbt.m_128437_("anointments", 10);
        statList.forEach(tag -> {
            if (!(tag instanceof CompoundTag)) {
                return;
            }
            Anointment anoint = AnointmentRegistrar.ANOINTMENT_MAP.getOrDefault(new ResourceLocation(((CompoundTag)tag).m_128461_("key")), Anointment.DUMMY);
            if (anoint == Anointment.DUMMY) {
                return;
            }
            AnointmentData data = new AnointmentData(((CompoundTag)tag).m_128451_("level"), ((CompoundTag)tag).m_128451_("damage"), ((CompoundTag)tag).m_128451_("max_damage"));
            this.anointments.put(anoint, data);
        });
    }

    public static AnointmentHolder fromNBT(CompoundTag holderTag) {
        AnointmentHolder holder = new AnointmentHolder();
        holder.deserialize(holderTag);
        return holder;
    }

    public static AnointmentHolder fromItemStack(ItemStack stack) {
        CompoundTag nbtTag = stack.m_41783_();
        if (nbtTag == null) {
            return null;
        }
        CompoundTag holderTag = nbtTag.m_128469_("anointment_holder");
        if (holderTag != null) {
            return AnointmentHolder.fromNBT(holderTag);
        }
        return null;
    }

    public void toItemStack(ItemStack stack) {
        CompoundTag nbtTag = stack.m_41784_();
        CompoundTag childTag = this.serialize();
        nbtTag.m_128365_("anointment_holder", (Tag)childTag);
    }

    public static AnointmentHolder fromPlayer(Player player, InteractionHand hand) {
        return AnointmentHolder.fromPlayer(player, hand, false);
    }

    public static AnointmentHolder fromPlayer(Player player, InteractionHand hand, boolean createNew) {
        ItemStack heldItem = player.m_21120_(hand);
        AnointmentHolder holder = AnointmentHolder.fromItemStack(heldItem);
        return holder == null && createNew ? new AnointmentHolder() : holder;
    }

    public static void toPlayer(Player player, InteractionHand hand, AnointmentHolder holder) {
        ItemStack heldItem = player.m_21120_(hand);
        holder.toItemStack(heldItem);
    }

    public static void appendAnointmentTooltip(AnointmentHolder holder, List<Component> tooltip) {
        if (holder != null) {
            holder.getAnointments().forEach((k, v) -> {
                boolean sneaking = Screen.m_96638_();
                if (!sneaking) {
                    tooltip.add((Component)new TranslatableComponent("%s %s", new Object[]{new TranslatableComponent(k.getTranslationKey()), new TranslatableComponent("enchantment.level." + v.getLevel())}));
                } else {
                    tooltip.add((Component)new TranslatableComponent("%s %s", new Object[]{new TranslatableComponent(k.getTranslationKey()), ": (" + v.getDamageString() + ")"}));
                }
            });
        }
    }
}

