/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.altar;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.altar.AltarComponent;
import wayoftime.bloodmagic.altar.AltarTier;
import wayoftime.bloodmagic.altar.AltarUpgrade;
import wayoftime.bloodmagic.altar.ComponentType;
import wayoftime.bloodmagic.common.block.BlockBloodRune;
import wayoftime.bloodmagic.common.tile.TileAltar;
import wayoftime.bloodmagic.impl.BloodMagicAPI;

public class AltarUtil {
    @Nonnull
    public static AltarTier getTier(Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TileAltar)) {
            return AltarTier.ONE;
        }
        AltarTier lastCheck = AltarTier.ONE;
        for (AltarTier tier : AltarTier.values()) {
            for (AltarComponent component : tier.getAltarComponents()) {
                List<BlockState> validStates;
                BlockPos componentPos = pos.m_141952_((Vec3i)component.getOffset());
                BlockState worldState = world.m_8055_(componentPos);
                if (component.getComponent() == ComponentType.NOTAIR && worldState.m_60767_() != Material.f_76296_ && !worldState.m_60767_().m_76332_() || (validStates = BloodMagicAPI.INSTANCE.getComponentStates(component.getComponent())).contains(worldState)) continue;
                return lastCheck;
            }
            lastCheck = tier;
        }
        return lastCheck;
    }

    @Nonnull
    public static AltarUpgrade getUpgrades(Level world, BlockPos pos, AltarTier currentTier) {
        AltarUpgrade upgrades = new AltarUpgrade();
        for (AltarComponent component : currentTier.getAltarComponents()) {
            BlockPos componentPos;
            BlockState state;
            if (!component.isUpgradeSlot() || component.getComponent() != ComponentType.BLOODRUNE || !((state = world.m_8055_(componentPos = pos.m_141952_((Vec3i)component.getOffset()))).m_60734_() instanceof BlockBloodRune)) continue;
            upgrades.upgrade(((BlockBloodRune)state.m_60734_()).getBloodRune(world, componentPos));
        }
        return upgrades;
    }

    @Nullable
    public static Pair<BlockPos, ComponentType> getFirstMissingComponent(Level world, BlockPos pos, int altarTier) {
        if (altarTier >= AltarTier.MAXTIERS) {
            return null;
        }
        for (AltarTier tier : AltarTier.values()) {
            for (AltarComponent component : tier.getAltarComponents()) {
                List<BlockState> validStates;
                BlockPos componentPos = pos.m_141952_((Vec3i)component.getOffset());
                BlockState worldState = world.m_8055_(componentPos);
                if (component.getComponent() == ComponentType.NOTAIR && worldState.m_60767_() != Material.f_76296_ && !worldState.m_60767_().m_76332_() || (validStates = BloodMagicAPI.INSTANCE.getComponentStates(component.getComponent())).contains(worldState)) continue;
                return Pair.of((Object)componentPos, (Object)((Object)component.getComponent()));
            }
        }
        return null;
    }
}

