/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import vazkii.botania.test.TestingUtil;

public class RannuncarpusTest {
    private static final String TEMPLATE = "botania:block/rannuncarpus";
    private static final BlockPos FLOWER_POS = new BlockPos(2, 3, 2);
    private static final BlockPos FILTER_POS = FLOWER_POS.m_7495_();
    private static final BlockPos EXPECTED_PLACE_POS = new BlockPos(3, 2, 2);
    private static final BlockPos FILTERED_POS = EXPECTED_PLACE_POS.m_7495_();

    @GameTest(template="botania:block/rannuncarpus")
    public void testDestinationFilterPositive(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> {
            helper.m_177301_();
            helper.m_177189_(Blocks.f_50069_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        }).m_177552_(() -> helper.m_177208_(Blocks.f_50069_, EXPECTED_PLACE_POS)).m_177543_();
    }

    @GameTest(template="botania:block/rannuncarpus")
    public void testDestinationFilterNegative(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> {
            helper.m_177301_();
            helper.m_177245_(FILTERED_POS, Blocks.f_50387_);
            helper.m_177189_(Blocks.f_50069_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        }).m_177559_(61, () -> helper.m_177341_(Blocks.f_50069_, EXPECTED_PLACE_POS)).m_177543_();
    }

    @GameTest(template="botania:block/rannuncarpus")
    public void testPickupFilterPositive(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> {
            ItemFrame frame = RannuncarpusTest.getItemFrame(helper);
            frame.m_31805_(new ItemStack((ItemLike)Blocks.f_50069_));
            helper.m_177189_(Blocks.f_50069_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        }).m_177552_(() -> helper.m_177208_(Blocks.f_50069_, EXPECTED_PLACE_POS)).m_177543_();
    }

    @GameTest(template="botania:block/rannuncarpus")
    public void testPickupFilterNegative(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> {
            ItemFrame frame = RannuncarpusTest.getItemFrame(helper);
            frame.m_31805_(new ItemStack((ItemLike)Blocks.f_50652_));
            helper.m_177189_(Blocks.f_50069_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        }).m_177559_(61, () -> helper.m_177341_(Blocks.f_50069_, EXPECTED_PLACE_POS)).m_177543_();
    }

    private static ItemFrame getItemFrame(GameTestHelper helper) {
        AABB bounds = new AABB(helper.m_177449_(FLOWER_POS));
        List list = helper.m_177100_().m_45976_(ItemFrame.class, bounds);
        TestingUtil.assertThat(list.size() == 1, () -> "Number of item frames wasn't 1");
        return (ItemFrame)list.get(0);
    }
}

