/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.IRuneAltarRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeRuneAltar;

@Document(value="mods/Botania/recipe/manager/RuneAltarRecipeManager")
@ZenRegister
@IRecipeHandler.For(value=IRuneAltarRecipe.class)
@ZenCodeType.Name(value="mods.botania.recipe.manager.RuneAltarRecipeManager")
public class RuneAltarRecipeManager
implements IRecipeManager<IRuneAltarRecipe>,
IRecipeHandler<IRuneAltarRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, int mana, IIngredient ... inputs) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)new RecipeRuneAltar(resourceLocation, output.getInternal(), mana, (Ingredient[])Arrays.stream(inputs).map(IIngredient::asVanillaIngredient).toArray(Ingredient[]::new))));
    }

    public RecipeType<IRuneAltarRecipe> getRecipeType() {
        return ModRecipeTypes.RUNE_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, IRuneAltarRecipe recipe) {
        StringJoiner s = new StringJoiner(", ", manager.getCommandString() + ".addRecipe(", ");");
        s.add(StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()));
        s.add(Services.PLATFORM.createMCItemStack(recipe.m_8043_()).getCommandString());
        s.add(String.valueOf(recipe.getManaUsage()));
        recipe.m_7527_().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).forEach(s::add);
        return s.toString();
    }

    public Optional<Function<ResourceLocation, IRuneAltarRecipe>> replaceIngredients(IRecipeManager manager, IRuneAltarRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList((NonNullList)recipe.m_7527_(), Ingredient.class, (Recipe)recipe, rules, ingr -> id -> new RecipeRuneAltar((ResourceLocation)id, recipe.m_8043_(), recipe.getManaUsage(), (Ingredient[])ingr.toArray((Object[])new Ingredient[0])));
    }
}

