/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui.box;

import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.client.gui.SlotLocked;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.ItemBaubleBox;
import vazkii.botania.common.item.ModItems;

public class ContainerBaubleBox
extends AbstractContainerMenu {
    private final ItemStack box;

    public static ContainerBaubleBox fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        InteractionHand hand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return new ContainerBaubleBox(windowId, inv, inv.f_35978_.m_21120_(hand));
    }

    public ContainerBaubleBox(int windowId, Inventory playerInv, ItemStack box) {
        super(ModItems.BAUBLE_BOX_CONTAINER, windowId);
        int j;
        int i;
        this.box = box;
        SimpleContainer baubleBoxInv = !playerInv.f_35978_.f_19853_.f_46443_ ? ItemBaubleBox.getInventory(box) : new SimpleContainer(24);
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 6; ++j) {
                int k = j + i * 6;
                this.m_38897_(new Slot((Container)baubleBoxInv, k, 62 + j * 18, 8 + i * 18){

                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        return EquipmentHandler.instance.isAccessory(stack);
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (playerInv.m_8020_(i) == box) {
                this.m_38897_(new SlotLocked((Container)playerInv, i, 8 + i * 18, 142));
                continue;
            }
            this.m_38897_(new Slot((Container)playerInv, i, 8 + i * 18, 142));
        }
    }

    public boolean m_6875_(@Nonnull Player player) {
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        return !main.m_41619_() && main == this.box || !off.m_41619_() && off == this.box;
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int boxStart = 0;
            int boxEnd = boxStart + 24;
            int invEnd = boxEnd + 36;
            if (slotIndex < boxEnd ? !this.m_38903_(itemstack1, boxEnd, invEnd, true) : !itemstack1.m_41619_() && EquipmentHandler.instance.isAccessory(itemstack1) && !this.m_38903_(itemstack1, boxStart, boxEnd, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }
}

