/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.inventory.ContainerInventoryAccess;
import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.darkhax.bookshelf.api.inventory.WorldlyContainerInventoryAccess;
import net.darkhax.bookshelf.mixin.inventory.AccessorCraftingContainer;
import net.darkhax.bookshelf.mixin.inventory.AccessorCraftingMenu;
import net.darkhax.bookshelf.mixin.inventory.AccessorInventoryMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IInventoryHelper {
    @Nullable
    default public AbstractContainerMenu getCraftingContainer(CraftingContainer container) {
        AbstractContainerMenu abstractContainerMenu;
        if (container instanceof AccessorCraftingContainer) {
            AccessorCraftingContainer accessor = (AccessorCraftingContainer)container;
            abstractContainerMenu = accessor.bookshelf$getMenu();
        } else {
            abstractContainerMenu = null;
        }
        return abstractContainerMenu;
    }

    @Nullable
    default public Player getCraftingPlayer(Container container) {
        if (container instanceof Inventory) {
            Inventory playerInv = (Inventory)container;
            return playerInv.f_35978_;
        }
        if (container instanceof CraftingContainer) {
            CraftingContainer crafting = (CraftingContainer)container;
            AbstractContainerMenu menu = this.getCraftingContainer(crafting);
            if (menu instanceof AccessorCraftingMenu) {
                AccessorCraftingMenu accessor = (AccessorCraftingMenu)menu;
                return accessor.bookshelf$getPlayer();
            }
            if (menu instanceof AccessorInventoryMenu) {
                AccessorInventoryMenu accessor = (AccessorInventoryMenu)menu;
                return accessor.bookshelf$getOwner();
            }
        }
        return null;
    }

    default public ItemStack damageStack(ItemStack stack, int amount, @Nullable LivingEntity owner, @Nullable EquipmentSlot slot) {
        if (stack.m_41763_()) {
            if (owner != null) {
                stack.m_41622_(amount, owner, e -> {
                    if (slot != null) {
                        e.m_21166_(slot);
                    }
                });
            } else if (stack.m_41629_(amount, Constants.RANDOM, null)) {
                stack.m_41774_(1);
                stack.m_41721_(0);
            }
        }
        return stack;
    }

    default public NonNullList<ItemStack> keepDamageableItems(CraftingContainer inv, NonNullList<ItemStack> keptItems, int damageAmount) {
        Player player = this.getCraftingPlayer((Container)inv);
        Random random = player != null ? player.m_21187_() : Constants.RANDOM;
        for (int i = 0; i < keptItems.size(); ++i) {
            ItemStack stack;
            ItemStack input = inv.m_8020_(i).m_41777_();
            if (!input.m_41720_().m_41465_() && (!input.m_41782_() || !input.m_41783_().m_128471_("Unbreaking")) || (stack = this.damageStack(input, damageAmount, (LivingEntity)player, null)).m_41619_()) continue;
            keptItems.set(i, (Object)stack);
        }
        return keptItems;
    }

    default public NonNullList<ItemStack> toList(Container inventory) {
        NonNullList items = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        this.applyForEach(inventory, (arg_0, arg_1) -> ((NonNullList)items).set(arg_0, arg_1));
        return items;
    }

    default public void fill(Container inventory, NonNullList<ItemStack> fillWith) {
        if (inventory.m_6643_() != fillWith.size()) {
            throw new IllegalStateException("Inventory size did not match! inv_size=" + inventory.m_6643_() + " fill_size=" + fillWith.size());
        }
        for (int slotId = 0; slotId < fillWith.size(); ++slotId) {
            inventory.m_6836_(slotId, (ItemStack)fillWith.get(slotId));
        }
    }

    default public void applyForEach(Container inventory, Consumer<ItemStack> action) {
        for (int slotId = 0; slotId < inventory.m_6643_(); ++slotId) {
            action.accept(inventory.m_8020_(slotId));
        }
    }

    default public void applyForEach(Container inventory, BiConsumer<Integer, ItemStack> action) {
        for (int slotId = 0; slotId < inventory.m_6643_(); ++slotId) {
            action.accept(slotId, inventory.m_8020_(slotId));
        }
    }

    default public boolean canItemsStack(ItemStack original, ItemStack toStack) {
        return !toStack.m_41619_() && original.m_41656_(toStack) && original.m_41782_() == toStack.m_41782_() && (!original.m_41782_() || original.m_41783_().equals((Object)toStack.m_41783_()));
    }

    @Nullable
    default public IInventoryAccess getInventory(Level level, BlockPos pos, @Nullable Direction direction) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
            WorldlyContainer container = holder.m_5840_(state, (LevelAccessor)level, pos);
            if (container != null) {
                return new ContainerInventoryAccess<WorldlyContainer>(container);
            }
        } else {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof Container) {
                Container container = (Container)be;
                if (container instanceof WorldlyContainer) {
                    WorldlyContainer worldly = (WorldlyContainer)container;
                    return new WorldlyContainerInventoryAccess<WorldlyContainer>(worldly);
                }
                return new ContainerInventoryAccess<Container>(container);
            }
        }
        return null;
    }

    default public void openMenu(ServerPlayer player, MenuProvider provider) {
        this.openMenu(player, provider, buf -> {});
    }

    public void openMenu(ServerPlayer var1, MenuProvider var2, Consumer<FriendlyByteBuf> var3);

    default public ItemStack getCraftingRemainder(ItemStack stack) {
        return this.hasCraftingRemainder(stack) ? new ItemStack((ItemLike)stack.m_41720_().m_41469_()) : ItemStack.f_41583_;
    }

    default public boolean hasCraftingRemainder(ItemStack stack) {
        return stack.m_41720_().m_41470_();
    }
}

