/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.util;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.world.gen.VampirismFeatures;
import de.teamlapen.vampirism.world.gen.util.RandomBlockState;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.Pair;

public class RandomStructureProcessor
extends RuleProcessor {
    public static final Codec<RandomStructureProcessor> CODEC = RandomBlockState.CODEC.listOf().fieldOf("rules").xmap(RandomStructureProcessor::new, rule -> rule.rules).codec();
    private final ImmutableList<RandomBlockState> rules;

    public RandomStructureProcessor(List<RandomBlockState> rules) {
        super(Collections.emptyList());
        this.rules = ImmutableList.copyOf(rules);
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader worldReaderIn, @Nonnull BlockPos pos, @Nonnull BlockPos pos2, @Nonnull StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo blockInfo1, @Nonnull StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        Random random = new Random(Mth.m_14057_((Vec3i)blockInfo1.f_74675_));
        BlockState blockstate = worldReaderIn.m_8055_(blockInfo1.f_74675_);
        for (RandomBlockState ruleEntry : this.rules) {
            if (!ruleEntry.m_74238_(blockInfo1.f_74676_, blockstate, blockInfo.f_74675_, blockInfo1.f_74675_, pos2, random)) continue;
            Pair<BlockState, Optional<CompoundTag>> pair = ruleEntry.getOutput();
            return new StructureTemplate.StructureBlockInfo(blockInfo1.f_74675_, (BlockState)pair.getLeft(), (CompoundTag)((Optional)pair.getRight()).orElse(null));
        }
        return blockInfo1;
    }

    @Nonnull
    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)VampirismFeatures.random_selector.get();
    }
}

