/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.util;

import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.world.gen.VampirismFeatures;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BiomeTopBlockProcessor
extends StructureProcessor {
    public static final Codec<BiomeTopBlockProcessor> CODEC = BlockState.f_61039_.fieldOf("replace_block").xmap(BiomeTopBlockProcessor::new, entry -> entry.replaceBlock).codec();
    private static final Map<Block, Block> streetBlocks = new HashMap<Block, Block>(){
        {
            this.put(Blocks.f_49992_, Blocks.f_50471_);
            this.put(Blocks.f_50440_, Blocks.f_152481_);
        }
    };
    private final BlockState replaceBlock;

    public BiomeTopBlockProcessor(BlockState blockState) {
        this.replaceBlock = blockState;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(@Nonnull LevelReader worldReaderIn, @Nonnull BlockPos pos, @Nonnull BlockPos pos1, @Nonnull StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo blockInfo1, @Nonnull StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        if (blockInfo1.f_74676_.equals(this.replaceBlock)) {
            BlockState topBlock = worldReaderIn.m_8055_(blockInfo1.f_74675_);
            if (streetBlocks.containsKey(topBlock.m_60734_())) {
                topBlock = streetBlocks.get(topBlock.m_60734_()).m_49966_();
            }
            return new StructureTemplate.StructureBlockInfo(blockInfo1.f_74675_, topBlock, null);
        }
        return blockInfo1;
    }

    @Nonnull
    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)VampirismFeatures.biome_based.get();
    }
}

