/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.util.MixinHooks;
import de.teamlapen.vampirism.world.gen.util.BiomeTopBlockProcessor;
import de.teamlapen.vampirism.world.gen.util.RandomBlockState;
import de.teamlapen.vampirism.world.gen.util.RandomStructureProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class VanillaStructureModifications {
    public static void createJigsawPool() {
        VanillaStructureModifications.setupSingleJigsawPieceGeneration();
        Pools.m_211103_((StructureTemplatePool)new StructureTemplatePool(new ResourceLocation("vampirism", "village/entities/hunter_trainer"), new ResourceLocation("empty"), (List)Lists.newArrayList((Object[])new Pair[]{Pair.of(VanillaStructureModifications.singleJigsawPieceFunction("village/entities/hunter_trainer"), (Object)1)}), StructureTemplatePool.Projection.RIGID));
    }

    public static void addVillageStructures(RegistryAccess dynamicRegistries) {
        VanillaStructureModifications.addHunterTrainerHouse(dynamicRegistries, VanillaStructureModifications.getDefaultPools());
        VanillaStructureModifications.addTotem(dynamicRegistries, VanillaStructureModifications.getDefaultPools());
        VanillaStructureModifications.replaceTemples(dynamicRegistries, VanillaStructureModifications.getTempleReplacements());
    }

    private static void setupSingleJigsawPieceGeneration() {
        ArrayList list = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("vampirism", "village/totem")});
        list.addAll(Arrays.stream(BiomeType.values()).map(type -> new ResourceLocation("vampirism", "village/" + type.path + "/houses/hunter_trainer")).toList());
        MixinHooks.addSingleInstanceStructure(list);
    }

    private static Map<ResourceLocation, BiomeType> getDefaultPools() {
        return Map.ofEntries(Map.entry(new ResourceLocation("village/plains/houses"), BiomeType.PLAINS), Map.entry(new ResourceLocation("village/desert/houses"), BiomeType.DESERT), Map.entry(new ResourceLocation("village/savanna/houses"), BiomeType.SAVANNA), Map.entry(new ResourceLocation("village/taiga/houses"), BiomeType.TAIGA), Map.entry(new ResourceLocation("village/snowy/houses"), BiomeType.SNOWY));
    }

    private static Map<ResourceLocation, Map<String, StructurePoolElement>> getTempleReplacements() {
        return new HashMap<ResourceLocation, Map<String, StructurePoolElement>>(){
            {
                this.put(new ResourceLocation("village/plains/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_3"), (Object)VanillaStructureModifications.singleJigsawPiece("village/plains/houses/plains_temple_3", (Holder<StructureProcessorList>)ProcessorLists.f_127204_), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_4"), (Object)VanillaStructureModifications.singleJigsawPiece("village/plains/houses/plains_temple_4", (Holder<StructureProcessorList>)ProcessorLists.f_127204_)));
                this.put(new ResourceLocation("village/desert/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece("village/desert/houses/desert_temple_1"), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_2"), (Object)VanillaStructureModifications.singleJigsawPiece("village/desert/houses/desert_temple_2")));
                this.put(new ResourceLocation("village/savanna/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece("village/savanna/houses/savanna_temple_1"), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_2"), (Object)VanillaStructureModifications.singleJigsawPiece("village/savanna/houses/savanna_temple_2")));
                this.put(new ResourceLocation("village/taiga/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/taiga/houses/taiga_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece("village/taiga/houses/taiga_temple_1", (Holder<StructureProcessorList>)ProcessorLists.f_127204_)));
                this.put(new ResourceLocation("village/snowy/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/snowy/houses/snowy_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece("village/snowy/houses/snowy_temple_1")));
                this.put(new ResourceLocation("village/plains/zombie/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_3"), (Object)VanillaStructureModifications.singleJigsawPiece("village/plains/houses/plains_temple_3", (Holder<StructureProcessorList>)ProcessorLists.f_127199_), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_4"), (Object)VanillaStructureModifications.singleJigsawPiece("village/plains/houses/plains_temple_4", (Holder<StructureProcessorList>)ProcessorLists.f_127199_)));
                this.put(new ResourceLocation("village/desert/zombie/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece("village/desert/houses/desert_temple_1", (Holder<StructureProcessorList>)ProcessorLists.f_127203_), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_2"), (Object)VanillaStructureModifications.singleJigsawPiece("village/desert/houses/desert_temple_2", (Holder<StructureProcessorList>)ProcessorLists.f_127203_)));
                this.put(new ResourceLocation("village/savanna/zombie/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece("village/savanna/houses/savanna_temple_1", (Holder<StructureProcessorList>)ProcessorLists.f_127200_), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_2"), (Object)VanillaStructureModifications.singleJigsawPiece("village/savanna/houses/savanna_temple_2", (Holder<StructureProcessorList>)ProcessorLists.f_127200_)));
                this.put(new ResourceLocation("village/taiga/zombie/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/taiga/zombie/houses/taiga_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece("village/taiga/houses/taiga_temple_1", (Holder<StructureProcessorList>)ProcessorLists.f_127202_)));
                this.put(new ResourceLocation("village/snowy/zombie/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/snowy/houses/snowy_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece("village/snowy/houses/snowy_temple_1", (Holder<StructureProcessorList>)ProcessorLists.f_127201_)));
            }
        };
    }

    private static void replaceTemples(RegistryAccess dynamicRegistries, Map<ResourceLocation, Map<String, StructurePoolElement>> patternReplacements) {
        if (!((Boolean)VampirismConfig.COMMON.villageReplaceTemples.get()).booleanValue()) {
            return;
        }
        dynamicRegistries.m_6632_(BuiltinRegistries.f_123864_.m_123023_()).ifPresent(jigsawRegistry -> patternReplacements.forEach((pool, replacements) -> jigsawRegistry.m_6612_(pool).ifPresent(pattern -> replacements.forEach((original, modified) -> {
            ArrayList oldPieces = new ArrayList();
            pattern.f_210560_.removeIf(piece -> {
                if (piece.toString().equals(original)) {
                    oldPieces.add(piece);
                    return true;
                }
                return false;
            });
            int targetCountHalf = oldPieces.size();
            if (targetCountHalf > 1) {
                targetCountHalf = (int)((double)targetCountHalf * 0.6);
            }
            for (int i = 0; i < targetCountHalf; ++i) {
                pattern.f_210560_.add(modified);
                pattern.f_210560_.add((StructurePoolElement)oldPieces.get(i));
            }
            ArrayList weightedElementList = new ArrayList(pattern.f_210559_);
            Optional<Pair> originalPiece = weightedElementList.stream().filter(entry -> ((StructurePoolElement)entry.getFirst()).toString().equals(original)).findAny();
            originalPiece.ifPresent(originalEntry -> {
                weightedElementList.remove(originalPiece.get());
                int targetCountHalf2 = oldPieces.size();
                if (targetCountHalf2 > 1) {
                    targetCountHalf2 = (int)((double)targetCountHalf2 * 0.6);
                }
                weightedElementList.add(new Pair((Object)((StructurePoolElement)originalEntry.getFirst()), (Object)targetCountHalf2));
                weightedElementList.add(new Pair(modified, (Object)targetCountHalf2));
            });
            pattern.f_210559_ = weightedElementList;
        }))));
    }

    private static void addHunterTrainerHouse(RegistryAccess reg, Map<ResourceLocation, BiomeType> pools) {
        reg.m_6632_(BuiltinRegistries.f_123864_.m_123023_()).ifPresent(patternRegistry -> pools.forEach((pool, type) -> patternRegistry.m_6612_(pool).ifPresent(pattern -> {
            SinglePoolElement piece = VanillaStructureModifications.singleJigsawPiece("village/" + type.path + "/houses/hunter_trainer", (Holder<StructureProcessorList>)ProcessorLists.f_127198_);
            for (int i = 0; i < (Integer)VampirismConfig.COMMON.villageHunterTrainerWeight.get(); ++i) {
                pattern.f_210560_.add(piece);
            }
            ArrayList<Pair> weightedElementList = new ArrayList<Pair>(pattern.f_210559_);
            weightedElementList.add(new Pair((Object)piece, (Object)((Integer)VampirismConfig.COMMON.villageHunterTrainerWeight.get())));
            pattern.f_210559_ = weightedElementList;
        })));
    }

    private static void addTotem(RegistryAccess reg, Map<ResourceLocation, BiomeType> pools) {
        RandomStructureProcessor factionProcessor = new RandomStructureProcessor((List<RandomBlockState>)ImmutableList.of((Object)((Object)new RandomBlockState((RuleTest)new RandomBlockMatchTest((Block)ModBlocks.totem_top, ((Double)VampirismConfig.COMMON.villageTotemFactionChance.get()).floatValue()), (RuleTest)AlwaysTrueTest.f_73954_, ModBlocks.totem_top.m_49966_(), TotemTopBlock.getBlocks().stream().filter(totemx -> totemx != ModBlocks.totem_top && !totemx.isCrafted()).map(Block::m_49966_).collect(Collectors.toList())))));
        BiomeTopBlockProcessor biomeTopBlockProcessor = new BiomeTopBlockProcessor(Blocks.f_50493_.m_49966_());
        Holder<StructureProcessorList> TOTEM_FACTION_PROCESSOR = VanillaStructureModifications.registerStructureProcessor("totem_faction", (ImmutableList<StructureProcessor>)ImmutableList.of((Object)((Object)factionProcessor), (Object)((Object)biomeTopBlockProcessor)));
        SinglePoolElement totem = VanillaStructureModifications.singleJigsawPiece("village/totem", TOTEM_FACTION_PROCESSOR);
        reg.m_6632_(BuiltinRegistries.f_123864_.m_123023_()).ifPresent(arg_0 -> VanillaStructureModifications.lambda$addTotem$14(pools, (StructurePoolElement)totem, arg_0));
    }

    private static Holder<StructureProcessorList> registerStructureProcessor(String pId, ImmutableList<StructureProcessor> pProcessors) {
        ResourceLocation resourcelocation = new ResourceLocation("vampirism", pId);
        StructureProcessorList structureprocessorlist = new StructureProcessorList(pProcessors);
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123863_, (ResourceLocation)resourcelocation, (Object)structureprocessorlist);
    }

    private static SinglePoolElement singleJigsawPiece(@Nonnull String path) {
        return VanillaStructureModifications.singleJigsawPiece(path, (Holder<StructureProcessorList>)ProcessorLists.f_127198_);
    }

    private static SinglePoolElement singleJigsawPiece(@Nonnull String path, @Nonnull Holder<StructureProcessorList> processors) {
        return (SinglePoolElement)SinglePoolElement.m_210531_((String)("vampirism:" + path), processors).apply(StructureTemplatePool.Projection.RIGID);
    }

    private static Function<StructureTemplatePool.Projection, SinglePoolElement> singleJigsawPieceFunction(@Nonnull String path) {
        return VanillaStructureModifications.singleJigsawPieceFunction(path, (Holder<StructureProcessorList>)ProcessorLists.f_127198_);
    }

    private static Function<StructureTemplatePool.Projection, SinglePoolElement> singleJigsawPieceFunction(@Nonnull String path, @Nonnull Holder<StructureProcessorList> processors) {
        return SinglePoolElement.m_210531_((String)("vampirism:" + path), processors);
    }

    private static String singleJigsawString(String resourceLocation) {
        return "Single[Left[" + resourceLocation + "]]";
    }

    private static String singleLegacyJigsawString(String resourceLocation) {
        return "LegacySingle[Left[" + resourceLocation + "]]";
    }

    private static /* synthetic */ void lambda$addTotem$14(Map pools, StructurePoolElement totem, Registry patternRegistry) {
        pools.forEach((pool, type) -> patternRegistry.m_6612_(pool).ifPresent(pattern -> {
            for (int i = 0; i < (Integer)VampirismConfig.COMMON.villageTotemWeight.get(); ++i) {
                pattern.f_210560_.add(totem);
            }
            ArrayList<Pair> weightedElementList = new ArrayList<Pair>(pattern.f_210559_);
            weightedElementList.add(new Pair((Object)totem, (Object)((Integer)VampirismConfig.COMMON.villageTotemWeight.get())));
            pattern.f_210559_ = weightedElementList;
        }));
    }

    private static enum BiomeType {
        PLAINS("plains"),
        TAIGA("taiga"),
        DESERT("desert"),
        SNOWY("snowy"),
        SAVANNA("savanna"),
        BADLANDS("badlands"),
        BIRCH("birch"),
        DARK_FOREST("dark_forest"),
        CRIMSON("crimson"),
        GIANT_TAIGA("giant_taiga"),
        JUNGLE("jungle"),
        MOUNTAINS("mountains"),
        OAK("oak"),
        SWAMP("swamp"),
        WARPED("warped");

        public final String path;

        private BiomeType(String path) {
            this.path = path;
        }
    }
}

