/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DifficultyCalculator {
    @Nullable
    private static Difficulty calculateDifficulty(List<? extends Player> playerList) {
        if (playerList == null || playerList.isEmpty()) {
            return null;
        }
        int min = Integer.MAX_VALUE;
        int max = 0;
        int sum = 0;
        for (Player player : playerList) {
            if (!player.m_6084_()) continue;
            LazyOptional<FactionPlayerHandler> handler = FactionPlayerHandler.getOpt(player);
            int pLevel = handler.map(FactionPlayerHandler::getCurrentLevel).orElse(0);
            if (pLevel == 0) {
                min = 0;
                continue;
            }
            int level = (int)((float)pLevel / (float)handler.map(FactionPlayerHandler::getCurrentFaction).map(IPlayableFaction::getHighestReachableLevel).orElse(pLevel).intValue() * 100.0f);
            if (level < min) {
                min = level;
            }
            if (level > max) {
                max = level;
            }
            sum += max;
        }
        return new Difficulty(min, max, Math.round((float)sum / (float)playerList.size()));
    }

    public static Difficulty getWorldDifficulty(Level w) {
        return DifficultyCalculator.calculateDifficulty(w.m_6907_());
    }

    public static Difficulty getLocalDifficulty(Level w, BlockPos center, int radius) {
        List list = w.m_45976_(Player.class, UtilLib.createBB(center, radius, true));
        return DifficultyCalculator.calculateDifficulty(list);
    }

    public static Difficulty getGlobalDifficulty() {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            throw new IllegalStateException("You can only use this method on server side");
        }
        return DifficultyCalculator.calculateDifficulty(ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_());
    }

    @Nonnull
    public static Difficulty findDifficultyForPos(Level world, BlockPos pos, int radius) {
        Difficulty d = DifficultyCalculator.getLocalDifficulty(world, pos, radius);
        if (d == null && (d = DifficultyCalculator.getWorldDifficulty(world)) == null && (d = DifficultyCalculator.getGlobalDifficulty()) == null) {
            d = new Difficulty(0, 0, 0);
        }
        return d;
    }
}

