/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.proxy;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.client.VIngameOverlays;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.blockentity.GarlicDiffuserBlockEntity;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.client.core.ClientEventHandler;
import de.teamlapen.vampirism.client.core.ModBlocksRender;
import de.teamlapen.vampirism.client.core.ModItemsRender;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.core.ModParticleFactories;
import de.teamlapen.vampirism.client.core.ModScreens;
import de.teamlapen.vampirism.client.gui.ActionSelectScreen;
import de.teamlapen.vampirism.client.gui.DBNOScreen;
import de.teamlapen.vampirism.client.gui.GarlicDiffuserScreen;
import de.teamlapen.vampirism.client.gui.NameSwordScreen;
import de.teamlapen.vampirism.client.gui.RevertBackScreen;
import de.teamlapen.vampirism.client.gui.ScreenEventHandler;
import de.teamlapen.vampirism.client.gui.SelectMinionScreen;
import de.teamlapen.vampirism.client.gui.SkillsScreen;
import de.teamlapen.vampirism.client.gui.SleepInMultiplayerModScreen;
import de.teamlapen.vampirism.client.gui.overlay.BloodBarOverlay;
import de.teamlapen.vampirism.client.gui.overlay.CustomBossEventOverlay;
import de.teamlapen.vampirism.client.gui.overlay.FactionLevelOverlay;
import de.teamlapen.vampirism.client.gui.overlay.VampirismHUDOverlay;
import de.teamlapen.vampirism.client.render.RenderHandler;
import de.teamlapen.vampirism.client.render.VampirismBlockEntityWitoutLevelRenderer;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.inventory.container.TaskBoardContainer;
import de.teamlapen.vampirism.inventory.container.VampirismContainer;
import de.teamlapen.vampirism.network.BloodValuePacket;
import de.teamlapen.vampirism.network.MultiBossEventPacket;
import de.teamlapen.vampirism.network.OpenVampireBookPacket;
import de.teamlapen.vampirism.network.PlayEventPacket;
import de.teamlapen.vampirism.network.RequestMinionSelectPacket;
import de.teamlapen.vampirism.network.SkillTreePacket;
import de.teamlapen.vampirism.network.TaskPacket;
import de.teamlapen.vampirism.network.TaskStatusPacket;
import de.teamlapen.vampirism.player.skills.ClientSkillTreeManager;
import de.teamlapen.vampirism.player.skills.SkillTree;
import de.teamlapen.vampirism.proxy.CommonProxy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final Logger LOGGER = LogManager.getLogger(ClientProxy.class);
    private final ClientSkillTreeManager skillTreeManager = new ClientSkillTreeManager();
    private VampirismHUDOverlay overlay;
    private CustomBossEventOverlay bossInfoOverlay;
    private VampirismBlockEntityWitoutLevelRenderer itemStackBESR;

    public ClientProxy() {
        RenderHandler renderHandler = new RenderHandler(Minecraft.m_91087_());
        MinecraftForge.EVENT_BUS.register((Object)renderHandler);
        if (Minecraft.m_91087_() != null) {
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)renderHandler);
        }
    }

    public void clearBossBarOverlay() {
        this.bossInfoOverlay.clear();
    }

    @Override
    public void displayGarlicBeaconScreen(GarlicDiffuserBlockEntity tile, Component title) {
        Minecraft.m_91087_().m_91152_((Screen)new GarlicDiffuserScreen(tile, title));
    }

    @Override
    public void displayNameSwordScreen(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new NameSwordScreen(stack));
    }

    @Override
    public void displayRevertBackScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new RevertBackScreen());
    }

    @Override
    @Nullable
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public VampirismBlockEntityWitoutLevelRenderer getItemStackBESR() {
        return this.itemStackBESR;
    }

    @Override
    @Nullable
    public Entity getMouseOverEntity() {
        HitResult r = Minecraft.m_91087_().f_91077_;
        if (r instanceof EntityHitResult) {
            return ((EntityHitResult)r).m_82443_();
        }
        return null;
    }

    @Override
    public float getRenderPartialTick() {
        return Minecraft.m_91087_().m_91296_();
    }

    @Override
    public SkillTree getSkillTree(boolean client) {
        return client ? this.skillTreeManager.getSkillTree() : super.getSkillTree(false);
    }

    @Override
    public void handleBloodValuePacket(BloodValuePacket msg) {
        ((VampirismEntityRegistry)VampirismAPI.entityRegistry()).applyNewResources((Map)msg.getValues()[0].getFirst(), (Integer)msg.getValues()[0].getSecond());
        BloodConversionRegistry.applyNewItemResources((Map)msg.getValues()[1].getFirst(), (Integer)msg.getValues()[1].getSecond());
        BloodConversionRegistry.applyNewFluidResources((Map)msg.getValues()[2].getFirst(), (Integer)msg.getValues()[2].getSecond());
    }

    @Override
    public void handlePlayEventPacket(PlayEventPacket msg) {
        if (msg.type() == 1) {
            this.spawnParticles((Level)Minecraft.m_91087_().f_91073_, msg.pos(), Block.m_49803_((int)msg.stateId()));
        }
    }

    @Override
    public void handleRequestMinionSelect(RequestMinionSelectPacket.Action action, List<Pair<Integer, Component>> minions) {
        Minecraft.m_91087_().m_91152_((Screen)new SelectMinionScreen(action, minions));
    }

    @Override
    public void handleSkillTreePacket(SkillTreePacket msg) {
        this.skillTreeManager.loadUpdate(msg);
    }

    @Override
    public void handleSleepClient(Player player) {
        if (player.m_5803_()) {
            player.m_21257_().ifPresent(pos -> {
                if (player.f_19853_.m_8055_(pos).m_60734_() instanceof TentBlock) {
                    if (Minecraft.m_91087_().f_91080_ instanceof InBedChatScreen && !(Minecraft.m_91087_().f_91080_ instanceof SleepInMultiplayerModScreen)) {
                        Minecraft.m_91087_().m_91152_((Screen)new SleepInMultiplayerModScreen("text.vampirism.tent.stop_sleeping"));
                    }
                    TentBlock.setTentSleepPosition(player, pos, (Integer)player.f_19853_.m_8055_(pos).m_61143_((Property)TentBlock.POSITION), (Direction)player.f_19853_.m_8055_(pos).m_61143_((Property)TentBlock.FACING));
                } else if (player.f_19853_.m_8055_(pos).m_60734_() instanceof CoffinBlock && Minecraft.m_91087_().f_91080_ instanceof InBedChatScreen && !(Minecraft.m_91087_().f_91080_ instanceof SleepInMultiplayerModScreen)) {
                    Minecraft.m_91087_().m_91152_((Screen)new SleepInMultiplayerModScreen("text.vampirism.coffin.stop_sleeping"));
                }
            });
        }
    }

    @Override
    public void handleTaskPacket(TaskPacket msg) {
        AbstractContainerMenu container = Minecraft.m_91087_().f_91074_.f_36096_;
        if (msg.containerId() == container.f_38840_ && container instanceof VampirismContainer) {
            ((VampirismContainer)container).init(msg.taskWrappers(), msg.completableTasks(), msg.completedRequirements());
        }
    }

    @Override
    public void handleTaskStatusPacket(TaskStatusPacket msg) {
        AbstractContainerMenu container = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).f_36096_;
        if (msg.containerId() == container.f_38840_ && container instanceof TaskBoardContainer) {
            ((TaskBoardContainer)container).init(msg.available(), msg.completableTasks(), msg.completedRequirements(), msg.taskBoardId());
        }
    }

    @Override
    public void handleUpdateMultiBossInfoPacket(MultiBossEventPacket msg) {
        this.bossInfoOverlay.read(msg);
    }

    @Override
    public void handleVampireBookPacket(OpenVampireBookPacket msg) {
        Minecraft.m_91087_().m_91152_((Screen)new BookViewScreen((BookViewScreen.BookAccess)new BookViewScreen.WrittenBookAccess(msg.itemStack())));
    }

    @Override
    public void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        super.onInitStep(step, event);
        switch (step) {
            case CLIENT_SETUP: {
                this.overlay = new VampirismHUDOverlay(Minecraft.m_91087_());
                ModKeys.register();
                this.registerSubscriptions();
                ActionSelectScreen.loadActionOrder();
                ModBlocksRender.register();
                OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (String)"vampirism_faction_level", (IIngameOverlay)VIngameOverlays.FACTION_LEVEL_ELEMENT);
                OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.BOSS_HEALTH_ELEMENT, (String)"vampirism_raid_bar", (IIngameOverlay)VIngameOverlays.FACTION_RAID_BAR_ELEMENT);
                OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.FOOD_LEVEL_ELEMENT, (String)"vampirism_blood_bar", (IIngameOverlay)VIngameOverlays.BLOOD_BAR_ELEMENT);
                break;
            }
            case LOAD_COMPLETE: {
                event.enqueueWork(ModBlocksRender::registerColorsUnsafe);
                event.enqueueWork(ModItemsRender::registerColorsUnsafe);
                event.enqueueWork(ModItemsRender::registerItemModelPropertyUnsafe);
                event.enqueueWork(ModParticleFactories::registerFactoriesUnsafe);
                event.enqueueWork(ModScreens::registerScreensUnsafe);
                this.skillTreeManager.init();
                this.itemStackBESR = new VampirismBlockEntityWitoutLevelRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
                break;
            }
        }
    }

    @Override
    public void renderScreenFullColor(int ticksOn, int ticksOff, int color) {
        if (this.overlay != null) {
            this.overlay.makeRenderFullColor(ticksOn, ticksOff, color);
        }
    }

    @Override
    public void resetSkillScreenCache() {
        if (Minecraft.m_91087_().f_91080_ instanceof SkillsScreen) {
            ((SkillsScreen)Minecraft.m_91087_().f_91080_).resetToolTipCache();
        }
    }

    @Override
    public void showDBNOScreen(Player playerEntity, @Nullable Component deathMessage) {
        if (playerEntity == Minecraft.m_91087_().f_91074_ && !playerEntity.m_21224_()) {
            Minecraft.m_91087_().m_91152_((Screen)new DBNOScreen(deathMessage));
        }
    }

    private void registerSubscriptions() {
        MinecraftForge.EVENT_BUS.register((Object)this.overlay);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ScreenEventHandler());
    }

    @Override
    public void setupAPIClient() {
        this.bossInfoOverlay = new CustomBossEventOverlay();
        VIngameOverlays.FACTION_RAID_BAR_ELEMENT = this.bossInfoOverlay;
        VIngameOverlays.BLOOD_BAR_ELEMENT = new BloodBarOverlay();
        VIngameOverlays.FACTION_LEVEL_ELEMENT = new FactionLevelOverlay();
    }

    private void spawnParticles(Level world, BlockPos pos, BlockState state) {
        if (!(world instanceof ClientLevel)) {
            return;
        }
        VoxelShape voxelshape = state.m_60808_((BlockGetter)world, pos);
        voxelshape.m_83286_((p_199284_3_, p_199284_5_, p_199284_7_, p_199284_9_, p_199284_11_, p_199284_13_) -> {
            double d1 = Math.min(1.0, p_199284_9_ - p_199284_3_);
            double d2 = Math.min(1.0, p_199284_11_ - p_199284_5_);
            double d3 = Math.min(1.0, p_199284_13_ - p_199284_7_);
            int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
            int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
            int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
            for (int l = 0; l < i / 2; ++l) {
                for (int i1 = 0; i1 < j / 2; ++i1) {
                    for (int j1 = 0; j1 < k / 2; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + p_199284_3_;
                        double d8 = d5 * d2 + p_199284_5_;
                        double d9 = d6 * d3 + p_199284_7_;
                        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new TerrainParticle((ClientLevel)world, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state));
                    }
                }
            }
        });
    }
}

