/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModRefinements;
import net.minecraft.world.effect.MobEffectInstance;

public class SunscreenVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    @Override
    public boolean activate(IVampirePlayer vampire) {
        this.addEffectInstance(vampire, new MobEffectInstance(ModEffects.sunscreen, this.getDuration(vampire), 3, false, false));
        return true;
    }

    @Override
    public int getCooldown(IVampirePlayer player) {
        return (Integer)VampirismConfig.BALANCE.vaSunscreenCooldown.get() * 20;
    }

    @Override
    public int getDuration(IVampirePlayer player) {
        int duration = 20 * (Integer)VampirismConfig.BALANCE.vaSunscreenDuration.get();
        if (player.getSkillHandler().isRefinementEquipped(ModRefinements.sun_screen)) {
            duration = (int)((double)duration * (Double)VampirismConfig.BALANCE.vrSunscreenDurationMod.get());
        }
        return duration;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaSunscreenEnabled.get();
    }

    @Override
    public void onActivatedClient(IVampirePlayer vampire) {
    }

    @Override
    public void onDeactivated(IVampirePlayer vampire) {
        this.removePotionEffect(vampire, ModEffects.sunscreen);
    }

    @Override
    public void onReActivated(IVampirePlayer vampire) {
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        return false;
    }
}

