/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.network.SkillTreePacket;
import de.teamlapen.vampirism.player.skills.SkillNode;
import de.teamlapen.vampirism.player.skills.SkillTree;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillTreeManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(SkillNode.Builder.class, (json, typeOfT, context) -> {
        JsonObject asObject = GsonHelper.m_13918_((JsonElement)json, (String)"skillnode");
        return SkillNode.Builder.deserialize(asObject, context);
    }).create();
    private static SkillTreeManager instance;
    private final SkillTree skillTree = new SkillTree();

    public static SkillTreeManager getInstance() {
        if (instance == null) {
            instance = new SkillTreeManager();
        }
        return instance;
    }

    private SkillTreeManager() {
        super(GSON, "vampirismskillnodes");
    }

    public SkillTree getSkillTree() {
        return this.skillTree;
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceLocationJsonObjectMap, @Nonnull ResourceManager iResourceManager, @Nonnull ProfilerFiller iProfiler) {
        HashMap<ResourceLocation, SkillNode.Builder> parsed = new HashMap<ResourceLocation, SkillNode.Builder>();
        resourceLocationJsonObjectMap.forEach((id, object) -> {
            try {
                SkillNode.Builder builder = (SkillNode.Builder)GSON.fromJson(object, SkillNode.Builder.class);
                if (builder != null) {
                    parsed.put((ResourceLocation)id, builder);
                }
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("Failed to load skill node {}: {}", id, (Object)e.getMessage());
            }
        });
        this.skillTree.loadNodes(parsed);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            VampirismMod.dispatcher.sendToAll(new SkillTreePacket(this.skillTree.getCopy()));
        }
    }
}

