/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillNode {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SkillNode parent;
    private final List<SkillNode> children;
    private final ISkill<?>[] elements;
    private final ResourceLocation[] lockingNodes;
    private final int depth;
    private final IPlayableFaction<?> faction;
    private final ResourceLocation id;

    private SkillNode(ResourceLocation id, IPlayableFaction<?> faction, SkillNode parent, int depth, ISkill<?>[] elements, ResourceLocation ... lockingNodes) {
        this.id = id;
        this.parent = parent;
        this.faction = faction;
        this.depth = depth;
        this.children = new ArrayList<SkillNode>();
        this.elements = elements;
        this.lockingNodes = lockingNodes;
    }

    public SkillNode(IPlayableFaction<?> faction, ISkill<?> element) {
        this(faction.getID(), faction, null, 0, new ISkill[]{element}, new ResourceLocation[0]);
    }

    public SkillNode(ResourceLocation id, SkillNode parent, ISkill<?>[] elements, ResourceLocation ... lockingNodes) {
        this(id, parent.getFaction(), parent, parent.depth + 1, elements, lockingNodes);
        parent.children.add(this);
    }

    public boolean containsSkill(ISkill<?> skill) {
        return ArrayUtils.contains((Object[])this.elements, skill);
    }

    public List<SkillNode> getChildren() {
        return this.children;
    }

    public Builder getCopy() {
        return new Builder(this.parent.id, null, Arrays.asList(this.elements), Arrays.asList(this.lockingNodes));
    }

    public int getDepth() {
        return this.depth;
    }

    public ISkill<?>[] getElements() {
        return this.elements;
    }

    public IPlayableFaction<?> getFaction() {
        return this.faction;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation[] getLockingNodes() {
        return this.lockingNodes;
    }

    public SkillNode getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String toString() {
        return "SkillNode{faction=" + this.faction + ", depth=" + this.depth + ", elements=" + Arrays.toString(this.elements) + "}";
    }

    public static class Builder {
        public final List<ResourceLocation> lockingNodes;
        public final ResourceLocation parentId;
        public final List<ISkill<?>> skills;
        public final ResourceLocation mergeId;

        public static Builder deserialize(JsonObject json, JsonDeserializationContext context) {
            if (json.has("remove") && GsonHelper.m_13912_((JsonObject)json, (String)"remove")) {
                return null;
            }
            ResourceLocation parent = json.has("parent") ? new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"parent")) : null;
            ResourceLocation merge = json.has("merge") ? new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"merge")) : null;
            JsonArray skills = GsonHelper.m_13832_((JsonObject)json, (String)"skills", (JsonArray)new JsonArray());
            ArrayList skillList = new ArrayList();
            for (int i = 0; i < skills.size(); ++i) {
                ResourceLocation id = new ResourceLocation(GsonHelper.m_13805_((JsonElement)skills.get(i), (String)"skill"));
                ISkill s = (ISkill)ModRegistries.SKILLS.getValue(id);
                if (s == null) {
                    throw new IllegalArgumentException("Skill " + id + " is not registered");
                }
                skillList.add(s);
            }
            JsonArray locking = GsonHelper.m_13832_((JsonObject)json, (String)"locking", (JsonArray)new JsonArray());
            ArrayList<ResourceLocation> lockingList = new ArrayList<ResourceLocation>();
            for (int i = 0; i < locking.size(); ++i) {
                lockingList.add(new ResourceLocation(GsonHelper.m_13805_((JsonElement)locking.get(i), (String)"skill")));
            }
            return new Builder(parent, merge, skillList, lockingList);
        }

        public static Builder readFrom(FriendlyByteBuf buf) {
            ResourceLocation parent = buf.readBoolean() ? buf.m_130281_() : null;
            ResourceLocation merge = buf.readBoolean() ? buf.m_130281_() : null;
            ArrayList skillList = new ArrayList();
            int count = buf.m_130242_();
            for (int i = 0; i < count; ++i) {
                ResourceLocation id = buf.m_130281_();
                ISkill s = (ISkill)ModRegistries.SKILLS.getValue(id);
                if (s == null) {
                    LOGGER.warn("Skill {} is not registered", (Object)id);
                }
                skillList.add(s);
            }
            ArrayList<ResourceLocation> lockingList = new ArrayList<ResourceLocation>();
            int count2 = buf.m_130242_();
            for (int i = 0; i < count2; ++i) {
                lockingList.add(buf.m_130281_());
            }
            return new Builder(parent, merge, skillList, lockingList);
        }

        private Builder(ResourceLocation parentId, ResourceLocation mergeId, List<ISkill<?>> skills, List<ResourceLocation> lockingNodes) {
            this.mergeId = mergeId;
            this.parentId = parentId;
            this.skills = skills;
            this.lockingNodes = lockingNodes;
        }

        public SkillNode build(ResourceLocation id, SkillNode parent) {
            return new SkillNode(id, parent, this.skills.toArray(new ISkill[0]), this.lockingNodes.toArray(new ResourceLocation[0]));
        }

        public boolean checkSkillFaction(IPlayableFaction<?> faction) {
            for (ISkill<?> s : this.skills) {
                if (faction.getID().equals((Object)s.getFaction().getID())) continue;
                return false;
            }
            return true;
        }

        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            if (this.parentId != null) {
                jsonobject.addProperty("parent", this.parentId.toString());
            } else if (this.mergeId != null) {
                jsonobject.addProperty("merge", this.mergeId.toString());
            }
            JsonArray skillIds = new JsonArray();
            for (ISkill<?> s : this.skills) {
                skillIds.add(s.getRegistryName().toString());
            }
            jsonobject.add("skills", (JsonElement)skillIds);
            if (!this.lockingNodes.isEmpty()) {
                JsonArray lockedIds = new JsonArray();
                for (ResourceLocation s : this.lockingNodes) {
                    lockedIds.add(s.toString());
                }
                jsonobject.add("locking", (JsonElement)skillIds);
            }
            return jsonobject;
        }

        public String toString() {
            return "SkillNode.Builder{parent=" + this.parentId + ",merge=" + this.mergeId + "skills" + this.skills.toString() + "}";
        }

        public void writeTo(FriendlyByteBuf buf) {
            if (this.parentId == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.m_130085_(this.parentId);
            }
            if (this.mergeId == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.m_130085_(this.mergeId);
            }
            buf.m_130130_(this.skills.size());
            for (ISkill<?> iSkill : this.skills) {
                buf.m_130085_(iSkill.getRegistryName());
            }
            buf.m_130130_(this.lockingNodes.size());
            for (ResourceLocation resourceLocation : this.lockingNodes) {
                buf.m_130085_(resourceLocation);
            }
        }
    }
}

