/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.player.skills.SkillNode;
import de.teamlapen.vampirism.player.skills.SkillTreeManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillHandler<T extends IFactionPlayer<T>>
implements ISkillHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger(SkillHandler.class);
    private final ArrayList<ISkill<T>> enabledSkills = new ArrayList();
    private final T player;
    private final IPlayableFaction<T> faction;
    private final IRefinementSet[] appliedRefinementSets = new IRefinementSet[3];
    private final int[] refinementSetDamage = new int[3];
    private final Set<IRefinement> activeRefinements = new HashSet<IRefinement>();
    private final Map<IRefinement, AttributeModifier> refinementModifier = new HashMap<IRefinement, AttributeModifier>();
    private boolean dirty = false;

    public SkillHandler(T player, IPlayableFaction<T> faction) {
        this.player = player;
        this.faction = faction;
    }

    public Optional<SkillNode> anyLastNode() {
        SkillNode rootNode = this.getRootNode();
        ArrayDeque<SkillNode> queue = new ArrayDeque<SkillNode>();
        queue.add(rootNode);
        SkillNode skillNode = (SkillNode)queue.poll();
        while (skillNode != null) {
            List child = skillNode.getChildren().stream().filter(this::isNodeEnabled).collect(Collectors.toList());
            if (child.isEmpty()) {
                if (skillNode == rootNode) {
                    skillNode = null;
                }
                return Optional.ofNullable(skillNode);
            }
            queue.addAll(child);
            skillNode = (SkillNode)queue.poll();
        }
        return Optional.empty();
    }

    @Override
    public ISkillHandler.Result canSkillBeEnabled(ISkill<T> skill) {
        if (this.player.getRepresentingPlayer().m_21124_(ModEffects.oblivion) != null) {
            return ISkillHandler.Result.LOCKED_BY_PLAYER_STATE;
        }
        if (this.isSkillEnabled(skill)) {
            return ISkillHandler.Result.ALREADY_ENABLED;
        }
        SkillNode node = this.findSkillNode(this.getRootNode(), skill);
        if (node != null) {
            if (this.isSkillNodeLocked(node)) {
                return ISkillHandler.Result.LOCKED_BY_OTHER_NODE;
            }
            if (node.isRoot() || this.isNodeEnabled(node.getParent())) {
                if (this.getLeftSkillPoints() > 0) {
                    return this.isNodeEnabled(node) ? ISkillHandler.Result.OTHER_NODE_SKILL : ISkillHandler.Result.OK;
                }
                return ISkillHandler.Result.NO_POINTS;
            }
            return ISkillHandler.Result.PARENT_NOT_ENABLED;
        }
        LOGGER.warn("Node for skill {} could not be found", skill);
        return ISkillHandler.Result.NOT_FOUND;
    }

    @Override
    public ItemStack[] createRefinementItems() {
        ItemStack[] items = new ItemStack[this.appliedRefinementSets.length];
        for (int i = 0; i < this.appliedRefinementSets.length; ++i) {
            if (this.appliedRefinementSets[i] == null) continue;
            items[i] = new ItemStack(this.faction.getRefinementItem(IRefinementItem.AccessorySlotType.values()[i]));
            ((IRefinementItem)this.faction.getRefinementItem(IRefinementItem.AccessorySlotType.values()[i])).applyRefinementSet(items[i], this.appliedRefinementSets[i]);
            items[i].m_41721_(this.refinementSetDamage[i]);
        }
        return items;
    }

    @Override
    public void damageRefinements() {
        for (int i = 0; i < this.refinementSetDamage.length; ++i) {
            if (this.appliedRefinementSets[i] == null) continue;
            int damage = 40 + (this.appliedRefinementSets[i].getRarity().weight - 1) * 10 + this.getPlayer().getRepresentingPlayer().m_21187_().nextInt(60);
            int n = i;
            this.refinementSetDamage[n] = this.refinementSetDamage[n] + damage;
            if (this.refinementSetDamage[n] < 500) continue;
            this.removeRefinementSet(i);
        }
    }

    public void disableAllSkills() {
        for (ISkill<T> skill : this.enabledSkills) {
            skill.onDisable(this.player);
        }
        this.enabledSkills.clear();
        this.dirty = true;
    }

    @Override
    public void disableSkill(ISkill<T> skill) {
        if (this.enabledSkills.remove(skill)) {
            skill.onDisable(this.player);
            this.dirty = true;
        }
    }

    public void enableRootSkill() {
        this.enableSkill(this.getRootNode().getElements()[0]);
    }

    @Override
    public void enableSkill(ISkill<T> skill) {
        if (!this.enabledSkills.contains(skill)) {
            skill.onEnable(this.player);
            this.enabledSkills.add(skill);
            this.dirty = true;
            if (this.player.getRepresentingPlayer() instanceof ServerPlayer) {
                ModAdvancements.TRIGGER_SKILL_UNLOCKED.trigger((ServerPlayer)this.player.getRepresentingPlayer(), skill);
            }
        }
    }

    @Override
    public boolean equipRefinementItem(ItemStack stack) {
        IRefinementItem refinementItem;
        Item item = stack.m_41720_();
        if (item instanceof IRefinementItem && (refinementItem = (IRefinementItem)item).getExclusiveFaction(stack).equals(this.faction)) {
            IRefinementSet newSet = refinementItem.getRefinementSet(stack);
            IRefinementItem.AccessorySlotType setSlot = refinementItem.getSlotType();
            this.removeRefinementItem(setSlot);
            this.dirty = true;
            if (newSet != null && newSet.getFaction() == this.faction) {
                this.applyRefinementSet(newSet, setSlot.getSlot());
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeRefinementItem(IRefinementItem.AccessorySlotType slot) {
        this.removeRefinementSet(slot.getSlot());
        this.dirty = true;
    }

    public SkillNode findSkillNode(SkillNode base, ISkill<T> skill) {
        for (ISkill<?> s : base.getElements()) {
            if (!s.equals(skill)) continue;
            return base;
        }
        for (SkillNode child : base.getChildren()) {
            SkillNode node = this.findSkillNode(child, skill);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getLeftSkillPoints() {
        int level = this.player.getLevel();
        int totalSkillPoints = (int)((double)level * (Double)VampirismConfig.BALANCE.skillPointsPerLevel.get());
        int remainingSkillPoints = totalSkillPoints - this.enabledSkills.size();
        if (((Boolean)VampirismConfig.SERVER.unlockAllSkills.get()).booleanValue() && level == this.player.getMaxLevel()) {
            return Math.max(remainingSkillPoints, 1);
        }
        return remainingSkillPoints;
    }

    public List<ISkill<T>> getLockingSkills(SkillNode nodeIn) {
        return Arrays.stream(nodeIn.getLockingNodes()).map(id -> SkillTreeManager.getInstance().getSkillTree().getNodeFromId((ResourceLocation)id)).filter(Objects::nonNull).flatMap(node -> Arrays.stream(node.getElements())).collect(Collectors.toList());
    }

    @Override
    public ISkill<T>[] getParentSkills(ISkill<T> skill) {
        SkillNode node = this.findSkillNode(this.getRootNode(), skill);
        if (node == null) {
            return null;
        }
        return node.getParent().getElements();
    }

    public T getPlayer() {
        return this.player;
    }

    public SkillNode getRootNode() {
        return VampirismMod.proxy.getSkillTree(this.player.isRemote()).getRootNodeForFaction(this.faction.getID());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isNodeEnabled(SkillNode node) {
        for (ISkill<T> s : this.enabledSkills) {
            if (!node.containsSkill(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRefinementEquipped(IRefinement refinement) {
        return this.activeRefinements.contains(refinement);
    }

    @Override
    public boolean isSkillEnabled(ISkill<?> skill) {
        return this.enabledSkills.contains(skill);
    }

    public boolean isSkillNodeLocked(SkillNode nodeIn) {
        return Arrays.stream(nodeIn.getLockingNodes()).map(id -> SkillTreeManager.getInstance().getSkillTree().getNodeFromId((ResourceLocation)id)).filter(Objects::nonNull).flatMap(node -> Arrays.stream(node.getElements())).anyMatch(this::isSkillEnabled);
    }

    public void loadFromNbt(CompoundTag nbt) {
        if (nbt.m_128441_("skills")) {
            for (String id : nbt.m_128469_("skills").m_128431_()) {
                ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(id));
                if (skill == null) {
                    LOGGER.warn("Skill {} does not exist anymore", (Object)id);
                    continue;
                }
                this.enableSkill(skill);
            }
        }
        if (nbt.m_128441_("refinement_set")) {
            CompoundTag setsNBT = nbt.m_128469_("refinement_set");
            for (String id : setsNBT.m_128431_()) {
                int i = Integer.parseInt(id);
                CompoundTag setNBT = setsNBT.m_128469_(id);
                String setName = setNBT.m_128461_("id");
                int damage = setNBT.m_128451_("damage");
                if ("none".equals(setName)) continue;
                ResourceLocation setId = new ResourceLocation(setName);
                IRefinementSet set = (IRefinementSet)ModRegistries.REFINEMENT_SETS.getValue(setId);
                this.applyRefinementSet(set, i);
                this.refinementSetDamage[i] = damage;
            }
        }
    }

    public void readUpdateFromServer(CompoundTag nbt) {
        if (nbt.m_128441_("skills")) {
            List old = (List)this.enabledSkills.clone();
            for (String id : nbt.m_128469_("skills").m_128431_()) {
                ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(id));
                if (skill == null) {
                    LOGGER.error("Skill {} does not exist on client!!!", (Object)id);
                    continue;
                }
                if (old.contains(skill)) {
                    old.remove(skill);
                    continue;
                }
                this.enableSkill(skill);
            }
            for (ISkill skill : old) {
                this.disableSkill(skill);
            }
            VampirismMod.proxy.resetSkillScreenCache();
        }
        if (nbt.m_128441_("refinement_set")) {
            CompoundTag setsNBT = nbt.m_128469_("refinement_set");
            for (String id : setsNBT.m_128431_()) {
                IRefinementSet oldSet;
                int i = Integer.parseInt(id);
                CompoundTag setNBT = setsNBT.m_128469_(id);
                String setName = setNBT.m_128461_("id");
                int damage = setNBT.m_128451_("damage");
                IRefinementSet set = null;
                if (!"none".equals(setName)) {
                    set = (IRefinementSet)ModRegistries.REFINEMENT_SETS.getValue(new ResourceLocation(setName));
                }
                if ((oldSet = this.appliedRefinementSets[i]) != set) {
                    this.removeRefinementSet(i);
                    this.applyRefinementSet(set, i);
                }
                this.refinementSetDamage[i] = damage;
            }
        }
    }

    @Override
    public void resetRefinements() {
        for (int i = 0; i < this.appliedRefinementSets.length; ++i) {
            this.removeRefinementSet(i);
        }
    }

    @Override
    public void resetSkills() {
        this.disableAllSkills();
        this.enableRootSkill();
    }

    public void saveToNbt(CompoundTag nbt) {
        CompoundTag skills = new CompoundTag();
        for (ISkill<T> skill : this.enabledSkills) {
            skills.m_128379_(skill.getRegistryName().toString(), true);
        }
        nbt.m_128365_("skills", (Tag)skills);
        CompoundTag refinements = new CompoundTag();
        for (int i = 0; i < this.appliedRefinementSets.length; ++i) {
            CompoundTag setNbt = new CompoundTag();
            IRefinementSet set = this.appliedRefinementSets[i];
            int damage = this.refinementSetDamage[i];
            setNbt.m_128359_("id", set != null ? set.getRegistryName().toString() : "none");
            setNbt.m_128405_("damage", damage);
            refinements.m_128365_(String.valueOf(i), (Tag)setNbt);
        }
        nbt.m_128365_("refinement_set", (Tag)refinements);
    }

    public void writeUpdateForClient(CompoundTag nbt) {
        CompoundTag skills = new CompoundTag();
        for (ISkill<T> skill : this.enabledSkills) {
            skills.m_128379_(skill.getRegistryName().toString(), true);
        }
        nbt.m_128365_("skills", (Tag)skills);
        CompoundTag refinements = new CompoundTag();
        for (int i = 0; i < this.appliedRefinementSets.length; ++i) {
            CompoundTag setNbt = new CompoundTag();
            IRefinementSet set = this.appliedRefinementSets[i];
            int damage = this.refinementSetDamage[i];
            setNbt.m_128359_("id", set != null ? set.getRegistryName().toString() : "none");
            setNbt.m_128405_("damage", damage);
            refinements.m_128365_(String.valueOf(i), (Tag)setNbt);
        }
        nbt.m_128365_("refinement_set", (Tag)refinements);
        this.dirty = false;
    }

    private void applyRefinementSet(@Nullable IRefinementSet set, int slot) {
        this.appliedRefinementSets[slot] = set;
        this.refinementSetDamage[slot] = 0;
        if (set != null) {
            Set<IRefinement> refinements = set.getRefinements();
            for (IRefinement refinement : refinements) {
                Attribute a;
                this.activeRefinements.add(refinement);
                if (this.player.isRemote() || (a = refinement.getAttribute()) == null) continue;
                AttributeInstance attributeInstance = this.player.getRepresentingPlayer().m_21051_(a);
                double value = refinement.getModifierValue();
                AttributeModifier t = attributeInstance.m_22111_(refinement.getUUID());
                if (t != null) {
                    attributeInstance.m_22130_(t);
                    value += t.m_22218_();
                }
                t = refinement.createAttributeModifier(refinement.getUUID(), value);
                this.refinementModifier.put(refinement, t);
                attributeInstance.m_22118_(t);
            }
        }
    }

    private void removeRefinementSet(int slot) {
        IRefinementSet set = this.appliedRefinementSets[slot];
        this.appliedRefinementSets[slot] = null;
        if (set != null) {
            Set<IRefinement> refinements = set.getRefinements();
            for (IRefinement refinement : refinements) {
                Attribute a;
                this.activeRefinements.remove(refinement);
                if (this.player.isRemote() || (a = refinement.getAttribute()) == null) continue;
                AttributeInstance attributeInstance = this.player.getRepresentingPlayer().m_21051_(a);
                AttributeModifier modifier = this.refinementModifier.get(refinement);
                double value = modifier.m_22218_() - refinement.getModifierValue();
                this.refinementModifier.remove(refinement);
                attributeInstance.m_22130_(modifier);
                if (value == 0.0) continue;
                modifier = refinement.createAttributeModifier(modifier.m_22209_(), value);
                attributeInstance.m_22118_(modifier);
                this.refinementModifier.put(refinement, modifier);
                this.activeRefinements.add(refinement);
            }
        }
    }
}

