/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.refinements;

import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Refinement
extends ForgeRegistryEntry<IRefinement>
implements IRefinement {
    private final Attribute attribute;
    private final BiFunction<UUID, Double, AttributeModifier> modifier;
    private final UUID uuid;
    private final double baseValue;
    private boolean detrimental = false;
    private MutableComponent description;

    public Refinement(Attribute attribute, UUID uuid, double baseValue, BiFunction<UUID, Double, AttributeModifier> modifier) {
        this.attribute = attribute;
        this.modifier = modifier;
        this.uuid = uuid;
        this.baseValue = baseValue;
    }

    public Refinement() {
        this.attribute = null;
        this.modifier = null;
        this.baseValue = 0.0;
        this.uuid = null;
    }

    @Override
    public AttributeModifier createAttributeModifier(UUID uuid, double value) {
        return this.modifier == null ? null : this.modifier.apply(uuid, value);
    }

    @Override
    @Nullable
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    @Nonnull
    public Component getDescription() {
        if (this.description == null) {
            this.description = new TranslatableComponent("refinement." + this.getRegistryName().m_135827_() + "." + this.getRegistryName().m_135815_() + ".desc");
            if (this.detrimental) {
                this.description.m_130940_(ChatFormatting.RED);
            }
        }
        return this.description;
    }

    @Override
    public double getModifierValue() {
        return this.baseValue;
    }

    @Override
    @Nullable
    public UUID getUUID() {
        return this.uuid;
    }

    public Refinement setDetrimental() {
        this.detrimental = true;
        return this;
    }
}

