/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.hunter;

import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.items.ObsidianArmorItem;
import de.teamlapen.vampirism.player.FactionBasePlayer;
import de.teamlapen.vampirism.player.IVampirismPlayer;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import de.teamlapen.vampirism.player.hunter.HunterPlayerSpecialAttribute;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HunterPlayer
extends FactionBasePlayer<IHunterPlayer>
implements IHunterPlayer {
    private static final Logger LOGGER = LogManager.getLogger(HunterPlayer.class);
    public static final Capability<IHunterPlayer> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IHunterPlayer>(){});
    private final ActionHandler<IHunterPlayer> actionHandler = new ActionHandler<HunterPlayer>(this);
    private final SkillHandler<IHunterPlayer> skillHandler = new SkillHandler<IHunterPlayer>(this, VReference.HUNTER_FACTION);

    @Deprecated
    public static HunterPlayer get(@Nonnull Player player) {
        return (HunterPlayer)player.getCapability(CAP, null).orElseThrow(() -> new IllegalStateException("Cannot get HunterPlayer from player " + player));
    }

    public static LazyOptional<HunterPlayer> getOpt(@Nonnull Player player) {
        LazyOptional opt = player.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Hunter player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static ICapabilityProvider createNewCapability(final Player player) {
        return new ICapabilitySerializable<CompoundTag>(){
            final HunterPlayer inst;
            final LazyOptional<IHunterPlayer> opt;
            {
                this.inst = new HunterPlayer(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.inst.loadData(nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveData(tag);
                return tag;
            }
        };
    }

    public HunterPlayer(Player player) {
        super(player);
    }

    @Override
    public void breakDisguise() {
        if (this.actionHandler.isActionActive(HunterActions.disguise_hunter)) {
            this.actionHandler.toggleAction(HunterActions.disguise_hunter);
        }
    }

    @Override
    public boolean canLeaveFaction() {
        return true;
    }

    @Override
    public IActionHandler<IHunterPlayer> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.HUNTER_PLAYER_KEY;
    }

    @Override
    public IFaction<?> getDisguisedAs() {
        return this.player.m_21023_(ModEffects.disguise_as_vampire) ? VReference.VAMPIRE_FACTION : this.getFaction();
    }

    @Override
    public int getLevel() {
        return ((IVampirismPlayer)this.player).getVampAtts().hunterLevel;
    }

    @Override
    public int getMaxLevel() {
        return 14;
    }

    @Override
    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    @Override
    @Nonnull
    public ISkillHandler<IHunterPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    @Nonnull
    public HunterPlayerSpecialAttribute getSpecialAttributes() {
        return ((IVampirismPlayer)this.player).getVampAtts().getHuntSpecial();
    }

    @Override
    public int getTheEntityID() {
        return this.player.m_142049_();
    }

    @Override
    public boolean isDisguised() {
        return this.player.m_21023_(ModEffects.disguise_as_vampire);
    }

    @Override
    public void loadData(CompoundTag compound) {
        super.loadData(compound);
        this.actionHandler.loadFromNbt(compound);
        this.skillHandler.loadFromNbt(compound);
    }

    @Override
    public void onChangedDimension(ResourceKey<Level> from, ResourceKey<Level> to) {
    }

    @Override
    public void onDeath(DamageSource src) {
        super.onDeath(src);
        this.actionHandler.deactivateAllActions();
        if (src.m_7639_() instanceof ServerPlayer && Helper.isVampire((Player)src.m_7639_()) && this.getRepresentingPlayer().m_21124_(ModEffects.freeze) != null) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayer)src.m_7639_(), VampireActionTrigger.Action.KILL_FROZEN_HUNTER);
        }
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        if (DamageSource.f_19307_.equals(src) || DamageSource.f_19305_.equals(src)) {
            return ObsidianArmorItem.isFullyEquipped(this.player);
        }
        return false;
    }

    @Override
    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    @Override
    public void onLevelChanged(int level, int oldLevel) {
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.HUNTER_LEVEL_CRITERIA, level);
            LevelAttributeModifier.applyModifier(this.player, Attributes.f_22281_, "Hunter", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.hpStrengthMaxMod.get(), (Double)VampirismConfig.BALANCE.hpStrengthType.get(), AttributeModifier.Operation.MULTIPLY_BASE, false);
            if (level > 0) {
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill();
                }
            } else {
                this.skillHandler.disableAllSkills();
                this.actionHandler.resetTimers();
                this.skillHandler.resetRefinements();
            }
        } else if (level == 0) {
            this.actionHandler.resetTimers();
            this.skillHandler.resetRefinements();
        }
    }

    @Override
    public void onPlayerLoggedIn() {
    }

    @Override
    public void onPlayerLoggedOut() {
    }

    @Override
    public void onUpdate() {
        this.player.m_20193_().m_46473_().m_6180_("vampirism_hunterPlayer");
        super.onUpdate();
        int level = this.getLevel();
        if (level > 0) {
            if (!this.isRemote()) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundTag syncPacket = new CompoundTag();
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
            } else {
                this.actionHandler.updateActions();
                VampirismMod.proxy.handleSleepClient(this.player);
            }
        }
        this.getSpecialAttributes().fullHunterCoat = level > 0 ? HunterCoatItem.isFullyEquipped(this.player) : null;
        this.player.m_20193_().m_46473_().m_7238_();
    }

    @Override
    public void onUpdatePlayer(TickEvent.Phase phase) {
    }

    @Override
    public void saveData(CompoundTag compound) {
        super.saveData(compound);
        this.actionHandler.saveToNbt(compound);
        this.skillHandler.saveToNbt(compound);
    }

    @Override
    protected FactionBasePlayer<IHunterPlayer> copyFromPlayer(Player old) {
        HunterPlayer oldHunter = HunterPlayer.get(old);
        CompoundTag nbt = new CompoundTag();
        oldHunter.saveData(nbt);
        this.loadData(nbt);
        return oldHunter;
    }

    @Override
    protected void loadUpdate(CompoundTag nbt) {
        super.loadUpdate(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
    }

    @Override
    protected void writeFullUpdate(CompoundTag nbt) {
        super.writeFullUpdate(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
    }
}

