/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player;

import com.google.common.collect.Maps;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskManager;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.inventory.container.TaskBoardContainer;
import de.teamlapen.vampirism.inventory.container.TaskContainer;
import de.teamlapen.vampirism.network.TaskPacket;
import de.teamlapen.vampirism.network.TaskStatusPacket;
import de.teamlapen.vampirism.player.tasks.TaskInstance;
import de.teamlapen.vampirism.player.tasks.req.ItemRequirement;
import de.teamlapen.vampirism.player.tasks.reward.ItemRewardInstance;
import de.teamlapen.vampirism.player.tasks.reward.LordLevelReward;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class TaskManager
implements ITaskManager {
    private static final UUID UNIQUE_TASKS = UUID.fromString("e2c6068a-8f0e-4d5b-822a-38ad6ecf98c9");
    private static final Map<ResourceLocation, Pair<Function<CompoundTag, ITaskRewardInstance>, Function<FriendlyByteBuf, ITaskRewardInstance>>> TASK_REWARD_SUPPLIER = new HashMap<ResourceLocation, Pair<Function<CompoundTag, ITaskRewardInstance>, Function<FriendlyByteBuf, ITaskRewardInstance>>>(){
        {
            this.put(LordLevelReward.ID, Pair.of(LordLevelReward::readNbt, LordLevelReward::decode));
            this.put(ItemRewardInstance.ID, Pair.of(ItemRewardInstance::readNbt, ItemRewardInstance::decode));
        }
    };
    @Nonnull
    private final IPlayableFaction<?> faction;
    @Nonnull
    private final ServerPlayer player;
    @Nonnull
    private final IFactionPlayer<?> factionPlayer;
    @Nonnull
    private final Set<Task> completedTasks = new HashSet<Task>();
    @Nonnull
    private final Map<UUID, TaskWrapper> taskWrapperMap = new HashMap<UUID, TaskWrapper>();

    public static void registerTaskReward(ResourceLocation id, Pair<Function<CompoundTag, ITaskRewardInstance>, Function<FriendlyByteBuf, ITaskRewardInstance>> functions) {
        if (TASK_REWARD_SUPPLIER.containsKey(id)) {
            throw new IllegalStateException("This id is already registered: " + id);
        }
        TASK_REWARD_SUPPLIER.put(id, functions);
    }

    public static ITaskRewardInstance createReward(ResourceLocation id, CompoundTag nbt) {
        return (ITaskRewardInstance)((Function)TASK_REWARD_SUPPLIER.get(id).getKey()).apply(nbt);
    }

    public static ITaskRewardInstance createReward(ResourceLocation id, FriendlyByteBuf buffer) {
        return (ITaskRewardInstance)((Function)TASK_REWARD_SUPPLIER.get(id).getValue()).apply(buffer);
    }

    public TaskManager(@Nonnull ServerPlayer player, @Nonnull IFactionPlayer<?> factionPlayer, @Nonnull IPlayableFaction<?> faction) {
        this.faction = faction;
        this.player = player;
        this.factionPlayer = factionPlayer;
    }

    @Override
    public void abortTask(UUID taskBoardId, @Nonnull UUID taskInstance, boolean remove) {
        this.taskWrapperMap.get(taskBoardId).removeTask(taskInstance, remove);
    }

    @Override
    public void acceptTask(UUID taskBoardId, @Nonnull UUID taskInstance) {
        ITaskInstance ins = this.taskWrapperMap.get(taskBoardId).acceptTask(taskInstance, this.player.f_19853_.m_46467_() + (long)this.getTaskTimeConfig() * 1200L);
        this.updateStats(ins);
    }

    public void applyRewards(@Nonnull ITaskInstance taskInstance) {
        taskInstance.getReward().applyReward(this.factionPlayer);
    }

    public boolean canCompleteTask(@Nonnull ITaskInstance taskInstance) {
        if (!this.isTaskUnlocked(taskInstance.getTask())) {
            return false;
        }
        if (!this.isTimeEnough(taskInstance, this.player.f_19853_.m_46467_())) {
            return false;
        }
        for (TaskRequirement.Requirement<?> requirement : taskInstance.getTask().getRequirement().getAll()) {
            if (this.checkStat(taskInstance, requirement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void completeTask(UUID taskBoardId, @Nonnull UUID taskInstance) {
        TaskWrapper wrapper = this.taskWrapperMap.get(taskBoardId);
        ITaskInstance ins = wrapper.getTaskInstance(taskInstance);
        if (!this.canCompleteTask(ins)) {
            return;
        }
        this.completedTasks.add(ins.getTask());
        wrapper.removeTask(ins, true);
        if (!ins.isUnique()) {
            ++wrapper.lessTasks;
        }
        this.removeRequirements(ins);
        this.applyRewards(ins);
    }

    @Nonnull
    public Map<UUID, Map<ResourceLocation, Integer>> getCompletedRequirements(@Nonnull Collection<ITaskInstance> taskInstances) {
        HashMap completedRequirements = Maps.newHashMap();
        taskInstances.forEach(task -> {
            Map<ResourceLocation, Integer> completed = this.getCompletedRequirements((ITaskInstance)task);
            if (!completed.isEmpty()) {
                completedRequirements.put(task.getId(), completed);
            }
        });
        return completedRequirements;
    }

    public int getTaskTimeConfig() {
        if (ServerLifecycleHooks.getCurrentServer().m_6982_()) {
            return (Integer)VampirismConfig.BALANCE.taskDurationDedicatedServer.get();
        }
        return (Integer)VampirismConfig.BALANCE.taskDurationSinglePlayer.get();
    }

    @Override
    public boolean hasAvailableTasks(UUID taskBoardId) {
        return !this.getTasks(taskBoardId).isEmpty() || !this.getUniqueTasks().isEmpty();
    }

    public boolean isTaskUnlocked(@Nonnull Task task) {
        if (!this.matchesFaction(task)) {
            return false;
        }
        for (TaskUnlocker taskUnlocker : task.getUnlocker()) {
            if (taskUnlocker.isUnlocked(this.factionPlayer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void openTaskMasterScreen(UUID taskBoardId) {
        if (this.player.f_36096_ instanceof TaskBoardContainer) {
            TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(taskBoardId, TaskWrapper::new);
            HashSet<ITaskInstance> selectedTasks = new HashSet<ITaskInstance>(this.getTasks(taskBoardId));
            selectedTasks.addAll(this.getUniqueTasks());
            VampirismMod.dispatcher.sendTo(new TaskStatusPacket(selectedTasks, this.getCompletableTasks(selectedTasks), this.getCompletedRequirements(selectedTasks), this.player.f_36096_.f_38840_, taskBoardId), this.player);
            wrapper.lastSeenPos = this.player.m_142538_();
        }
    }

    @Override
    public void openVampirismMenu() {
        if (this.player.f_36096_ instanceof TaskContainer) {
            VampirismMod.dispatcher.sendTo(new TaskPacket(this.player.f_36096_.f_38840_, this.taskWrapperMap, this.taskWrapperMap.entrySet().stream().map(entry -> Pair.of((Object)((UUID)entry.getKey()), this.getCompletableTasks(((TaskWrapper)entry.getValue()).getAcceptedTasks()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)), this.taskWrapperMap.values().stream().map(wrapper -> Pair.of((Object)wrapper.id, this.getCompletedRequirements(wrapper.tasks.values()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue))), this.player);
        }
    }

    public void readNBT(@Nonnull CompoundTag compoundNBT) {
        if (compoundNBT.m_128441_("taskWrapper")) {
            ListTag infos = compoundNBT.m_128437_("taskWrapper", 10);
            for (int i = 0; i < infos.size(); ++i) {
                CompoundTag nbt = infos.m_128728_(i);
                TaskWrapper wrapper = TaskWrapper.readNBT(nbt);
                this.taskWrapperMap.put(wrapper.id, wrapper);
            }
        }
        if (compoundNBT.m_128441_("completedTasks")) {
            compoundNBT.m_128469_("completedTasks").m_128431_().forEach(taskId -> {
                Task task = (Task)ModRegistries.TASKS.getValue(new ResourceLocation(taskId));
                if (task != null) {
                    this.completedTasks.add(task);
                }
            });
        }
    }

    public void removeRequirements(@Nonnull ITaskInstance taskInstance) {
        taskInstance.getTask().getRequirement().removeRequirement(this.factionPlayer);
    }

    @Override
    public void reset() {
        this.completedTasks.clear();
        this.taskWrapperMap.values().forEach(wrapper -> {
            wrapper.lessTasks = 0;
            wrapper.tasks.clear();
        });
    }

    @Override
    public void resetTaskLists() {
        this.taskWrapperMap.values().forEach(TaskWrapper::reset);
        this.updateTaskLists();
    }

    @Override
    public void resetUniqueTask(Task task) {
        if (!task.isUnique()) {
            return;
        }
        this.completedTasks.remove((Object)task);
        TaskWrapper wrapper = this.taskWrapperMap.get(UNIQUE_TASKS);
        if (wrapper != null) {
            wrapper.tasks.values().removeIf(ins -> ins.getTask() == task);
        }
    }

    public void tick() {
        if (this.player.m_20193_().m_46467_() % 24000L == 0L) {
            this.updateTaskLists();
        }
    }

    @Override
    public void updateTaskLists() {
        for (TaskWrapper value : this.taskWrapperMap.values()) {
            if (value.id == UNIQUE_TASKS) continue;
            if (value.getAcceptedTasks().isEmpty()) {
                value.tasks.clear();
                continue;
            }
            value.tasks.values().removeIf(task -> !value.getAcceptedTasks().contains(task));
        }
    }

    @Override
    public boolean wasTaskCompleted(@Nonnull Task task) {
        return this.completedTasks.contains((Object)task);
    }

    public void writeNBT(@Nonnull CompoundTag compoundNBT) {
        if (!this.completedTasks.isEmpty()) {
            CompoundTag tasksNBT = new CompoundTag();
            this.completedTasks.forEach(task -> tasksNBT.m_128379_(Objects.requireNonNull(task.getRegistryName()).toString(), true));
            compoundNBT.m_128365_("completedTasks", (Tag)tasksNBT);
        }
        if (!this.taskWrapperMap.isEmpty()) {
            ListTag infos = new ListTag();
            this.taskWrapperMap.forEach((a, b) -> infos.add((Object)b.writeNBT(new CompoundTag())));
            compoundNBT.m_128365_("taskWrapper", (Tag)infos);
        }
    }

    private boolean checkStat(@Nonnull ITaskInstance taskInstance, @Nonnull TaskRequirement.Requirement<?> requirement) {
        return this.getStat(taskInstance, requirement) >= requirement.getAmount(this.factionPlayer);
    }

    private Set<UUID> getCompletableTasks(@Nonnull Set<ITaskInstance> taskInstances) {
        return taskInstances.stream().filter(this::canCompleteTask).map(ITaskInstance::getId).collect(Collectors.toSet());
    }

    private Map<ResourceLocation, Integer> getCompletedRequirements(@Nonnull ITaskInstance taskInstance) {
        HashMap<ResourceLocation, Integer> completed = new HashMap<ResourceLocation, Integer>();
        for (TaskRequirement.Requirement<?> requirement : taskInstance.getTask().getRequirement().getAll()) {
            completed.put(requirement.getId(), this.getStat(taskInstance, requirement));
        }
        return completed;
    }

    private int getStat(@Nonnull ITaskInstance taskInstance, @Nonnull TaskRequirement.Requirement<?> requirement) {
        Map<ResourceLocation, Integer> stats = taskInstance.getStats();
        if (!taskInstance.isAccepted()) {
            return 0;
        }
        int neededStat = 0;
        int actualStat = 0;
        switch (requirement.getType()) {
            case STATS: {
                actualStat = this.player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)((ResourceLocation)requirement.getStat(this.factionPlayer))));
                neededStat = stats.get(requirement.getId()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ENTITY: {
                actualStat = this.player.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)requirement.getStat(this.factionPlayer))));
                neededStat = stats.get(requirement.getId()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ENTITY_TAG: {
                for (Holder type : Registry.f_122826_.m_206058_((TagKey)requirement.getStat(this.factionPlayer))) {
                    actualStat += this.player.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)type.m_203334_())));
                }
                neededStat = stats.get(requirement.getId()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ITEMS: {
                ItemStack stack = ((ItemRequirement)requirement).getItemStack();
                neededStat = stack.m_41613_();
                actualStat = TaskManager.countItem(this.player.m_150109_(), stack);
                break;
            }
            case BOOLEAN: {
                if (!((Boolean)requirement.getStat(this.factionPlayer)).booleanValue()) {
                    return 0;
                }
                return 1;
            }
        }
        return Math.min(requirement.getAmount(this.factionPlayer) - (neededStat - actualStat), requirement.getAmount(this.factionPlayer));
    }

    private Collection<ITaskInstance> getTasks(UUID taskBoardId) {
        TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(taskBoardId, TaskWrapper::new);
        if (!wrapper.tasks.isEmpty()) {
            this.removeLockedTasks(wrapper.getTaskInstances());
        }
        int n = wrapper.taskAmount = wrapper.taskAmount < 0 ? this.player.m_21187_().nextInt((Integer)VampirismConfig.BALANCE.taskMasterMaxTaskAmount.get()) + 1 - wrapper.lessTasks : wrapper.taskAmount;
        if (wrapper.tasks.size() < wrapper.taskAmount) {
            ArrayList tasks = new ArrayList(ModRegistries.TASKS.getValues());
            Collections.shuffle(tasks);
            wrapper.tasks.putAll(tasks.stream().filter(this::matchesFaction).filter(task -> !task.isUnique()).filter(this::isTaskUnlocked).limit(wrapper.taskAmount - wrapper.tasks.size()).map(task -> new TaskInstance((Task)((Object)task), taskBoardId, this.factionPlayer, (long)this.getTaskTimeConfig() * 1200L)).collect(Collectors.toMap(TaskInstance::getId, t -> t)));
        }
        this.updateStats(wrapper.getTaskInstances());
        return wrapper.getTaskInstances();
    }

    private Collection<ITaskInstance> getUniqueTasks() {
        TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(UNIQUE_TASKS, TaskWrapper::new);
        Map<UUID, ITaskInstance> uniqueTasks = wrapper.tasks;
        if (!uniqueTasks.isEmpty()) {
            this.removeLockedTasks(uniqueTasks.values());
        }
        Collection tasks = uniqueTasks.values().stream().map(ITaskInstance::getTask).collect(Collectors.toSet());
        uniqueTasks.putAll(ModRegistries.TASKS.getValues().stream().filter(this::matchesFaction).filter(Task::isUnique).filter(task -> !tasks.contains(task)).filter(task -> !this.completedTasks.contains(task)).filter(this::isTaskUnlocked).map(task -> new TaskInstance((Task)((Object)task), UNIQUE_TASKS, this.factionPlayer, 0L)).collect(Collectors.toMap(TaskInstance::getId, a -> a)));
        wrapper.tasks.putAll(uniqueTasks);
        this.updateStats(uniqueTasks.values());
        return uniqueTasks.values();
    }

    private boolean isTimeEnough(ITaskInstance taskInstance, long gameTime) {
        if (!taskInstance.isUnique()) {
            return taskInstance.getTaskTimeStamp() >= gameTime;
        }
        return true;
    }

    private boolean matchesFaction(@Nonnull Task task) {
        return task.getFaction() == this.faction || task.getFaction() == null;
    }

    private void removeLockedTasks(@Nonnull Collection<ITaskInstance> taskInstances) {
        taskInstances.removeIf(task -> {
            if (!this.isTaskUnlocked(task.getTask())) {
                task.aboardTask();
                return true;
            }
            return false;
        });
    }

    private static int countItem(Inventory inventory, ItemStack stack) {
        int i = 0;
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack itemstack = inventory.m_8020_(j);
            if (!ItemStack.m_41746_((ItemStack)itemstack, (ItemStack)stack) || !TaskManager.checkPotionEqual(itemstack, stack)) continue;
            i += itemstack.m_41613_();
        }
        return i;
    }

    public static boolean checkPotionEqual(ItemStack stack1, ItemStack stack2) {
        return PotionUtils.m_43579_((ItemStack)stack1) == PotionUtils.m_43579_((ItemStack)stack2);
    }

    private void updateStats(@Nonnull Collection<ITaskInstance> taskInstances) {
        taskInstances.forEach(this::updateStats);
    }

    private void updateStats(@Nonnull ITaskInstance taskInstance) {
        if (!taskInstance.isAccepted()) {
            return;
        }
        if (!taskInstance.getTask().getRequirement().isHasStatBasedReq()) {
            return;
        }
        Map<ResourceLocation, Integer> reqStats = taskInstance.getStats();
        for (TaskRequirement.Requirement<?> requirement : taskInstance.getTask().getRequirement().getAll()) {
            switch (requirement.getType()) {
                case STATS: {
                    reqStats.putIfAbsent(requirement.getId(), this.player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)((ResourceLocation)requirement.getStat(this.factionPlayer)))));
                    break;
                }
                case ENTITY: {
                    reqStats.putIfAbsent(requirement.getId(), this.player.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)requirement.getStat(this.factionPlayer)))));
                    break;
                }
                case ENTITY_TAG: {
                    int amount = 0;
                    for (Holder type : Registry.f_122826_.m_206058_((TagKey)requirement.getStat(this.factionPlayer))) {
                        amount += this.player.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)type.m_203334_())));
                    }
                    reqStats.putIfAbsent(requirement.getId(), amount);
                    break;
                }
            }
        }
    }

    public static class TaskWrapper {
        private final UUID id;
        @Nonnull
        private final Map<UUID, ITaskInstance> tasks;
        private int lessTasks;
        private int taskAmount;
        @Nullable
        private BlockPos lastSeenPos;

        public static TaskWrapper readNBT(@Nonnull CompoundTag nbt) {
            UUID id = nbt.m_128342_("id");
            int lessTasks = nbt.m_128451_("lessTasks");
            int taskAmount = nbt.m_128451_("taskAmount");
            HashMap<UUID, ITaskInstance> tasks = new HashMap<UUID, ITaskInstance>();
            BlockPos taskBoardInfo = null;
            if (nbt.m_128441_("pos")) {
                ListTag pos = nbt.m_128437_("pos", 6);
                taskBoardInfo = new BlockPos(pos.m_128772_(0), pos.m_128772_(1), pos.m_128772_(2));
            }
            int taskSize = nbt.m_128451_("tasksSize");
            ListTag tasksNBT = nbt.m_128437_("tasks", 10);
            for (int i = 0; i < taskSize; ++i) {
                TaskInstance ins = TaskInstance.readNBT(tasksNBT.m_128728_(i));
                if (ins == null) continue;
                tasks.put(ins.getId(), ins);
            }
            return new TaskWrapper(id, lessTasks, taskAmount, tasks, taskBoardInfo);
        }

        public static TaskWrapper decode(FriendlyByteBuf buffer) {
            UUID id = buffer.m_130259_();
            int lessTasks = buffer.m_130242_();
            int taskAmount = buffer.m_130242_();
            BlockPos pos = null;
            if (buffer.readBoolean()) {
                pos = buffer.m_130135_();
            }
            int tasksSize = buffer.m_130242_();
            HashMap<UUID, ITaskInstance> tasks = new HashMap<UUID, ITaskInstance>();
            for (int i = 0; i < tasksSize; ++i) {
                TaskInstance ins = TaskInstance.decode(buffer);
                tasks.put(ins.getId(), ins);
            }
            return new TaskWrapper(id, lessTasks, taskAmount, tasks, pos);
        }

        public TaskWrapper(UUID id) {
            this.id = id;
            this.lessTasks = 0;
            this.taskAmount = -1;
            this.tasks = new HashMap<UUID, ITaskInstance>();
            this.lastSeenPos = null;
        }

        private TaskWrapper(UUID id, int lessTasks, int taskAmount, @Nonnull Map<UUID, ITaskInstance> tasks, @Nullable BlockPos lastSeenPos) {
            this.id = id;
            this.lessTasks = lessTasks;
            this.taskAmount = taskAmount;
            this.tasks = tasks;
            this.lastSeenPos = lastSeenPos;
        }

        public ITaskInstance acceptTask(UUID taskInstance, long timeStamp) {
            ITaskInstance ins = this.tasks.get(taskInstance);
            ins.startTask(timeStamp);
            return ins;
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.id);
            buffer.m_130130_(this.lessTasks);
            buffer.m_130130_(this.taskAmount);
            buffer.writeBoolean(this.lastSeenPos != null);
            if (this.lastSeenPos != null) {
                buffer.m_130064_(this.lastSeenPos);
            }
            buffer.m_130130_(this.tasks.size());
            this.tasks.values().forEach(taskInstance -> taskInstance.encode(buffer));
        }

        @Nonnull
        public Set<ITaskInstance> getAcceptedTasks() {
            return this.tasks.values().stream().filter(ITaskInstance::isAccepted).collect(Collectors.toSet());
        }

        public UUID getId() {
            return this.id;
        }

        @Nonnull
        public Optional<BlockPos> getLastSeenPos() {
            return Optional.ofNullable(this.lastSeenPos);
        }

        public ITaskInstance getTaskInstance(UUID taskInstance) {
            return this.tasks.get(taskInstance);
        }

        @Nonnull
        public Collection<ITaskInstance> getTaskInstances() {
            return this.tasks.values();
        }

        public void removeTask(ITaskInstance taskInstance, boolean delete) {
            if (delete) {
                this.tasks.remove(taskInstance.getId());
            }
            taskInstance.aboardTask();
        }

        public void removeTask(UUID taskInstance, boolean delete) {
            this.removeTask(this.tasks.get(taskInstance), delete);
        }

        public CompoundTag writeNBT(@Nonnull CompoundTag nbt) {
            nbt.m_128362_("id", this.id);
            nbt.m_128405_("lessTasks", this.lessTasks);
            nbt.m_128405_("taskAmount", this.taskAmount);
            ListTag tasks = new ListTag();
            this.tasks.forEach((id, task) -> tasks.add((Object)task.writeNBT(new CompoundTag())));
            nbt.m_128365_("tasks", (Tag)tasks);
            nbt.m_128405_("tasksSize", this.tasks.size());
            BlockPos pos = this.lastSeenPos;
            if (pos != null) {
                nbt.m_128365_("pos", (Tag)Helper.newDoubleNBTList(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
            }
            return nbt;
        }

        private void reset() {
            this.tasks.clear();
            this.lessTasks = 0;
            this.taskAmount = -1;
        }
    }
}

