/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player;

import de.teamlapen.vampirism.core.ModAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LevelAttributeModifier {
    private static final Logger LOGGER = LogManager.getLogger(LevelAttributeModifier.class);
    private static final Map<Attribute, UUID> modifiers = new HashMap<Attribute, UUID>();

    public static void registerModdedAttributeModifier(Attribute attribute, UUID uuid) {
        modifiers.put(attribute, uuid);
    }

    public static void applyModifier(Player player, Attribute attribute, String name, int level, int lcap, double max, double type, AttributeModifier.Operation operation, boolean evenIntOnly) {
        UUID mod = modifiers.get(attribute);
        if (mod == null) {
            LOGGER.warn("Cannot modify {}, no modifier is registered", (Object)attribute);
            return;
        }
        double m = LevelAttributeModifier.calculateModifierValue(level, lcap, max, type);
        AttributeInstance instance = player.m_21051_(attribute);
        LevelAttributeModifier.rmMod(instance, mod);
        if (evenIntOnly) {
            m = Math.round(m / 2.0) * 2L;
        }
        instance.m_22125_(new AttributeModifier(mod, attribute.m_22087_() + " " + name + " Boost", m, operation));
    }

    public static double calculateModifierValue(int level, int lcap, double maxMod, double type) {
        return Math.pow(Math.min(level, lcap), type) / Math.pow(lcap, type) * maxMod;
    }

    private static void rmMod(AttributeInstance att, UUID uuid) {
        AttributeModifier m = att.m_22111_(uuid);
        if (m != null) {
            att.m_22130_(m);
        }
    }

    public static UUID getUUID(Attribute attribute) {
        return modifiers.get(attribute);
    }

    static {
        modifiers.put(Attributes.f_22281_, UUID.fromString("7600D8C4-3517-40BE-8CB1-359D46705A0F"));
        modifiers.put(Attributes.f_22279_, UUID.fromString("0FCBF922-DBEC-492A-82F5-99F73AFF5065"));
        modifiers.put(Attributes.f_22276_, UUID.fromString("56C17EFE-E3EC-4E27-A12F-99D2FE927B70"));
        modifiers.put((Attribute)ModAttributes.blood_exhaustion, UUID.fromString("4504ccfa-dfdc-11e5-b86d-9a79f06e9478"));
        modifiers.put(Attributes.f_22283_, UUID.fromString("37a4f596-2ff8-45e5-b074-c91df218f26b"));
        modifiers.put(Attributes.f_22284_, UUID.fromString("84769cda-82dd-46f8-8069-15d659b29408"));
    }
}

