/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModParticles;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class GenericParticleData
implements ParticleOptions {
    public static final Codec<GenericParticleData> CODEC = RecordCodecBuilder.create(p_239803_0_ -> p_239803_0_.group((App)Codec.STRING.fieldOf("t").forGetter(p_239807_0_ -> p_239807_0_.texture.toString()), (App)Codec.INT.fieldOf("a").forGetter(p_239806_0_ -> p_239806_0_.maxAge), (App)Codec.INT.fieldOf("c").forGetter(p_239805_0_ -> p_239805_0_.color), (App)Codec.FLOAT.fieldOf("s").forGetter(p_239804_0_ -> Float.valueOf(p_239804_0_.speed))).apply((Applicative)p_239803_0_, (t, a, c, s) -> new GenericParticleData(ModParticles.generic, new ResourceLocation(t), (int)a, (int)c, s.floatValue())));
    public static final ParticleOptions.Deserializer<GenericParticleData> DESERIALIZER = new ParticleOptions.Deserializer<GenericParticleData>(){

        @Nonnull
        public GenericParticleData fromCommand(@Nonnull ParticleType<GenericParticleData> particleTypeIn, @Nonnull StringReader reader) throws CommandSyntaxException {
            return new GenericParticleData(particleTypeIn, ResourceLocation.m_135818_((StringReader)reader), reader.readInt(), reader.readInt());
        }

        @Nonnull
        public GenericParticleData fromNetwork(@Nonnull ParticleType<GenericParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new GenericParticleData(particleTypeIn, buffer.m_130281_(), buffer.m_130242_(), buffer.m_130242_(), buffer.readFloat());
        }
    };
    private final ResourceLocation texture;
    private final int color;
    private final int maxAge;
    private final float speed;
    private final ParticleType<GenericParticleData> particleType;

    public GenericParticleData(ParticleType<GenericParticleData> particleType, ResourceLocation texture, int maxAge, int color) {
        this(particleType, texture, maxAge, color, 1.0f);
    }

    public GenericParticleData(ParticleType<GenericParticleData> particleType, ResourceLocation texture, int maxAge, int color, float speed) {
        this.particleType = particleType;
        this.texture = texture;
        this.maxAge = maxAge;
        this.color = color;
        this.speed = speed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColor() {
        return this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMaxAge() {
        return this.maxAge;
    }

    public void m_7711_(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130085_(this.texture);
        packetBuffer.m_130130_(this.maxAge);
        packetBuffer.m_130130_(this.color);
        packetBuffer.writeFloat(this.speed);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSpeed() {
        return this.speed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexturePos() {
        return this.texture;
    }

    @Nonnull
    public ParticleType<?> m_6012_() {
        return this.particleType;
    }

    @Nonnull
    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()) + " " + this.texture + " " + this.maxAge + " " + this.color;
    }
}

