/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.player.TaskManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public record TaskPacket(int containerId, Map<UUID, TaskManager.TaskWrapper> taskWrappers, Map<UUID, Set<UUID>> completableTasks, Map<UUID, Map<UUID, Map<ResourceLocation, Integer>>> completedRequirements) implements IMessage
{
    public static void encode(TaskPacket msg, FriendlyByteBuf buffer) {
        buffer.m_130130_(msg.containerId);
        buffer.m_130130_(msg.completableTasks.size());
        buffer.m_130130_(msg.completedRequirements.size());
        buffer.m_130130_(msg.taskWrappers.size());
        msg.completableTasks.forEach((uuid, tasks) -> {
            buffer.m_130077_(uuid);
            buffer.m_130130_(tasks.size());
            tasks.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130077_(arg_0));
        });
        msg.completedRequirements.forEach((uuid, taskMapMap) -> {
            buffer.m_130077_(uuid);
            buffer.m_130130_(taskMapMap.size());
            taskMapMap.forEach((task, data) -> {
                buffer.m_130077_(task);
                buffer.m_130130_(data.size());
                data.forEach((loc, val) -> {
                    buffer.m_130085_(loc);
                    buffer.m_130130_(val.intValue());
                });
            });
        });
        msg.taskWrappers.forEach((id, taskWrapper) -> taskWrapper.encode(buffer));
    }

    public static TaskPacket decode(FriendlyByteBuf buffer) {
        int containerId = buffer.m_130242_();
        int completableSize = buffer.m_130242_();
        int statSize = buffer.m_130242_();
        int taskWrapperSIze = buffer.m_130242_();
        HashMap<UUID, Set<UUID>> completableTasks = new HashMap<UUID, Set<UUID>>();
        for (int i = 0; i < completableSize; ++i) {
            UUID uuid = buffer.m_130259_();
            HashSet<UUID> task = new HashSet<UUID>();
            int taskSize = buffer.m_130242_();
            for (int i1 = 0; i1 < taskSize; ++i1) {
                task.add(buffer.m_130259_());
            }
            completableTasks.put(uuid, task);
        }
        HashMap<UUID, Map<UUID, Map<ResourceLocation, Integer>>> completedRequirements = new HashMap<UUID, Map<UUID, Map<ResourceLocation, Integer>>>();
        for (int i = 0; i < statSize; ++i) {
            UUID uuid = buffer.m_130259_();
            HashMap taskRequirements = new HashMap();
            int taskRequirementSize = buffer.m_130242_();
            for (int i1 = 0; i1 < taskRequirementSize; ++i1) {
                UUID task = buffer.m_130259_();
                int requirementSize = buffer.m_130242_();
                HashMap<ResourceLocation, Integer> requirements = new HashMap<ResourceLocation, Integer>();
                for (int i2 = 0; i2 < requirementSize; ++i2) {
                    requirements.put(buffer.m_130281_(), buffer.m_130242_());
                }
                taskRequirements.put(task, requirements);
            }
            completedRequirements.put(uuid, taskRequirements);
        }
        HashMap<UUID, TaskManager.TaskWrapper> taskWrapper = new HashMap<UUID, TaskManager.TaskWrapper>();
        for (int i = 0; i < taskWrapperSIze; ++i) {
            TaskManager.TaskWrapper wrapper = TaskManager.TaskWrapper.decode(buffer);
            taskWrapper.put(wrapper.getId(), wrapper);
        }
        return new TaskPacket(containerId, taskWrapper, completableTasks, completedRequirements);
    }

    public static void handle(TaskPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleTaskPacket(msg));
        ctx.setPacketHandled(true);
    }
}

