/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.world.MultiBossEvent;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.BossEvent;
import net.minecraftforge.network.NetworkEvent;

public class MultiBossEventPacket
implements IMessage {
    private final UUID uniqueId;
    private final OperationType operation;
    protected List<Color> colors;
    protected Map<Color, Float> entries;
    private Component name;
    private BossEvent.BossBarOverlay overlay;

    static void encode(MultiBossEventPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.uniqueId);
        buf.m_130068_((Enum)msg.operation);
        switch (msg.operation) {
            case ADD: {
                buf.m_130083_(msg.name);
                buf.m_130130_(msg.colors.size());
                msg.colors.forEach(color -> buf.m_130130_(color.getRGB()));
                buf.m_130068_((Enum)msg.overlay);
            }
            case UPDATE_PROGRESS: {
                buf.m_130130_(msg.entries.size());
                for (Map.Entry<Color, Float> value : msg.entries.entrySet()) {
                    buf.m_130130_(value.getKey().getRGB());
                    buf.writeFloat(value.getValue().floatValue());
                }
                break;
            }
            case UPDATE_NAME: {
                buf.m_130083_(msg.name);
                break;
            }
            case UPDATE_STYLE: {
                buf.m_130068_((Enum)msg.overlay);
            }
        }
    }

    static MultiBossEventPacket decode(FriendlyByteBuf buf) {
        UUID uuid = buf.m_130259_();
        OperationType operation = (OperationType)buf.m_130066_(OperationType.class);
        MultiBossEventPacket packet = new MultiBossEventPacket(operation, uuid);
        switch (operation) {
            case ADD: {
                packet.name = buf.m_130238_();
                int size = buf.m_130242_();
                LinkedList<Color> colors = new LinkedList<Color>();
                for (int i = 0; i < size; ++i) {
                    colors.add(new Color(buf.m_130242_(), true));
                }
                packet.colors = colors;
                packet.overlay = (BossEvent.BossBarOverlay)buf.m_130066_(BossEvent.BossBarOverlay.class);
            }
            case UPDATE_PROGRESS: {
                LinkedHashMap<Color, Float> entries = new LinkedHashMap<Color, Float>();
                int size2 = buf.m_130242_();
                for (int i = 0; i < size2; ++i) {
                    Color color = new Color(buf.m_130242_(), true);
                    float perc = buf.readFloat();
                    entries.put(color, Float.valueOf(perc));
                }
                packet.entries = entries;
                break;
            }
            case UPDATE_NAME: {
                packet.name = buf.m_130238_();
                break;
            }
            case UPDATE_STYLE: {
                packet.overlay = (BossEvent.BossBarOverlay)buf.m_130066_(BossEvent.BossBarOverlay.class);
            }
        }
        return packet;
    }

    public static void handle(MultiBossEventPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleUpdateMultiBossInfoPacket(msg));
        ctx.setPacketHandled(true);
    }

    public MultiBossEventPacket(OperationType operation, MultiBossEvent data) {
        this.uniqueId = data.getUniqueId();
        this.operation = operation;
        this.name = data.getName();
        this.colors = data.getColors();
        this.entries = data.getEntries();
        this.overlay = data.getOverlay();
    }

    private MultiBossEventPacket(OperationType operation, UUID uuid) {
        this.uniqueId = uuid;
        this.operation = operation;
        this.entries = new LinkedHashMap<Color, Float>();
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public Map<Color, Float> getEntries() {
        return this.entries;
    }

    public Component getName() {
        return this.name;
    }

    public OperationType getOperation() {
        return this.operation;
    }

    public BossEvent.BossBarOverlay getOverlay() {
        return this.overlay;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public static enum OperationType {
        ADD,
        REMOVE,
        UPDATE_PROGRESS,
        UPDATE_NAME,
        UPDATE_STYLE,
        UPDATE_PROPERTIES;

    }
}

