/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.inventory.container.HunterBasicContainer;
import de.teamlapen.vampirism.inventory.container.HunterTrainerContainer;
import de.teamlapen.vampirism.inventory.container.VampirismContainer;
import de.teamlapen.vampirism.items.OblivionItem;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import de.teamlapen.vampirism.network.RequestMinionSelectPacket;
import de.teamlapen.vampirism.network.SelectMinionTaskPacket;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InputEventPacket
implements IMessage {
    public static final String SUCKBLOOD = "sb";
    public static final String ENDSUCKBLOOD = "esb";
    public static final String TOGGLEACTION = "ta";
    public static final String UNLOCKSKILL = "us";
    public static final String RESETSKILL = "rs";
    public static final String TRAINERLEVELUP = "tl";
    public static final String REVERTBACK = "rb";
    public static final String VAMPIRE_VISION_TOGGLE = "vvt";
    public static final String BASICHUNTERLEVELUP = "bl";
    public static final String DRINK_BLOOD_BLOCK = "db";
    public static final String NAME_ITEM = "ni";
    public static final String SELECT_CALL_MINION = "sm";
    public static final String TOGGLE_LOCK_MINION_TASK = "lt";
    public static final String RESURRECT = "rst";
    public static final String DIE = "die";
    public static final String OPEN_VAMPIRISM_MENU = "ovm";
    public static final String DELETE_REFINEMENT = "dr";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SPLIT = "&";
    private String param;
    private String action;

    static void encode(InputEventPacket msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.action + SPLIT + msg.param);
    }

    static InputEventPacket decode(FriendlyByteBuf buf) {
        String[] s = buf.m_130136_(50).split(SPLIT);
        InputEventPacket msg = new InputEventPacket();
        msg.action = s[0];
        msg.param = s.length > 1 ? s[1] : "";
        return msg;
    }

    public static <T extends IFactionPlayer<T>> void handle(InputEventPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        Validate.notNull((Object)msg.action);
        ServerPlayer player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            Optional<IFactionPlayer> factionPlayerOpt = FactionPlayerHandler.getOpt((Player)player).map(FactionPlayerHandler::getCurrentFactionPlayer).orElse(Optional.empty());
            switch (msg.action) {
                case "sb": {
                    try {
                        int id = Integer.parseInt(msg.param);
                        if (id == 0) break;
                        VampirePlayer.getOpt((Player)player).ifPresent(vampire -> vampire.biteEntity(id));
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Receiving invalid param {} for {}", (Object)msg.param, (Object)msg.action);
                    }
                    break;
                }
                case "esb": {
                    VampirePlayer.getOpt((Player)player).ifPresent(vampire -> vampire.endFeeding(true));
                    break;
                }
                case "ta": {
                    ResourceLocation id = new ResourceLocation(msg.param);
                    factionPlayerOpt.ifPresent(factionPlayer -> {
                        IActionHandler actionHandler = factionPlayer.getActionHandler();
                        IAction action = (IAction)ModRegistries.ACTIONS.getValue(id);
                        if (action != null) {
                            IAction.PERM r = actionHandler.toggleAction(action);
                            switch (r) {
                                case NOT_UNLOCKED: {
                                    player.m_5661_((Component)new TranslatableComponent("text.vampirism.action.not_unlocked"), true);
                                    break;
                                }
                                case DISABLED: {
                                    player.m_5661_((Component)new TranslatableComponent("text.vampirism.action.deactivated_by_serveradmin"), false);
                                    break;
                                }
                                case COOLDOWN: {
                                    player.m_5661_((Component)new TranslatableComponent("text.vampirism.action.cooldown_not_over"), true);
                                    break;
                                }
                                case DISALLOWED: {
                                    player.m_5661_((Component)new TranslatableComponent("text.vampirism.action.disallowed"), true);
                                }
                            }
                        } else {
                            LOGGER.error("Failed to find action with id {}", (Object)id);
                        }
                    });
                    break;
                }
                case "db": {
                    String[] coords = msg.param.split(":");
                    if (coords.length == 3) {
                        BlockPos pos = new BlockPos(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
                        VampirePlayer.getOpt((Player)player).ifPresent(v -> v.biteBlock(pos));
                        break;
                    }
                    LOGGER.warn("Received invalid {} parameter", (Object)DRINK_BLOOD_BLOCK);
                    break;
                }
                case "us": {
                    factionPlayerOpt.ifPresent(factionPlayer -> {
                        ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(msg.param));
                        if (skill != null) {
                            ISkillHandler skillHandler = factionPlayer.getSkillHandler();
                            ISkillHandler.Result result = skillHandler.canSkillBeEnabled(skill);
                            if (result == ISkillHandler.Result.OK) {
                                skillHandler.enableSkill(skill);
                                if (factionPlayer instanceof ISyncable.ISyncableEntityCapabilityInst && skillHandler instanceof SkillHandler) {
                                    CompoundTag sync = new CompoundTag();
                                    ((SkillHandler)skillHandler).writeUpdateForClient(sync);
                                    HelperLib.sync((ISyncable.ISyncableEntityCapabilityInst)((Object)factionPlayer), sync, (Entity)factionPlayer.getRepresentingPlayer(), false);
                                }
                            } else {
                                LOGGER.warn("Skill {} cannot be activated for {} ({})", (Object)skill, (Object)player, (Object)result);
                            }
                        } else {
                            LOGGER.warn("Skill {} was not found so {} cannot activate it", (Object)msg.param, (Object)player);
                        }
                    });
                    break;
                }
                case "rs": {
                    InventoryHelper.removeItemFromInventory((Container)player.m_150109_(), new ItemStack((ItemLike)ModItems.oblivion_potion));
                    factionPlayerOpt.ifPresent(OblivionItem::applyEffect);
                    break;
                }
                case "tl": {
                    if (!(player.f_36096_ instanceof HunterTrainerContainer)) break;
                    ((HunterTrainerContainer)player.f_36096_).onLevelupClicked();
                    break;
                }
                case "rb": {
                    FactionPlayerHandler.getOpt((Player)player).ifPresent(handler -> {
                        handler.setFactionAndLevel(null, 0);
                        player.m_5661_((Component)new TranslatableComponent("command.vampirism.base.level.successful", new Object[]{player.m_7755_(), VReference.VAMPIRE_FACTION.getName(), 0}), true);
                        LOGGER.debug("Player {} left faction", (Object)player);
                        if (!ServerLifecycleHooks.getCurrentServer().m_7035_()) {
                            player.m_6469_(DamageSource.f_19319_, 1000.0f);
                        }
                    });
                    break;
                }
                case "vvt": {
                    VampirePlayer.getOpt((Player)player).ifPresent(VampirePlayer::switchVision);
                    break;
                }
                case "bl": {
                    if (!(player.f_36096_ instanceof HunterBasicContainer)) break;
                    ((HunterBasicContainer)player.f_36096_).onLevelUpClicked();
                    break;
                }
                case "ni": {
                    String name = msg.param;
                    if ("DO_NOT_NAME".equals(name)) {
                        ItemStack stack = player.m_21205_();
                        if (!(stack.m_41720_() instanceof VampirismVampireSword)) break;
                        ((VampirismVampireSword)stack.m_41720_()).doNotName(stack);
                        break;
                    }
                    if (StringUtils.isBlank((CharSequence)name)) break;
                    ItemStack stack = player.m_21205_();
                    stack.m_41714_((Component)new TextComponent(name).m_130940_(ChatFormatting.AQUA));
                    break;
                }
                case "sm": {
                    FactionPlayerHandler.getOpt((Player)ctx.getSender()).ifPresent(fp -> {
                        PlayerMinionController controller = MinionWorldData.getData(ctx.getSender().f_8924_).getOrCreateController((FactionPlayerHandler)fp);
                        Collection<Integer> ids = controller.getCallableMinions();
                        if (ids.size() > 0) {
                            ArrayList<Pair<Integer, Component>> minions = new ArrayList<Pair<Integer, Component>>(ids.size());
                            ids.forEach(id -> controller.contactMinionData((int)id, data -> data.getFormattedName().m_6881_()).ifPresent(n -> minions.add(Pair.of((Object)id, (Object)n))));
                            VampirismMod.dispatcher.sendTo(new RequestMinionSelectPacket(RequestMinionSelectPacket.Action.CALL, minions), ctx.getSender());
                        } else {
                            SelectMinionTaskPacket.printRecoveringMinions(ctx.getSender(), controller.getRecoveringMinionNames());
                        }
                    });
                    break;
                }
                case "lt": {
                    try {
                        int id = Integer.parseInt(msg.param);
                        FactionPlayerHandler.getOpt((Player)ctx.getSender()).ifPresent(fp -> {
                            PlayerMinionController controller = MinionWorldData.getData(ctx.getSender().f_8924_).getOrCreateController((FactionPlayerHandler)fp);
                            controller.contactMinionData(id, data -> data.setTaskLocked(!data.isTaskLocked()));
                            controller.contactMinion(id, MinionEntity::onTaskChanged);
                        });
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Receiving invalid param {} for {}", (Object)msg.param, (Object)msg.action);
                    }
                    break;
                }
                case "ovm": {
                    factionPlayerOpt.ifPresent(fPlayer -> {
                        if (player.m_6084_()) {
                            player.m_5893_(new MenuProvider(){

                                @Nonnull
                                public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
                                    return new VampirismContainer(i, playerInventory);
                                }

                                @Nonnull
                                public Component m_5446_() {
                                    return new TranslatableComponent("");
                                }
                            });
                            fPlayer.getTaskManager().openVampirismMenu();
                        }
                    });
                    break;
                }
                case "rst": {
                    VampirePlayer.getOpt((Player)player).ifPresent(VampirePlayer::tryResurrect);
                    break;
                }
                case "die": {
                    VampirePlayer.getOpt((Player)player).ifPresent(VampirePlayer::giveUpDBNO);
                    break;
                }
                case "dr": {
                    FactionPlayerHandler.getOpt((Player)player).ifPresent(fph -> fph.getCurrentFactionPlayer().ifPresent(fp -> fp.getSkillHandler().removeRefinementItem(IRefinementItem.AccessorySlotType.valueOf(msg.param))));
                }
            }
            ctx.setPacketHandled(true);
        });
    }

    public InputEventPacket(String action, String param) {
        this.action = action;
        this.param = param;
    }

    private InputEventPacket() {
    }
}

