/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.inventory.recipes.ShapedWeaponTableRecipe;
import de.teamlapen.vampirism.inventory.recipes.ShapelessWeaponTableRecipe;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class WeaponTableRecipeCategory
implements IRecipeCategory<IWeaponTableRecipe> {
    private static final ResourceLocation location = new ResourceLocation("vampirism", "textures/gui/weapon_table_clean.png");
    private static final ItemStack lavaStack = new ItemStack((ItemLike)Items.f_42448_);
    private final Component localizedName = new TranslatableComponent(ModBlocks.weapon_table.m_7705_());
    private final IDrawable background;
    private final IDrawable icon;

    WeaponTableRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(location, 32, 14, 134, 77).addPadding(0, 33, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.weapon_table));
    }

    public void draw(IWeaponTableRecipe recipe, @Nonnull PoseStack stack, double mouseX, double mouseY) {
        ISkill<IHunterPlayer>[] requiredSkills;
        int x = 2;
        int y = 80;
        Minecraft minecraft = Minecraft.m_91087_();
        if (recipe.getRequiredLavaUnits() > 0) {
            stack.m_85836_();
            RenderSystem.m_157183_();
            RenderSystem.m_157425_((Matrix4f)stack.m_85850_().m_85861_());
            minecraft.m_91291_().m_115123_(lavaStack, 83, 13);
            RenderSystem.m_157424_();
            stack.m_85849_();
        }
        if (recipe.getRequiredLevel() > 1) {
            TranslatableComponent level = new TranslatableComponent("gui.vampirism.hunter_weapon_table.level", new Object[]{recipe.getRequiredLevel()});
            minecraft.f_91062_.m_92889_(stack, (Component)level, (float)x, (float)y, Color.GRAY.getRGB());
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9 + 2;
        }
        if ((requiredSkills = recipe.getRequiredSkills()).length > 0) {
            TranslatableComponent skillText = new TranslatableComponent("gui.vampirism.hunter_weapon_table.skill", new Object[]{" "});
            for (ISkill<IHunterPlayer> skill : recipe.getRequiredSkills()) {
                skillText.m_7220_(skill.getName()).m_130946_(" ");
            }
            y += UtilLib.renderMultiLine(minecraft.f_91062_, stack, (Component)skillText, 132, x, y, Color.GRAY.getRGB());
        }
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public Class<? extends IWeaponTableRecipe> getRecipeClass() {
        return IWeaponTableRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return VampirismJEIPlugin.WEAPON_TABLE_RECIPE_ID;
    }

    public void setIngredients(IWeaponTableRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, @Nonnull IWeaponTableRecipe recipe, @Nonnull IIngredients ingredients) {
        int craftOutputSlot = 0;
        IGuiItemStackGroup guiItemStackGroup = iRecipeLayout.getItemStacks();
        guiItemStackGroup.init(craftOutputSlot, false, 111, 31);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                guiItemStackGroup.init(1 + x + y * 4, true, 1 + x * 19, 1 + y * 19);
            }
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (recipe instanceof ShapedWeaponTableRecipe) {
            ShapedWeaponTableRecipe wrapper = (ShapedWeaponTableRecipe)recipe;
            this.setInputs(guiItemStackGroup, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else if (recipe instanceof ShapelessWeaponTableRecipe) {
            this.setInputs(guiItemStackGroup, inputs);
            iRecipeLayout.setShapeless();
        }
        guiItemStackGroup.set(craftOutputSlot, (List)outputs.get(0));
    }

    private int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 4 ? i * 4 + 1 : (height == 3 ? i * 4 + 1 : (height == 2 ? i * 4 + 1 : 0));
        } else if (height == 1) {
            index = i + 4;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                index += 2;
                if (i > 3) {
                    index += 2;
                }
            }
        } else if (width == 3) {
            index = i;
            if (i > 2) {
                ++index;
                if (i > 5) {
                    ++index;
                    if (i > 8) {
                        ++index;
                    }
                }
            }
        } else {
            index = height == 2 ? i + 4 : i;
        }
        return index;
    }

    private void setInputs(IGuiItemStackGroup ingredientGroup, List<List<ItemStack>> inputs) {
        int width;
        int height;
        if (inputs.size() > 4) {
            height = 4;
            width = 4;
        } else if (inputs.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputs(ingredientGroup, inputs, width, height);
    }

    private void setInputs(IGuiItemStackGroup ingredientGroup, List<List<ItemStack>> inputs, int width, int height) {
        for (int i = 0; i < inputs.size(); ++i) {
            List<ItemStack> recipeItem = inputs.get(i);
            int index = this.getCraftingIndex(i, width, height);
            ingredientGroup.set(1 + index, recipeItem);
        }
    }
}

