/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;

public class PlayerReviveHelper {
    private static Method m_getDownedTime;
    private static boolean use_player_revive_time;

    public static int getPreviousDownTime(Player player) {
        if (use_player_revive_time && !player.m_183503_().m_5776_()) {
            if (!ModList.get().isLoaded("playerrevive")) {
                use_player_revive_time = false;
            } else {
                if (m_getDownedTime == null) {
                    try {
                        Class<?> clazz = Class.forName("team.creative.playerrevive.server.PlayerReviveServer");
                        m_getDownedTime = clazz.getMethod("downedTime", Player.class);
                    }
                    catch (ClassNotFoundException e) {
                        LogManager.getLogger().error("Failed to find PlayerReviveServer class for compatibility even though PlayerRevive is installed", (Throwable)e);
                        use_player_revive_time = false;
                    }
                    catch (NoSuchMethodException e) {
                        LogManager.getLogger().error("Failed to find downedTime method from PlayerReviveServer class for compatibility even though PlayerRevive is installed", (Throwable)e);
                        use_player_revive_time = false;
                    }
                }
                if (m_getDownedTime != null) {
                    try {
                        Object result = m_getDownedTime.invoke(null, player);
                        return (Integer)result;
                    }
                    catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        LogManager.getLogger().error("Failed to obtain downed time from PlayerRevive method for compatibility", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return 0;
    }

    static {
        use_player_revive_time = true;
    }
}

