/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class VampirismItemWeapon
extends SwordItem {
    protected final String regName;
    private final float attackDamage;
    private final float attackSpeed;
    private String translation_key;

    public VampirismItemWeapon(String regName, Tier material, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(material, attackDamageIn, attackSpeedIn, builder);
        this.attackDamage = attackDamageIn;
        this.attackSpeed = attackSpeedIn;
        this.regName = regName;
        this.setRegistryName("vampirism", regName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (flagIn.m_7050_()) {
            tooltip.add((Component)new TextComponent("ModDamage: " + this.getAttackDamage(stack)));
            tooltip.add((Component)new TextComponent("ModSpeed: " + this.getAttackSpeed(stack)));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.attackDamage;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    @Nonnull
    protected String m_41467_() {
        if (this.translation_key == null) {
            this.translation_key = Util.m_137492_((String)"item", (ResourceLocation)ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this));
        }
        return this.translation_key;
    }

    protected void setTranslation_key(String name) {
        this.translation_key = Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("vampirism", name));
    }
}

