/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public abstract class VampirismItemCrossbow
extends VampirismItem
implements IFactionLevelItem<IHunterPlayer>,
IVampirismCrossbow {
    private int enchantability = 0;

    protected static int isCrossbowFrugal(ItemStack crossbowStack) {
        return EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.crossbowfrugality, (ItemStack)crossbowStack);
    }

    public VampirismItemCrossbow(String regName, int maxDamage) {
        super(regName, new Item.Properties().m_41487_(1).m_41499_(maxDamage).m_41491_(VampirismMod.creativeTab));
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.addFactionLevelToolTip(stack, worldIn, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment == Enchantments.f_44952_;
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(Tags.Items.STRING) || super.m_6832_(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.enchantability;
    }

    @Override
    public int getMinLevel(@Nonnull ItemStack stack) {
        return 0;
    }

    @Override
    @Nullable
    public ISkill<IHunterPlayer> getRequiredSkill(@Nonnull ItemStack stack) {
        return null;
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@Nonnull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    public void setEnchantability(Tiers material) {
        this.enchantability = material.m_6601_();
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        this.shoot(playerIn, 0.0f, 0.0f, worldIn, stack, handIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    protected ItemStack findAmmo(Player player, ItemStack bowStack) {
        if (this.isArrow(player.m_21120_(InteractionHand.OFF_HAND))) {
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (this.isArrow(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    protected float getArrowVelocity() {
        return 1.0f;
    }

    protected int getCooldown(Player player, ItemStack stack) {
        return 20;
    }

    protected boolean isArrow(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof IVampirismCrossbowArrow;
    }

    protected boolean isCritical(Random random) {
        return false;
    }

    protected boolean isCrossbowInfinite(ItemStack stack, Player player) {
        int enchant = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack);
        return enchant > 0 || player.m_7500_();
    }

    protected boolean isIgnoreHurtTime(ItemStack crossbow) {
        return false;
    }

    protected boolean shoot(Player player, float heightOffset, float centerOffset, Level world, ItemStack stack, InteractionHand hand) {
        boolean creative = player.m_150110_().f_35937_;
        boolean bowInfinite = this.isCrossbowInfinite(stack, player);
        int bowFrugal = VampirismItemCrossbow.isCrossbowFrugal(stack);
        ItemStack itemstack = this.findAmmo(player, stack);
        if (!itemstack.m_41619_() || creative) {
            float f;
            if (itemstack.m_41619_()) {
                itemstack = new ItemStack((ItemLike)ModItems.crossbow_arrow_normal);
            }
            if ((double)(f = this.getArrowVelocity()) >= 0.1) {
                boolean consumeArrow = this.shouldConsumeArrow(player.m_21187_(), itemstack, creative, bowInfinite, bowFrugal);
                if (!world.f_46443_) {
                    int k;
                    int j;
                    boolean rightHand = player.m_5737_() == HumanoidArm.RIGHT && hand == InteractionHand.MAIN_HAND || player.m_5737_() == HumanoidArm.LEFT && hand == InteractionHand.OFF_HAND;
                    CrossbowArrowItem itemarrow = itemstack.m_41720_() instanceof IVampirismCrossbowArrow ? (IVampirismCrossbowArrow)itemstack.m_41720_() : ModItems.crossbow_arrow_normal;
                    Object entityarrow = itemarrow.createEntity(itemstack, world, player, heightOffset, 0.3f + centerOffset, rightHand);
                    Vec3 vector3d = player.m_20252_(1.0f);
                    entityarrow.m_6686_(vector3d.m_7096_(), vector3d.m_7098_(), vector3d.m_7094_(), f * 3.0f, 1.0f);
                    if (this.isCritical(player.m_21187_())) {
                        entityarrow.m_36762_(true);
                    }
                    if (this.isIgnoreHurtTime(stack)) {
                        ((IEntityCrossbowArrow)entityarrow).setIgnoreHurtTimer();
                    }
                    if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                        entityarrow.m_36781_(entityarrow.m_36789_() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                        entityarrow.m_36735_(k);
                    }
                    if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                        entityarrow.m_20254_(100);
                    }
                    stack.m_41622_(1, (LivingEntity)player, consumer -> consumer.m_21190_(hand));
                    if (!consumeArrow) {
                        ((AbstractArrow)entityarrow).f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    world.m_7967_(entityarrow);
                    world.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), ModSounds.crossbow, SoundSource.PLAYERS, 1.0f, world.f_46441_.nextFloat() * 0.1f + 0.9f);
                }
                if (consumeArrow) {
                    itemstack.m_41774_(1);
                    if (itemstack.m_41619_()) {
                        player.m_150109_().m_36057_(itemstack);
                    }
                }
                player.m_36335_().m_41524_(stack.m_41720_(), this.getCooldown(player, stack));
                return true;
            }
        }
        return false;
    }

    protected boolean shouldConsumeArrow(Random rnd, ItemStack arrowStack, boolean playerCreative, boolean bowInfinite, int bowFrugal) {
        return !(playerCreative || bowInfinite && this.canArrowBeInfinite(arrowStack) || bowFrugal > 0 && rnd.nextInt(Math.max(2, 4 - bowFrugal)) == 0);
    }

    private boolean canArrowBeInfinite(ItemStack arrowStack) {
        return !(arrowStack.m_41720_() instanceof IVampirismCrossbowArrow) || ((IVampirismCrossbowArrow)arrowStack.m_41720_()).isCanBeInfinite();
    }
}

