/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class VampirismHunterArmor
extends ArmorItem
implements IFactionExclusiveItem {
    protected static final UUID[] VAMPIRISM_ARMOR_MODIFIER = new UUID[]{UUID.fromString("f0b9a417-0cec-4629-8623-053cd0feec3c"), UUID.fromString("e54474a9-62a0-48ee-baaf-7efddca3d711"), UUID.fromString("ac0c33f4-ebbf-44fe-9be3-a729f7633329"), UUID.fromString("8839e157-d576-4cff-bf34-0a788131fe0f")};
    private final Multimap<Attribute, AttributeModifier> modifierMultimap;
    private final String translation_key;

    public VampirismHunterArmor(String baseRegName, @Nullable String suffix, ArmorMaterial materialIn, EquipmentSlot equipmentSlotIn, Item.Properties props) {
        this(baseRegName, suffix, materialIn, equipmentSlotIn, props, (Map<Attribute, Tuple<Double, AttributeModifier.Operation>>)ImmutableMap.of());
    }

    public VampirismHunterArmor(String baseRegName, @Nullable String suffix, ArmorMaterial materialIn, EquipmentSlot equipmentSlotIn, Item.Properties props, Map<Attribute, Tuple<Double, AttributeModifier.Operation>> modifiers) {
        super(materialIn, equipmentSlotIn, props);
        String regName = baseRegName + "_" + equipmentSlotIn.m_20751_();
        if (suffix != null) {
            regName = regName + "_" + suffix;
        }
        this.setRegistryName("vampirism", regName);
        this.translation_key = Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("vampirism", baseRegName + "_" + equipmentSlotIn.m_20751_()));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry<Attribute, Tuple<Double, AttributeModifier.Operation>> modifier : modifiers.entrySet()) {
            builder.put((Object)modifier.getKey(), (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[this.f_40377_.m_20749_()], "Vampirism armor modifier", ((Double)modifier.getValue().m_14418_()).doubleValue(), (AttributeModifier.Operation)modifier.getValue().m_14419_()));
        }
        if (!modifiers.containsKey(Attributes.f_22284_)) {
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[this.f_40377_.m_20749_()], "Vampirism armor modifier", (double)materialIn.m_7365_(equipmentSlotIn), AttributeModifier.Operation.ADDITION));
        }
        if (!modifiers.containsKey(Attributes.f_22285_) && materialIn.m_6651_() > 0.0f) {
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[this.f_40377_.m_20749_()], "Vampirism armor modifier", (double)materialIn.m_6651_(), AttributeModifier.Operation.ADDITION));
        }
        if (!modifiers.containsKey(Attributes.f_22278_) && materialIn.m_6649_() > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[this.f_40377_.m_20749_()], "Armor knockback resistance", (double)materialIn.m_6649_(), AttributeModifier.Operation.ADDITION));
        }
        this.modifierMultimap = builder.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        Player player = VampirismMod.proxy.getClientPlayer();
        this.addFactionPoisonousToolTip(stack, worldIn, tooltip, flagIn, player);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == this.f_40377_) {
            return this.modifierMultimap;
        }
        return ImmutableMultimap.of();
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@Nonnull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        IPlayableFaction<?> f;
        if (player.f_19797_ % 16 == 8 && (f = VampirismPlayerAttributes.get((Player)player).faction) != null && !VReference.HUNTER_FACTION.equals(f)) {
            player.m_7292_(new MobEffectInstance(ModEffects.poison, 20, 1));
        }
    }

    @Nonnull
    protected String m_41467_() {
        return this.translation_key;
    }

    protected String getTextureLocation(String name, EquipmentSlot slot, String type) {
        return String.format("vampirism:textures/models/armor/%s_layer_%d%s.png", name, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : "_overlay");
    }
}

