/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.HunterActionTrigger;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.hunter.IAdvancedHunter;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.VampirismItemWeapon;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;

public class StakeItem
extends VampirismItemWeapon
implements IVampireFinisher,
IFactionExclusiveItem {
    private static final String regName = "stake";

    public static boolean canKillInstant(LivingEntity target, LivingEntity attacker) {
        boolean instaKillFromBehind = false;
        boolean instaKillLowHealth = false;
        if (attacker instanceof Player && attacker.m_6084_()) {
            IFactionPlayer factionPlayer = FactionPlayerHandler.getOpt((Player)attacker).resolve().flatMap(FactionPlayerHandler::getCurrentFactionPlayer).orElse(null);
            if (factionPlayer != null && factionPlayer.getFaction().equals(VReference.HUNTER_FACTION)) {
                ISkillHandler skillHandler = factionPlayer.getSkillHandler();
                if (skillHandler.isSkillEnabled(HunterSkills.stake2)) {
                    instaKillFromBehind = true;
                }
                if (skillHandler.isSkillEnabled(HunterSkills.stake1)) {
                    instaKillLowHealth = true;
                }
            }
        } else if (attacker instanceof IAdvancedHunter) {
            instaKillLowHealth = true;
        }
        if (instaKillFromBehind && !UtilLib.canReallySee(target, attacker, true)) {
            return ((Boolean)VampirismConfig.BALANCE.hsInstantKill2OnlyNPC.get() == false || !(target instanceof Player)) && target.m_21233_() < (float)((Integer)VampirismConfig.BALANCE.hsInstantKill2MaxHealth.get()).intValue();
        }
        if (instaKillLowHealth && (double)target.m_21223_() <= (Double)VampirismConfig.BALANCE.hsInstantKill1MaxHealth.get() * (double)target.m_21233_()) {
            return (Boolean)VampirismConfig.BALANCE.hsInstantKill1FromBehind.get() == false || !UtilLib.canReallySee(target, attacker, true);
        }
        return false;
    }

    public StakeItem() {
        super(regName, (Tier)Tiers.WOOD, 1, -1.0f, new Item.Properties().m_41491_(VampirismMod.creativeTab));
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@Nonnull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    public boolean m_7579_(@Nonnull ItemStack stack, @Nonnull LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_20193_().f_46443_ && (target instanceof IVampireMob || target instanceof Player && Helper.isVampire((Player)target)) && StakeItem.canKillInstant(target, attacker)) {
            DamageSource dmg = attacker instanceof Player ? DamageSource.m_19344_((Player)((Player)attacker)) : DamageSource.m_19370_((LivingEntity)attacker);
            dmg = dmg.m_19380_();
            target.m_6469_(dmg, 10000.0f);
            if (attacker instanceof ServerPlayer) {
                ModAdvancements.TRIGGER_HUNTER_ACTION.trigger((ServerPlayer)attacker, HunterActionTrigger.Action.STAKE);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }
}

