/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.util.WeightedRandomItem;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.refinements.RefinementSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class RefinementItem
extends Item
implements IRefinementItem {
    public static final int MAX_DAMAGE = 500;
    private static final Random RANDOM = new Random();
    private final IRefinementItem.AccessorySlotType type;

    public static ItemStack getRandomRefinementItem(IPlayableFaction<?> faction) {
        ItemStack stack;
        List sets = ModRegistries.REFINEMENT_SETS.getValues().stream().filter(set -> set.getFaction() == faction).map(a -> ((RefinementSet)a).getWeightedRandom()).collect(Collectors.toList());
        if (sets.isEmpty()) {
            return ItemStack.f_41583_;
        }
        IRefinementSet s = WeightedRandom.m_146317_((Random)RANDOM, sets).map(WeightedRandomItem::getItem).orElseGet(() -> (IRefinementSet)((WeightedRandomItem)((Object)((Object)sets.get(0)))).getItem());
        IRefinementItem.AccessorySlotType t = s.getSlotType().orElseGet(() -> switch (RANDOM.nextInt(3)) {
            case 0 -> IRefinementItem.AccessorySlotType.OBI_BELT;
            case 1 -> IRefinementItem.AccessorySlotType.RING;
            default -> IRefinementItem.AccessorySlotType.AMULET;
        });
        IRefinementItem i = (IRefinementItem)faction.getRefinementItem(t);
        if (i.applyRefinementSet(stack = new ItemStack((ItemLike)((Item)i)), s)) {
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static IRefinementSet getRandomRefinementForItem(@Nullable IFaction<?> faction, IRefinementItem stack) {
        List sets = ModRegistries.REFINEMENT_SETS.getValues().stream().filter(set -> faction == null || set.getFaction() == faction).filter(set -> set.getSlotType().map(s -> s == stack.getSlotType()).orElse(true)).map(a -> ((RefinementSet)a).getWeightedRandom()).collect(Collectors.toList());
        if (sets.isEmpty()) {
            return null;
        }
        return WeightedRandom.m_146317_((Random)RANDOM, sets).map(WeightedRandomItem::getItem).orElse(null);
    }

    public RefinementItem(Item.Properties properties, IRefinementItem.AccessorySlotType type) {
        super(properties.m_41499_(500).setNoRepair());
        this.type = type;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        IRefinementSet set = this.getRefinementSet(stack);
        if (set != null) {
            for (IRefinement refinement : set.getRefinements()) {
                tooltip.add((Component)new TextComponent(" - ").m_7220_(refinement.getDescription()).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    @Override
    public boolean applyRefinementSet(ItemStack stack, IRefinementSet set) {
        if (set.getSlotType().map(t -> t == this.type).orElse(true).booleanValue()) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128359_("refinement_set", set.getRegistryName().toString());
            return true;
        }
        return false;
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        IRefinementSet set = this.getRefinementSet(stack);
        if (set == null) {
            return super.m_7626_(stack);
        }
        return new TranslatableComponent(this.m_5524_()).m_130946_(" ").m_7220_(set.getName()).m_130940_(set.getRarity().color);
    }

    @Override
    @Nullable
    public IRefinementSet getRefinementSet(ItemStack stack) {
        String refinementsNBT = stack.m_41784_().m_128461_("refinement_set");
        return (IRefinementSet)ModRegistries.REFINEMENT_SETS.getValue(new ResourceLocation(refinementsNBT));
    }

    @Override
    public IRefinementItem.AccessorySlotType getSlotType() {
        return this.type;
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        if (!worldIn.m_5776_()) {
            ItemStack stack = playerIn.m_21120_(handIn);
            if (FactionPlayerHandler.getOpt(playerIn).map(v -> v).flatMap(FactionPlayerHandler::getCurrentFactionPlayer).map(IFactionPlayer::getSkillHandler).map(sh -> sh.equipRefinementItem(stack)).orElse(false).booleanValue()) {
                return InteractionResultHolder.m_19096_((Object)ItemStack.f_41583_);
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }
}

