/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampireClothingItem;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PureBloodItem
extends VampirismItem {
    public static final int COUNT = 5;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String name = "pure_blood";
    private final int level;

    public static Item getBloodItemForLevel(int level) {
        switch (level) {
            case 0: {
                return ModItems.pure_blood_0;
            }
            case 1: {
                return ModItems.pure_blood_1;
            }
            case 2: {
                return ModItems.pure_blood_2;
            }
            case 3: {
                return ModItems.pure_blood_3;
            }
            case 4: {
                return ModItems.pure_blood_4;
            }
        }
        LOGGER.warn("Pure blood of level {} does not exist", (Object)level);
        return ModItems.pure_blood_4;
    }

    public PureBloodItem(int level) {
        super("pure_blood_" + level, new Item.Properties().m_41491_(VampirismMod.creativeTab));
        this.level = level;
        this.setTranslation_key(name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.vampirism.pure_blood.purity").m_7220_((Component)new TextComponent(": " + (this.level + 1) + "/5")).m_130940_(ChatFormatting.RED));
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level worldIn, @Nonnull LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            VampirePlayer.getOpt((Player)entityLiving).ifPresent(v -> {
                v.drinkBlood(50, 0.3f, false);
                entityLiving.m_7292_(new MobEffectInstance(ModEffects.saturation));
                stack.m_41774_(1);
                this.checkWingConditions((VampirePlayer)v);
            });
        }
        return stack;
    }

    public int getLevel() {
        return this.level;
    }

    public Component getCustomName() {
        return new TranslatableComponent(this.m_41467_()).m_7220_((Component)new TextComponent(" " + (this.level + 1)));
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 30;
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        int playerLevel = VampirismAPI.getFactionPlayerHandler(playerIn).map(fph -> fph.getCurrentLevel(VReference.VAMPIRE_FACTION)).orElse(0);
        if (VampireLevelingConf.getInstance().isLevelValidForAltarInfusion(playerLevel)) {
            int pureLevel = VampireLevelingConf.getInstance().getAltarInfusionRequirements(playerLevel).pureBloodLevel();
            if (this.getLevel() < pureLevel) {
                playerIn.m_6672_(handIn);
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    private void checkWingConditions(VampirePlayer p) {
        Player e = p.getRepresentingPlayer();
        if (!e.m_150110_().f_35937_ && !e.f_19853_.m_5776_() && e.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof VampireClothingItem) {
            p.triggerWings();
        }
    }
}

