/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HunterIntelItem
extends VampirismItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String name = "hunter_intel";
    private final int level;
    private Component tooltip;

    public static HunterIntelItem getIntelForExactlyLevel(int level) {
        return HunterIntelItem.getIntelForLevel(level - 5);
    }

    public static HunterIntelItem getIntelForLevel(int level) {
        switch (level) {
            case 0: {
                return ModItems.hunter_intel_0;
            }
            case 1: {
                return ModItems.hunter_intel_1;
            }
            case 2: {
                return ModItems.hunter_intel_2;
            }
            case 3: {
                return ModItems.hunter_intel_3;
            }
            case 4: {
                return ModItems.hunter_intel_4;
            }
            case 5: {
                return ModItems.hunter_intel_5;
            }
            case 6: {
                return ModItems.hunter_intel_6;
            }
            case 7: {
                return ModItems.hunter_intel_7;
            }
            case 8: {
                return ModItems.hunter_intel_8;
            }
            case 9: {
                return ModItems.hunter_intel_9;
            }
        }
        LOGGER.warn("HunterIntel of level {} does not exist", (Object)level);
        return ModItems.hunter_intel_9;
    }

    public HunterIntelItem(int level) {
        super("hunter_intel_" + level, new Item.Properties().m_41491_(VampirismMod.creativeTab));
        this.level = level;
        this.setTranslation_key(name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flagIn) {
        if (this.tooltip == null) {
            this.tooltip = new TranslatableComponent("text.vampirism.for_up_to_level").m_7220_((Component)new TextComponent(": " + (this.level + 5))).m_130940_(ChatFormatting.RED);
        }
        tooltips.add(this.tooltip);
    }

    public Component getCustomName() {
        return new TranslatableComponent(this.m_41467_()).m_7220_((Component)new TextComponent(" ")).m_7220_((Component)new TranslatableComponent("text.vampirism.for_up_to_level").m_7220_((Component)new TextComponent(" " + (this.level + 5))));
    }

    public int getLevel() {
        return this.level;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(@Nonnull ItemStack stack) {
        return true;
    }
}

