/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterWeapon;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HunterAxeItem
extends VampirismHunterWeapon
implements IItemWithTier {
    private static final String regName = "hunter_axe";
    private final IItemWithTier.TIER tier;

    public HunterAxeItem(IItemWithTier.TIER tier) {
        super("hunter_axe_" + tier.getName(), (Tier)Tiers.IRON, 10, -2.9f, new Item.Properties().m_41491_(VampirismMod.creativeTab));
        this.tier = tier;
        this.setTranslation_key(regName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(tooltip);
        tooltip.add((Component)new TranslatableComponent("text.vampirism.deals_more_damage_to", new Object[]{Math.round((this.getVampireMult() - 1.0f) * 100.0f), VReference.VAMPIRE_FACTION.getNamePlural()}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)this.getEnchantedStack());
        }
    }

    @Override
    public String getBaseRegName() {
        return regName;
    }

    @Override
    public float getDamageMultiplierForFaction(@Nonnull ItemStack stack) {
        return this.getVampireMult();
    }

    public ItemStack getEnchantedStack() {
        ItemStack stack = new ItemStack((ItemLike)this);
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        map.put(Enchantments.f_44980_, this.getKnockback());
        EnchantmentHelper.m_44865_(map, (ItemStack)stack);
        return stack;
    }

    @Override
    public int getMinLevel(@Nonnull ItemStack stack) {
        return this.getMinLevel();
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    public boolean m_5812_(@Nonnull ItemStack stack) {
        return false;
    }

    private int getKnockback() {
        return switch (this.tier) {
            case IItemWithTier.TIER.ULTIMATE -> 4;
            case IItemWithTier.TIER.ENHANCED -> 3;
            default -> 2;
        };
    }

    private int getMinLevel() {
        return switch (this.tier) {
            case IItemWithTier.TIER.ULTIMATE -> 8;
            case IItemWithTier.TIER.ENHANCED -> 6;
            default -> 4;
        };
    }

    private float getVampireMult() {
        return switch (this.tier) {
            case IItemWithTier.TIER.ULTIMATE -> 1.5f;
            case IItemWithTier.TIER.ENHANCED -> 1.3f;
            default -> 1.2f;
        };
    }
}

