/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import de.teamlapen.vampirism.util.VampirismArmorMaterials;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmorOfSwiftnessItem
extends VampirismHunterArmor
implements IItemWithTier,
DyeableLeatherItem {
    private static final String baseRegName = "armor_of_swiftness";
    private static final int[] DAMAGE_REDUCTION_ULTIMATE = new int[]{3, 6, 8, 3};
    private static final int[] DAMAGE_REDUCTION_ENHANCED = new int[]{2, 5, 6, 2};
    private static final int[] DAMAGE_REDUCTION_NORMAL = new int[]{1, 2, 3, 1};
    private final IItemWithTier.TIER tier;

    private static Map<Attribute, Tuple<Double, AttributeModifier.Operation>> getModifiers(EquipmentSlot slot, IItemWithTier.TIER tier) {
        HashMap<Attribute, Tuple<Double, AttributeModifier.Operation>> map = new HashMap<Attribute, Tuple<Double, AttributeModifier.Operation>>();
        int slot1 = slot.m_20749_();
        int damageReduction = switch (tier) {
            case IItemWithTier.TIER.ULTIMATE -> DAMAGE_REDUCTION_ULTIMATE[slot1];
            case IItemWithTier.TIER.ENHANCED -> DAMAGE_REDUCTION_ENHANCED[slot1];
            default -> DAMAGE_REDUCTION_NORMAL[slot1];
        };
        double speedReduction = switch (tier) {
            case IItemWithTier.TIER.ULTIMATE -> 0.1;
            case IItemWithTier.TIER.ENHANCED -> 0.075;
            default -> 0.035;
        };
        map.put(Attributes.f_22284_, new Tuple((Object)damageReduction, (Object)AttributeModifier.Operation.ADDITION));
        map.put(Attributes.f_22279_, new Tuple((Object)speedReduction, (Object)AttributeModifier.Operation.MULTIPLY_TOTAL));
        return map;
    }

    public ArmorOfSwiftnessItem(EquipmentSlot equipmentSlotIn, IItemWithTier.TIER tier) {
        super(baseRegName, tier.m_7912_(), VampirismArmorMaterials.MASTERLY_LEATHER, equipmentSlotIn, new Item.Properties().m_41491_(VampirismMod.creativeTab), ArmorOfSwiftnessItem.getModifiers(equipmentSlotIn, tier));
        this.tier = tier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(tooltip);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (type == null) {
            return this.getTextureLocationLeather(slot);
        }
        return switch (this.getVampirismTier()) {
            case IItemWithTier.TIER.ENHANCED -> this.getTextureLocation("swiftness_enhanced", slot, type);
            case IItemWithTier.TIER.ULTIMATE -> this.getTextureLocation("swiftness_ultimate", slot, type);
            default -> this.getTextureLocation("swiftness", slot, type);
        };
    }

    @Override
    public String getBaseRegName() {
        return baseRegName;
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @Override
    public void onArmorTick(ItemStack itemStack, Level world, Player player) {
        super.onArmorTick(itemStack, world, player);
        if (player.f_19797_ % 45 == 3 && this.m_40402_() == EquipmentSlot.CHEST) {
            boolean flag = true;
            int boost = Integer.MAX_VALUE;
            for (ItemStack stack : player.m_150109_().f_35975_) {
                if (!stack.m_41619_() && stack.m_41720_() instanceof ArmorOfSwiftnessItem) {
                    int b = this.getJumpBoost(this.getVampirismTier());
                    if (b >= boost) continue;
                    boost = b;
                    continue;
                }
                flag = false;
                break;
            }
            if (flag && boost > -1) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 50, boost, false, false));
            }
        }
    }

    private int getJumpBoost(IItemWithTier.TIER tier) {
        return switch (tier) {
            case IItemWithTier.TIER.ULTIMATE -> 1;
            case IItemWithTier.TIER.ENHANCED -> 0;
            default -> -1;
        };
    }

    private String getTextureLocationLeather(EquipmentSlot slot) {
        return String.format("minecraft:textures/models/armor/leather_layer_%d.png", slot == EquipmentSlot.LEGS ? 2 : 1);
    }
}

