/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.inventory.recipes.VampirismRecipeHelper;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

@ParametersAreNonnullByDefault
public class ShapelessWeaponTableRecipe
implements CraftingRecipe,
IWeaponTableRecipe {
    protected static int MAX_WIDTH = 4;
    protected static int MAX_HEIGHT = 4;
    private final ResourceLocation id;
    private final String group;
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final int requiredLevel;
    private final ISkill<IHunterPlayer>[] requiredSkills;
    private final int requiredLava;
    private final boolean isSimple;

    public ShapelessWeaponTableRecipe(ResourceLocation recipeId, String group, NonNullList<Ingredient> ingredients, ItemStack result, int level, int lava, @Nonnull ISkill<IHunterPlayer>[] skills) {
        this.id = recipeId;
        this.group = group;
        this.recipeItems = ingredients;
        this.recipeOutput = result;
        this.requiredLevel = level;
        this.requiredLava = lava;
        this.requiredSkills = skills;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    @Override
    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        return this.recipeOutput.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    @Nonnull
    public String m_6076_() {
        return this.group;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.recipeOutput;
    }

    @Override
    public int getRequiredLavaUnits() {
        return this.requiredLava;
    }

    @Override
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Override
    @Nonnull
    public ISkill<IHunterPlayer>[] getRequiredSkills() {
        return this.requiredSkills;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.shapeless_crafting_weapontable;
    }

    @Nonnull
    public RecipeType<IWeaponTableRecipe> m_6671_() {
        return ModRecipes.WEAPONTABLE_CRAFTING_TYPE;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        StackedContents recipeitemhelper = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inv.m_39346_(); ++j) {
            for (int k = 0; k < inv.m_39347_(); ++k) {
                ItemStack itemstack = inv.m_8020_(k + j * inv.m_39347_());
                if (itemstack.m_41619_()) continue;
                ++i;
                if (this.isSimple) {
                    recipeitemhelper.m_36491_(new ItemStack((ItemLike)itemstack.m_41720_()));
                    continue;
                }
                inputs.add(itemstack);
            }
        }
        return i == this.recipeItems.size() && (this.isSimple ? recipeitemhelper.m_36475_((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null);
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapelessWeaponTableRecipe> {
        @Nonnull
        public ShapelessWeaponTableRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = VampirismRecipeHelper.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            int level = GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1);
            ISkill<?>[] skills = VampirismRecipeHelper.deserializeSkills(GsonHelper.m_13832_((JsonObject)json, (String)"skill", null));
            int lava = GsonHelper.m_13824_((JsonObject)json, (String)"lava", (int)0);
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ingredients.size() > MAX_WIDTH * MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is " + MAX_WIDTH * MAX_HEIGHT);
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return new ShapelessWeaponTableRecipe(recipeId, group, ingredients, result, level, lava, skills);
        }

        public ShapelessWeaponTableRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.m_122780_((int)buffer.m_130242_(), (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            int level = buffer.m_130242_();
            int lava = buffer.m_130242_();
            ISkill[] skills = new ISkill[buffer.m_130242_()];
            for (int i = 0; i < skills.length; ++i) {
                skills[i] = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE)));
            }
            return new ShapelessWeaponTableRecipe(recipeId, group, (NonNullList<Ingredient>)ingredients, result, level, lava, skills);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessWeaponTableRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.recipeOutput);
            buffer.m_130130_(recipe.requiredLevel);
            buffer.m_130130_(recipe.requiredLava);
            buffer.m_130130_(recipe.requiredSkills.length);
            for (ISkill<IHunterPlayer> skill : recipe.requiredSkills) {
                buffer.m_130070_(skill.getRegistryName().toString());
            }
        }
    }
}

