/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.inventory.recipes.VampirismRecipeHelper;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AlchemicalCauldronRecipe
extends AbstractCookingRecipe {
    private static final ISkill<?>[] EMPTY_SKILLS = new ISkill[0];
    private final Either<Ingredient, FluidStack> fluid;
    @Nonnull
    private final ISkill<?>[] skills;
    private final int reqLevel;

    public AlchemicalCauldronRecipe(ResourceLocation idIn, String groupIn, Ingredient ingredientIn, Either<Ingredient, FluidStack> fluidIn, ItemStack resultIn, @Nonnull ISkill<?>[] skillsIn, int reqLevelIn, int cookTimeIn, float exp) {
        super(ModRecipes.ALCHEMICAL_CAULDRON_TYPE, idIn, groupIn, ingredientIn, resultIn, exp, cookTimeIn);
        this.fluid = fluidIn;
        this.skills = skillsIn;
        this.reqLevel = reqLevelIn;
    }

    public boolean canBeCooked(int level, ISkillHandler<IHunterPlayer> skillHandler) {
        if (level < this.reqLevel) {
            return false;
        }
        for (ISkill<?> s : this.skills) {
            if (skillHandler.isSkillEnabled(s)) continue;
            return false;
        }
        return true;
    }

    public Either<Ingredient, FluidStack> getFluid() {
        return this.fluid;
    }

    public int getRequiredLevel() {
        return this.reqLevel;
    }

    @Nonnull
    public ISkill<?>[] getRequiredSkills() {
        return this.skills;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.alchemical_cauldron;
    }

    public boolean m_5818_(Container inv, @Nonnull Level worldIn) {
        boolean match = this.f_43729_.test(inv.m_8020_(1));
        AtomicBoolean fluidMatch = new AtomicBoolean(true);
        this.fluid.ifLeft(ingredient1 -> fluidMatch.set(ingredient1.test(inv.m_8020_(0))));
        this.fluid.ifRight(ingredient1 -> {
            fluidMatch.set(false);
            Optional stack = FluidUtil.getFluidContained((ItemStack)inv.m_8020_(0));
            stack.ifPresent(handlerItem -> fluidMatch.set(ingredient1.isFluidEqual(handlerItem) && ingredient1.getAmount() <= handlerItem.getAmount()));
        });
        return match && fluidMatch.get();
    }

    public String toString() {
        return "AlchemicalCauldronRecipe{cookingTime=" + this.f_43732_ + ", skills=" + Arrays.toString(this.skills) + ", output=" + this.f_43730_ + ", ingredient=" + this.f_43729_ + ", reqLevel=" + this.reqLevel + ", experience=" + this.f_43731_ + ", fluid=" + this.fluid + "}";
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<AlchemicalCauldronRecipe> {
        @Nonnull
        public AlchemicalCauldronRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredients = Ingredient.m_43917_((JsonElement)(GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient")));
            int level = GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1);
            ISkill<?>[] skills = VampirismRecipeHelper.deserializeSkills(GsonHelper.m_13832_((JsonObject)json, (String)"skill", null));
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            Either<Ingredient, FluidStack> fluid = VampirismRecipeHelper.getFluidOrItem(json);
            int cookTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookTime", (int)200);
            float exp = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.2f);
            return new AlchemicalCauldronRecipe(recipeId, group, ingredients, fluid, result, skills, level, cookTime, exp);
        }

        public AlchemicalCauldronRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            ItemStack result = buffer.m_130267_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Either fluid = buffer.readBoolean() ? Either.left((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer)) : Either.right((Object)FluidStack.readFromPacket((FriendlyByteBuf)buffer));
            float exp = buffer.readFloat();
            int cookingtime = buffer.m_130242_();
            int level = buffer.m_130242_();
            ISkill[] skills = new ISkill[buffer.m_130242_()];
            for (int i = 0; i < skills.length; ++i) {
                skills[i] = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE)));
            }
            return new AlchemicalCauldronRecipe(recipeId, group, ingredient, (Either<Ingredient, FluidStack>)fluid, result, skills, level, cookingtime, exp);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlchemicalCauldronRecipe recipe) {
            buffer.m_130070_(recipe.f_43728_);
            buffer.m_130055_(recipe.f_43730_);
            recipe.f_43729_.m_43923_(buffer);
            if (recipe.fluid.left().isPresent()) {
                buffer.writeBoolean(true);
                ((Ingredient)recipe.fluid.left().get()).m_43923_(buffer);
            } else {
                assert (recipe.fluid.right().isPresent());
                buffer.writeBoolean(false);
                ((FluidStack)recipe.fluid.right().get()).writeToPacket(buffer);
            }
            buffer.writeFloat(recipe.f_43731_);
            buffer.m_130130_(recipe.f_43732_);
            buffer.m_130130_(recipe.reqLevel);
            buffer.m_130130_(recipe.skills.length);
            for (ISkill<?> skill : recipe.skills) {
                buffer.m_130070_(skill.getRegistryName().toString());
            }
        }
    }
}

