/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.core.ModContainer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.IContainerFactory;

public class PotionTableContainer
extends InventoryContainer {
    public static InventoryContainer.SelectorInfo[] SELECTOR_INFOS = new InventoryContainer.SelectorInfo[6];
    public static InventoryContainer.SelectorInfo[] SELECTOR_INFOS_EXTENDED = new InventoryContainer.SelectorInfo[8];
    private final boolean extended;
    private final ContainerData syncedProperties;

    public PotionTableContainer(int id, Inventory playerInventory, ContainerLevelAccess worldPos, @Nonnull Container inventory, boolean extended, @Nullable ContainerData syncedProperties) {
        super(ModContainer.extended_potion_table, id, playerInventory, worldPos, inventory, extended ? SELECTOR_INFOS_EXTENDED : SELECTOR_INFOS);
        assert (inventory.m_6643_() >= (extended ? 8 : 6));
        this.syncedProperties = syncedProperties == null ? new SimpleContainerData(2) : syncedProperties;
        this.addPlayerSlots(playerInventory);
        this.m_38884_(this.syncedProperties);
        this.extended = extended;
    }

    public int getBrewTime() {
        return this.syncedProperties.m_6413_(0);
    }

    public int getFuelTime() {
        return this.syncedProperties.m_6413_(1);
    }

    public boolean isExtendedTable() {
        return this.extended;
    }

    @Override
    protected boolean isSlotEnabled(int id) {
        return id <= 5 || this.isExtendedTable();
    }

    static {
        PotionTableContainer.SELECTOR_INFOS[0] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[0] = new InventoryContainer.SelectorInfo((Predicate<ItemStack>)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42593_}), 23, 14);
        PotionTableContainer.SELECTOR_INFOS[1] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[1] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidExtraIngredient((ItemStack)stack), 101, 16);
        PotionTableContainer.SELECTOR_INFOS[2] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[2] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidIngredient((ItemStack)stack), 126, 8);
        PotionTableContainer.SELECTOR_INFOS[3] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[3] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 148, 59);
        PotionTableContainer.SELECTOR_INFOS[4] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[4] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 126, 59);
        PotionTableContainer.SELECTOR_INFOS[5] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[5] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 104, 59);
        PotionTableContainer.SELECTOR_INFOS_EXTENDED[6] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 82, 59);
        PotionTableContainer.SELECTOR_INFOS_EXTENDED[7] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 60, 59);
    }

    public static class Factory
    implements IContainerFactory<PotionTableContainer> {
        @Nullable
        public PotionTableContainer create(int windowId, Inventory inv, FriendlyByteBuf data) {
            if (data == null) {
                return new PotionTableContainer(windowId, inv, ContainerLevelAccess.f_39287_, (Container)new SimpleContainer(6), false, null);
            }
            boolean extraSlots = data.readBoolean();
            return new PotionTableContainer(windowId, inv, ContainerLevelAccess.f_39287_, (Container)new SimpleContainer(extraSlots ? 8 : 6), extraSlots, null);
        }
    }
}

