/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.vampire.IVampireBaron;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.goals.AttackRangedDarkBloodGoal;
import de.teamlapen.vampirism.entity.goals.FleeGarlicVampireGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampireBaronEntity
extends VampireBaseEntity
implements IVampireBaron {
    public static final int MAX_LEVEL = 4;
    private static final Logger LOGGER = LogManager.getLogger(VampireBaronEntity.class);
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(VampireBaronEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.m_135353_(VampireBaronEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LADY = SynchedEntityData.m_135353_(VampireBaronEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int ENRAGED_TRANSITION_TIME = 15;
    private int attackDecisionCounter = 0;
    private boolean rangedAttack = false;
    private boolean prevAttacking = false;
    private int followingEntities = 0;
    private int enragedTransitionTime = 0;

    public static boolean spawnPredicateBaron(EntityType<? extends VampireBaronEntity> entityType, LevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, Random random) {
        return world.m_204166_(blockPos).m_203656_(ModTags.Biomes.IS_VAMPIRE_BIOME) && world.m_46791_() != net.minecraft.world.Difficulty.PEACEFUL && Mob.m_21400_(entityType, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (Random)random);
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return VampireBaseEntity.getAttributeBuilder().m_22268_(Attributes.f_22276_, BalanceMobProps.mobProps.VAMPIRE_BARON_MAX_HEALTH).m_22268_(Attributes.f_22281_, BalanceMobProps.mobProps.VAMPIRE_BARON_ATTACK_DAMAGE).m_22268_(Attributes.f_22279_, BalanceMobProps.mobProps.VAMPIRE_BARON_MOVEMENT_SPEED).m_22268_(Attributes.f_22277_, 5.0);
    }

    public VampireBaronEntity(EntityType<? extends VampireBaronEntity> type, Level world) {
        super(type, world, true);
        this.garlicResist = EnumStrength.MEDIUM;
        this.hasArms = true;
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("level", this.getEntityLevel());
        nbt.m_128379_("lady", this.isLady());
    }

    @Override
    public void m_8107_() {
        if (!this.prevAttacking && this.m_5448_() != null) {
            this.prevAttacking = true;
            this.updateEntityAttributes(true);
        }
        if (this.prevAttacking && this.m_5448_() == null) {
            this.prevAttacking = false;
            this.rangedAttack = false;
            this.attackDecisionCounter = 0;
            this.updateEntityAttributes(false);
        }
        if (!this.f_19853_.f_46443_ && this.isGettingSundamage((LevelAccessor)this.f_19853_)) {
            this.teleportAway();
        }
        if (!this.f_19853_.f_46443_ && this.m_5448_() != null && this.f_19797_ % 128 == 0) {
            if (this.rangedAttack) {
                if (this.f_19796_.nextInt(2) == 0 && this.f_21344_.m_6570_((Entity)this.m_5448_(), 0) != null) {
                    this.rangedAttack = false;
                }
            } else if (this.attackDecisionCounter > 4 || this.f_19796_.nextInt(6) == 0) {
                this.rangedAttack = true;
                this.attackDecisionCounter = 0;
            }
            if (this.getEntityLevel() > 3 && this.f_19796_.nextInt(9) == 0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 60));
            }
        }
        if (this.f_19853_.m_5776_()) {
            if (this.isEnraged() && this.enragedTransitionTime < 15) {
                ++this.enragedTransitionTime;
            } else if (!this.isEnraged() && this.enragedTransitionTime > 0) {
                --this.enragedTransitionTime;
            }
        }
        super.m_8107_();
    }

    @Override
    public boolean m_5545_(@Nonnull LevelAccessor worldIn, @Nonnull MobSpawnType spawnReasonIn) {
        int i = Mth.m_14107_((double)this.m_142469_().f_82289_);
        if (i < 60) {
            return false;
        }
        BlockPos blockpos = new BlockPos(this.m_20185_(), this.m_142469_().f_82289_, this.m_20189_());
        return worldIn.m_8055_(blockpos.m_7495_()).m_204336_(ModTags.Blocks.CURSEDEARTH) && super.m_5545_(worldIn, spawnReasonIn);
    }

    @Override
    public void decreaseFollowerCount() {
        this.followingEntities = Math.max(0, this.followingEntities - 1);
    }

    @Override
    public boolean m_7327_(@Nonnull Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag && entity instanceof LivingEntity) {
            float tm = 1.0f;
            int mr = 1;
            if (entity instanceof Player) {
                float pld = (float)(this.getEntityLevel() + 1) - (float)VampirismPlayerAttributes.get((Player)((Player)entity)).vampireLevel / 3.0f;
                tm = pld + 1.0f;
                int n = pld < 1.5f ? 1 : (mr = pld < 3.0f ? 2 : 3);
                if (VampirismPlayerAttributes.get((Player)((Player)entity)).getHuntSpecial().fullHunterCoat != null) {
                    tm *= 0.5f;
                }
            }
            if (entity instanceof VampireBaronEntity) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19600_, 40, 5));
            }
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19613_, (int)(200.0f * tm), this.f_19796_.nextInt(mr)));
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)(100.0f * tm), this.f_19796_.nextInt(mr)));
            this.attackDecisionCounter = 0;
        }
        return flag;
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_20088_().m_135381_(LADY, (Object)this.m_21187_().nextBoolean());
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEnragedProgress() {
        return (float)this.enragedTransitionTime / 15.0f;
    }

    @Override
    public int getFollowingCount() {
        return this.followingEntities;
    }

    @Override
    public int getEntityLevel() {
        return (Integer)this.m_20088_().m_135370_(LEVEL);
    }

    @Override
    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.m_20088_().m_135381_(LEVEL, (Object)level);
            this.updateEntityAttributes(false);
            float hp = this.m_21223_() / this.m_21233_();
            this.m_21153_(this.m_21233_() * hp);
            this.m_6593_((Component)this.m_5677_().m_6879_().m_7220_((Component)new TranslatableComponent("entity.vampirism.vampire_baron.level", new Object[]{level + 1})));
        } else {
            this.m_6593_(null);
        }
    }

    public int m_8132_() {
        return 5;
    }

    @Override
    public int getMaxFollowerCount() {
        return (int)((float)(BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * this.getEntityLevel()) / (float)this.getMaxEntityLevel() * 2.0f);
    }

    public int m_8085_() {
        return 5;
    }

    @Override
    public int getMaxEntityLevel() {
        return 4;
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public int m_6078_() {
        return 500;
    }

    @Override
    public boolean increaseFollowerCount() {
        if (this.followingEntities < this.getMaxFollowerCount()) {
            ++this.followingEntities;
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6469_(@Nonnull DamageSource damageSource, float amount) {
        ++this.attackDecisionCounter;
        return super.m_6469_(damageSource, amount);
    }

    public boolean isEnraged() {
        return (Boolean)this.m_20088_().m_135370_(ENRAGED);
    }

    public boolean isLady() {
        return (Boolean)this.m_20088_().m_135370_(LADY);
    }

    public void setLady(boolean lady) {
        this.m_20088_().m_135381_(LADY, (Object)lady);
    }

    public void m_5837_(@Nonnull ServerLevel world, @Nonnull LivingEntity entity) {
        super.m_5837_(world, entity);
        if (entity instanceof VampireBaronEntity) {
            this.m_21153_(this.m_21233_());
        }
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setEntityLevel(nbt.m_128441_("level") ? Mth.m_14045_((int)nbt.m_128451_("level"), (int)0, (int)4) : -1);
        this.m_20088_().m_135381_(LADY, (Object)nbt.m_128471_("lady"));
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        this.m_20088_().m_135381_(ENRAGED, (Object)(target != null ? 1 : 0));
    }

    public boolean m_6052_() {
        return true;
    }

    @Override
    public int suggestEntityLevel(Difficulty d) {
        int avg = Math.round(((float)d.avgPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int max = Math.round(((float)d.maxPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int min = Math.round(((float)d.minPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        return switch (this.f_19796_.nextInt(7)) {
            case 0 -> min;
            case 1 -> max + 1;
            case 2 -> avg;
            case 3 -> avg + 1;
            case 4, 5 -> this.f_19796_.nextInt(5);
            default -> this.f_19796_.nextInt(max + 2 - min) + min;
        };
    }

    @Override
    protected float calculateFireDamage(float amount) {
        double d = amount;
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return (float)(d * 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(LEVEL, (Object)-1);
        this.m_20088_().m_135372_(ENRAGED, (Object)false);
        this.m_20088_().m_135372_(LADY, (Object)false);
    }

    protected int m_6552_(@Nonnull Player player) {
        return 20 + 5 * this.getEntityLevel();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new FleeGarlicVampireGoal(this, (double)0.9f, false));
        this.f_21345_.m_25352_(5, (Goal)new BaronAIAttackMelee(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new BaronAIAttackRanged(this, 60, 64, 6.0f, 4.0f));
        this.f_21345_.m_25352_(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 0.6, (double)0.7f, input -> input != null && !this.isLowerLevel((LivingEntity)input)));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.2));
        this.f_21345_.m_25352_(9, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::isLowerLevel));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, VampireBaronEntity.class, true, false));
    }

    protected void updateEntityAttributes(boolean aggressive) {
        if (aggressive) {
            this.m_21051_(Attributes.f_22277_).m_22100_(20.0);
            this.m_21051_(Attributes.f_22279_).m_22100_(BalanceMobProps.mobProps.VAMPIRE_BARON_MOVEMENT_SPEED * Math.pow((BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL - 1.0) / 5.0 + 1.0, this.getEntityLevel()));
        } else {
            this.m_21051_(Attributes.f_22277_).m_22100_(5.0);
            this.m_21051_(Attributes.f_22279_).m_22100_(BalanceMobProps.mobProps.VAMPIRE_BARON_MOVEMENT_SPEED * Math.pow(BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getEntityLevel()) / 3.0);
        }
        this.m_21051_(Attributes.f_22276_).m_22100_(BalanceMobProps.mobProps.VAMPIRE_BARON_MAX_HEALTH * Math.pow(BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getEntityLevel()));
        this.m_21051_(Attributes.f_22281_).m_22100_(BalanceMobProps.mobProps.VAMPIRE_BARON_ATTACK_DAMAGE * Math.pow(BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getEntityLevel()));
    }

    private boolean isLowerLevel(LivingEntity player) {
        if (player instanceof Player) {
            int playerLevel = FactionPlayerHandler.getOpt((Player)player).map(FactionPlayerHandler::getCurrentLevel).orElse(0);
            return (float)(playerLevel - 8) / 2.0f - (float)this.getEntityLevel() <= 0.0f;
        }
        return false;
    }

    private class BaronAIAttackMelee
    extends MeleeAttackGoal {
        BaronAIAttackMelee(PathfinderMob creature, double speedIn) {
            super(creature, speedIn, false);
        }

        public boolean m_8045_() {
            return !VampireBaronEntity.this.rangedAttack && super.m_8045_();
        }

        public boolean m_8036_() {
            return !VampireBaronEntity.this.rangedAttack && super.m_8036_();
        }
    }

    private class BaronAIAttackRanged
    extends AttackRangedDarkBloodGoal {
        BaronAIAttackRanged(VampireBaronEntity entity, int cooldown, int maxDistance, float damage, float indirectDamage) {
            super(entity, cooldown, maxDistance, damage, indirectDamage);
        }

        @Override
        public boolean m_8036_() {
            return VampireBaronEntity.this.m_5448_() != null && (VampireBaronEntity.this.rangedAttack || !VampireBaronEntity.this.m_21691_());
        }
    }
}

