/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import com.google.common.collect.ImmutableList;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public class MinionInventory
implements IMinionInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)25, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> inventoryHands = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> inventoryArmor = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final List<NonNullList<ItemStack>> allInventories = ImmutableList.of(this.inventoryHands, this.inventoryArmor, this.inventory);
    private int availableSize;

    public MinionInventory(int availableSize) {
        assert (availableSize == 9 || availableSize == 12 || availableSize == 15);
        this.availableSize = availableSize;
    }

    public MinionInventory() {
        this(9);
    }

    @Override
    public void addItemStack(@Nonnull ItemStack stack) {
        int slot;
        while (!stack.m_41619_() && (slot = InventoryHelper.getFirstSuitableSlotToAdd(this.inventory, this.m_6643_() - 6, stack, this.m_6893_())) != -1) {
            int oldSize = stack.m_41613_();
            InventoryHelper.addStackToSlotWithoutCheck(this, slot + 6, stack);
            if (stack.m_41613_() < oldSize) continue;
            break;
        }
    }

    public void m_6211_() {
        for (List list : this.allInventories) {
            list.clear();
        }
    }

    public void damageArmor(DamageSource source, float damage, MinionEntity<?> entity) {
        if (damage > 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int i = 0; i < this.inventoryArmor.size(); ++i) {
                ItemStack itemstack = (ItemStack)this.inventoryArmor.get(i);
                if (!(itemstack.m_41720_() instanceof ArmorItem)) continue;
                int i_final = i;
                itemstack.m_41622_((int)damage, entity, e -> e.m_21166_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i_final)));
            }
        }
    }

    public int m_6643_() {
        return 6 + this.availableSize;
    }

    @Override
    public int getAvailableSize() {
        return this.availableSize;
    }

    public MinionInventory setAvailableSize(int newSize) {
        assert (newSize == 9 || newSize == 12 || newSize == 15);
        this.availableSize = newSize;
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventoryArmor() {
        return this.inventoryArmor;
    }

    @Override
    public NonNullList<ItemStack> getInventoryHands() {
        return this.inventoryHands;
    }

    @Nonnull
    public ItemStack m_8020_(int index) {
        assert (index >= 0);
        if (index < 2) {
            return (ItemStack)this.inventoryHands.get(index);
        }
        if (index < 6) {
            return (ItemStack)this.inventoryArmor.get(index - 2);
        }
        if (index < 6 + this.availableSize) {
            return (ItemStack)this.inventory.get(index - 6);
        }
        return ItemStack.f_41583_;
    }

    public void read(ListTag nbtTagListIn) {
        this.inventory.clear();
        this.inventoryArmor.clear();
        this.inventoryHands.clear();
        for (int i = 0; i < nbtTagListIn.size(); ++i) {
            CompoundTag compoundnbt = nbtTagListIn.m_128728_(i);
            int j = compoundnbt.m_128445_("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundnbt);
            if (itemstack.m_41619_()) continue;
            if (j < this.inventoryHands.size()) {
                this.inventoryHands.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 10 && j < this.inventoryArmor.size() + 10) {
                this.inventoryArmor.set(j - 10, (Object)itemstack);
                continue;
            }
            if (j < 20 || j >= this.inventory.size() + 20) continue;
            this.inventory.set(j - 20, (Object)itemstack);
        }
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        for (ItemStack itemstack1 : this.inventoryHands) {
            if (itemstack1.m_41619_()) continue;
            return false;
        }
        for (ItemStack itemstack2 : this.inventoryArmor) {
            if (itemstack2.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_7407_(int index, int count) {
        ItemStack s = this.m_8020_(index);
        return !s.m_41619_() && count > 0 ? s.m_41620_(count) : ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        ItemStack s = this.m_8020_(index);
        if (!s.m_41619_()) {
            this.m_6836_(index, ItemStack.f_41583_);
        }
        return s;
    }

    public void m_6596_() {
    }

    public void m_6836_(int index, @Nonnull ItemStack stack) {
        assert (index >= 0);
        if (index < 2) {
            this.inventoryHands.set(index, (Object)stack);
        } else if (index < 6) {
            this.inventoryArmor.set(index - 2, (Object)stack);
        } else if (index < 6 + this.availableSize) {
            this.inventory.set(index - 6, (Object)stack);
        }
    }

    public boolean m_6542_(@Nonnull Player player) {
        return true;
    }

    public ListTag write(ListTag nbt) {
        for (int i = 0; i < this.inventoryHands.size(); ++i) {
            if (((ItemStack)this.inventoryHands.get(i)).m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Slot", (byte)i);
            ((ItemStack)this.inventoryHands.get(i)).m_41739_(compoundnbt);
            nbt.add((Object)compoundnbt);
        }
        for (int j = 0; j < this.inventoryArmor.size(); ++j) {
            if (((ItemStack)this.inventoryArmor.get(j)).m_41619_()) continue;
            CompoundTag compoundnbt1 = new CompoundTag();
            compoundnbt1.m_128344_("Slot", (byte)(j + 10));
            ((ItemStack)this.inventoryArmor.get(j)).m_41739_(compoundnbt1);
            nbt.add((Object)compoundnbt1);
        }
        for (int k = 0; k < this.inventory.size(); ++k) {
            if (((ItemStack)this.inventory.get(k)).m_41619_()) continue;
            CompoundTag compoundnbt2 = new CompoundTag();
            compoundnbt2.m_128344_("Slot", (byte)(k + 20));
            ((ItemStack)this.inventory.get(k)).m_41739_(compoundnbt2);
            nbt.add((Object)compoundnbt2);
        }
        return nbt;
    }
}

