/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.lib.util.WeightedRandomItem;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.minion.management.DefaultMinionTask;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CollectResourcesTask<Q extends MinionData>
extends DefaultMinionTask<Desc<Q>, Q> {
    @Nonnull
    private final Function<Q, Integer> coolDownSupplier;
    @Nonnull
    private final List<WeightedRandomItem<ItemStack>> resources;
    private final Random rng = new Random();
    @Nullable
    private final IFaction<?> faction;

    public CollectResourcesTask(@Nullable IFaction<?> faction, @Nonnull Function<Q, Integer> coolDownSupplier, @Nonnull List<WeightedRandomItem<ItemStack>> resources) {
        this.coolDownSupplier = coolDownSupplier;
        this.resources = resources;
        this.faction = faction;
    }

    @Override
    public Desc<Q> activateTask(@Nullable Player lord, @Nullable IMinionEntity minion, Q data) {
        this.triggerAdvancements(lord);
        if (minion != null) {
            minion.recallMinion();
        }
        if (lord != null) {
            lord.m_5661_((Component)new TranslatableComponent(Util.m_137492_((String)"minion_task", (ResourceLocation)this.getRegistryName()) + ".start"), true);
        }
        return new Desc(this, this.coolDownSupplier.apply(data), lord != null ? lord.m_142081_() : null);
    }

    @Override
    public void deactivateTask(Desc<Q> desc) {
    }

    @Override
    public boolean isAvailable(IFaction<?> faction, @Nullable ILordPlayer player) {
        return this.faction == null || this.faction == faction;
    }

    @Override
    public Desc<Q> readFromNBT(CompoundTag nbt) {
        return new Desc(this, nbt.m_128451_("cooldown"), nbt.m_128441_("lordid") ? nbt.m_128342_("lordid") : null);
    }

    @Override
    public void tickBackground(Desc<Q> desc, @Nonnull Q data) {
        if (--desc.coolDown <= 0) {
            boolean lordOnline = desc.lordEntityID != null && ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(desc.lordEntityID) != null;
            desc.coolDown = lordOnline ? this.coolDownSupplier.apply(data) : (int)((double)this.coolDownSupplier.apply(data).intValue() * (Double)VampirismConfig.BALANCE.miResourceCooldownOfflineMult.get());
            WeightedRandom.m_146317_((Random)this.rng, this.resources).map(WeightedRandomItem::getItem).map(ItemStack::m_41777_).ifPresent(s -> data.getInventory().addItemStack((ItemStack)s));
        }
    }

    public static class Desc<Z extends MinionData>
    implements IMinionTask.IMinionTaskDesc<Z> {
        private final CollectResourcesTask<Z> task;
        @Nullable
        private final UUID lordEntityID;
        private int coolDown;

        public Desc(CollectResourcesTask<Z> task, int coolDown, @Nullable UUID lordEntityID) {
            this.task = task;
            this.coolDown = coolDown;
            this.lordEntityID = lordEntityID;
        }

        @Override
        public IMinionTask<?, Z> getTask() {
            return this.task;
        }

        @Override
        public void writeToNBT(CompoundTag nbt) {
            nbt.m_128405_("cooldown", this.coolDown);
            if (this.lordEntityID != null) {
                nbt.m_128362_("lordid", this.lordEntityID);
            }
        }
    }
}

