/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.google.common.collect.Lists;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.client.gui.VampireMinionAppearanceScreen;
import de.teamlapen.vampirism.client.gui.VampireMinionStatsScreen;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.vampire.BasicVampireEntity;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.items.MinionUpgradeItem;
import de.teamlapen.vampirism.items.VampirismItemBloodFood;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class VampireMinionEntity
extends MinionEntity<VampireMinionData>
implements IVampire {
    private boolean sundamageCache;
    private EnumStrength garlicCache = EnumStrength.NONE;

    public static void init() {
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return BasicVampireEntity.getAttributeBuilder();
    }

    public VampireMinionEntity(EntityType<? extends VampirismEntity> type, Level world) {
        super(type, world, VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, true, true, true, false, null).or(e -> !(e instanceof IFactionEntity) && e instanceof Enemy && !(e instanceof Zombie) && !(e instanceof Skeleton) && !(e instanceof Creeper)));
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.m_5634_((float)amt / 3.0f);
    }

    @Override
    public List<IMinionTask<?, ?>> getAvailableTasks() {
        return Lists.newArrayList((Object[])new IMinionTask[]{MinionTasks.follow_lord, MinionTasks.stay, MinionTasks.defend_area, MinionTasks.collect_blood, MinionTasks.protect_lord});
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public int getVampireType() {
        return this.getMinionData().map(d -> d.type).map(t -> Math.max(0, t)).orElse(0);
    }

    public boolean hasMinionSpecificSkin() {
        return this.getMinionData().map(d -> d.minionSkin).orElse(false);
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public void m_8107_() {
        if (this.f_19797_ % 40 == 3) {
            this.isGettingGarlicDamage((LevelAccessor)this.f_19853_, true);
        }
        if (this.f_19797_ % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)this.f_19853_, true);
        }
        if (!this.f_19853_.f_46443_) {
            double dmg;
            if (this.isGettingSundamage((LevelAccessor)this.f_19853_) && this.f_19797_ % 40 == 11 && (dmg = this.m_21051_((Attribute)ModAttributes.sundamage).m_22135_()) > 0.0) {
                this.m_6469_(VReference.SUNDAMAGE, (float)dmg);
            }
            if (this.isGettingGarlicDamage((LevelAccessor)this.f_19853_) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)this.f_19853_), this.f_19797_);
            }
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_20069_()) {
            this.m_20301_(300);
            if (this.f_19797_ % 16 == 4) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, 0));
            }
        }
        super.m_8107_();
    }

    @Override
    @Nonnull
    public ItemStack m_5584_(@Nonnull Level world, @Nonnull ItemStack stack) {
        return stack;
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.f_19853_.m_46473_());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.m_21023_(ModEffects.sunscreen);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openAppearanceScreen() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new VampireMinionAppearanceScreen(this, Minecraft.m_91087_().f_91080_)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new VampireMinionStatsScreen(this, Minecraft.m_91087_().f_91080_)));
    }

    public void setUseLordSkin(boolean useLordSkin) {
        this.getMinionData().ifPresent(d -> {
            d.useLordSkin = useLordSkin;
        });
    }

    public void setVampireType(int type, boolean minionSkin) {
        this.getMinionData().ifPresent(d -> {
            d.type = type;
            d.minionSkin = minionSkin;
        });
    }

    @Override
    public boolean shouldRenderLordSkin() {
        return this.getMinionData().map(d -> d.useLordSkin).orElse(false);
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        return false;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    @Override
    protected boolean canConsume(ItemStack stack) {
        boolean fullHealth;
        if (!super.canConsume(stack)) {
            return false;
        }
        if (stack.m_41614_() && !(stack.m_41720_() instanceof VampirismItemBloodFood)) {
            return false;
        }
        boolean bl = fullHealth = this.m_21223_() == this.m_21233_();
        if (fullHealth && stack.m_41614_() && stack.m_41720_() instanceof VampirismItemBloodFood) {
            return false;
        }
        if (stack.m_41720_() instanceof BloodBottleItem && stack.m_41773_() == 0) {
            return false;
        }
        return !fullHealth || !(stack.m_41720_() instanceof BloodBottleItem);
    }

    @Override
    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack heldItem;
        if (!this.f_19853_.m_5776_() && this.isLord(player) && this.minionData != null && (heldItem = player.m_21120_(hand)).m_41720_() instanceof MinionUpgradeItem && ((MinionUpgradeItem)heldItem.m_41720_()).getFaction() == this.getFaction()) {
            if (((VampireMinionData)this.minionData).level + 1 >= ((MinionUpgradeItem)heldItem.m_41720_()).getMinLevel() && ((VampireMinionData)this.minionData).level + 1 <= ((MinionUpgradeItem)heldItem.m_41720_()).getMaxLevel()) {
                ++((VampireMinionData)this.minionData).level;
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                player.m_5661_((Component)new TranslatableComponent("text.vampirism.vampire_minion.binding_upgrade"), false);
                HelperLib.sync(this);
            } else {
                player.m_5661_((Component)new TranslatableComponent("text.vampirism.vampire_minion.binding_wrong"), false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void onMinionDataReceived(@Nonnull VampireMinionData data) {
        super.onMinionDataReceived(data);
        this.updateAttributes();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, new RestrictSunVampireGoal<VampireMinionEntity>(this));
        this.f_21345_.m_25352_(8, new FleeSunVampireGoal<VampireMinionEntity>(this, 1.0, true));
    }

    private void updateAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(BalanceMobProps.mobProps.MINION_MAX_HEALTH + (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * (double)this.getMinionData().map(VampireMinionData::getHealthLevel).orElse(0).intValue());
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22281_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.m_22100_(3.0 + (double)BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_DMG * (double)this.getMinionData().map(VampireMinionData::getStrengthLevel).orElse(0).intValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(BalanceMobProps.mobProps.VAMPIRE_SPEED + 0.05 * (double)this.getMinionData().map(VampireMinionData::getSpeedLevel).orElse(0).intValue());
    }

    static {
        MinionData.registerDataType(VampireMinionData.ID, VampireMinionData::new);
    }

    public static class VampireMinionData
    extends MinionData {
        public static final ResourceLocation ID = new ResourceLocation("vampirism", "vampire");
        public static final int MAX_LEVEL = 6;
        public static final int MAX_LEVEL_INVENTORY = 2;
        public static final int MAX_LEVEL_HEALTH = 3;
        public static final int MAX_LEVEL_STRENGTH = 3;
        public static final int MAX_LEVEL_SPEED = 3;
        private int type;
        private boolean useLordSkin;
        private boolean minionSkin;
        private int level;
        private int inventoryLevel;
        private int healthLevel;
        private int strengthLevel;
        private int speedLevel;

        public VampireMinionData(String name, int type, boolean useLordSkin) {
            super(name, 9);
            this.type = type;
            this.useLordSkin = useLordSkin;
            this.level = 0;
            this.minionSkin = false;
        }

        private VampireMinionData() {
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.type = nbt.m_128451_("vampire_type");
            this.level = nbt.m_128451_("level");
            this.useLordSkin = nbt.m_128471_("use_lord_skin");
            this.inventoryLevel = nbt.m_128451_("l_inv");
            this.healthLevel = nbt.m_128451_("l_he");
            this.strengthLevel = nbt.m_128451_("l_str");
            this.speedLevel = nbt.m_128451_("l_spe");
            this.minionSkin = nbt.m_128471_("ms");
        }

        @Override
        public MutableComponent getFormattedName() {
            return super.getFormattedName().m_130938_(style -> style.m_131148_(VReference.VAMPIRE_FACTION.getChatColor()));
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public int getInventoryLevel() {
            return this.inventoryLevel;
        }

        @Override
        public int getInventorySize() {
            int size = this.getDefaultInventorySize();
            return this.inventoryLevel == 1 ? size + 3 : (this.inventoryLevel == 2 ? size + 6 : size);
        }

        public int getLevel() {
            return this.level;
        }

        public int getRemainingStatPoints() {
            return Math.max(0, this.level - this.inventoryLevel - this.healthLevel - this.speedLevel - this.strengthLevel);
        }

        public int getSpeedLevel() {
            return this.speedLevel;
        }

        public int getStrengthLevel() {
            return this.strengthLevel;
        }

        @Override
        public void handleMinionAppearanceConfig(String newName, int ... data) {
            this.setName(newName);
            if (data.length >= 2) {
                this.type = data[0];
                this.useLordSkin = (data[1] & 1) == 1;
                this.minionSkin = (data[1] & 2) == 2;
            }
        }

        @Override
        public boolean hasUsedSkillPoints() {
            return this.inventoryLevel + this.healthLevel + this.strengthLevel + this.speedLevel > 0;
        }

        @Override
        public void resetStats(MinionEntity<?> entity) {
            assert (entity instanceof VampireMinionEntity);
            this.inventoryLevel = 0;
            this.healthLevel = 0;
            this.strengthLevel = 0;
            this.speedLevel = 0;
            this.getInventory().setAvailableSize(this.getInventorySize());
            ((VampireMinionEntity)entity).updateAttributes();
            super.resetStats(entity);
        }

        @Override
        public void serializeNBT(CompoundTag tag) {
            super.serializeNBT(tag);
            tag.m_128405_("vampire_type", this.type);
            tag.m_128405_("level", this.level);
            tag.m_128379_("use_lord_skin", this.useLordSkin);
            tag.m_128405_("l_inv", this.inventoryLevel);
            tag.m_128405_("l_he", this.healthLevel);
            tag.m_128405_("l_str", this.strengthLevel);
            tag.m_128405_("l_spe", this.speedLevel);
            tag.m_128379_("ms", this.minionSkin);
        }

        public boolean setLevel(int level) {
            if (level < 0 || level > 6) {
                return false;
            }
            boolean levelup = level > this.level;
            this.level = level;
            return levelup;
        }

        @Override
        public boolean upgradeStat(int statId, MinionEntity<?> entity) {
            if (super.upgradeStat(statId, entity)) {
                return true;
            }
            if (this.getRemainingStatPoints() == 0) {
                LOGGER.warn("Cannot upgrade minion stat as no stat points are left");
                return false;
            }
            assert (entity instanceof VampireMinionEntity);
            switch (statId) {
                case 0: {
                    if (this.inventoryLevel >= 2) {
                        return false;
                    }
                    ++this.inventoryLevel;
                    this.getInventory().setAvailableSize(this.getInventorySize());
                    return true;
                }
                case 1: {
                    if (this.healthLevel >= 3) {
                        return false;
                    }
                    ++this.healthLevel;
                    ((VampireMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 2: {
                    if (this.strengthLevel >= 3) {
                        return false;
                    }
                    ++this.strengthLevel;
                    ((VampireMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 3: {
                    if (this.speedLevel >= 3) {
                        return false;
                    }
                    ++this.speedLevel;
                    return true;
                }
            }
            LOGGER.warn("Cannot upgrade minion stat {} as it does not exist", (Object)statId);
            return false;
        }

        @Override
        protected ResourceLocation getDataType() {
            return ID;
        }
    }
}

