/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.mojang.authlib.GameProfile;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.minion.goals.DefendAreaGoal;
import de.teamlapen.vampirism.entity.minion.goals.DefendLordGoal;
import de.teamlapen.vampirism.entity.minion.goals.FollowLordGoal;
import de.teamlapen.vampirism.entity.minion.goals.MoveToTaskCenterGoal;
import de.teamlapen.vampirism.entity.minion.management.MinionDamageSource;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.inventory.container.MinionContainer;
import de.teamlapen.vampirism.util.IPlayerOverlay;
import de.teamlapen.vampirism.util.PlayerSkinHelper;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinionEntity<T extends MinionData>
extends VampirismEntity
implements IPlayerOverlay,
ISyncable,
ForceLookEntityGoal.TaskOwner,
IMinionEntity,
IEntityAdditionalSpawnData {
    protected static final EntityDataAccessor<Optional<UUID>> LORD_ID = SynchedEntityData.m_135353_(MinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.m_122779_();
    private static final int CONVERT_DURATION = 20;
    private final Predicate<LivingEntity> hardAttackPredicate;
    private final Predicate<LivingEntity> softAttackPredicate;
    @Nullable
    protected PlayerMinionController playerMinionController;
    protected T minionData;
    @Nullable
    private Pair<ResourceLocation, Boolean> skinDetails;
    private int minionId;
    private int token;
    private int convertCounter;
    @Nullable
    private Player interactingPlayer;

    protected MinionEntity(EntityType<? extends VampirismEntity> type, Level world, @Nonnull Predicate<LivingEntity> attackPredicate) {
        super(type, world);
        this.softAttackPredicate = attackPredicate;
        this.hardAttackPredicate = livingEntity -> {
            boolean flag1 = this.getLordOpt().map(ILordPlayer::getPlayer).filter(entity -> entity == livingEntity).isPresent();
            boolean flag2 = livingEntity instanceof MinionEntity && ((MinionEntity)livingEntity).getLordID().filter(id -> this.getLordID().map(id2 -> id == id2).orElse(false)).isPresent();
            return !flag1 && !flag2;
        };
        this.setDontDropEquipment();
        this.peaceful = true;
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        this.getLordID().ifPresent(id -> nbt.m_128362_("lord", id));
        nbt.m_128405_("minion_id", this.minionId);
        nbt.m_128405_("minion_token", this.token);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (this.f_19796_.nextInt(900) == 0 && this.f_20919_ == 0) {
                this.m_5634_(1.0f);
            }
            if (this.f_19797_ % 20 == 0) {
                this.consumeOffhand();
            }
        }
        if (this.convertCounter > 0) {
            --this.convertCounter;
        }
        if (!this.f_19853_.f_46443_ && !this.isValid() && this.m_6084_()) {
            LOGGER.warn("Minion without lord.");
            this.m_146870_();
        }
    }

    public void changeMinionName(String name) {
        if (this.minionData != null) {
            ((MinionData)this.minionData).setName(name);
            super.m_6593_((Component)((MinionData)this.minionData).getFormattedName());
        }
    }

    public void claimMinionSlot(int id, @Nonnull PlayerMinionController controller) {
        assert (this.minionId == 0);
        controller.claimMinionSlot(id).ifPresent(token -> {
            this.playerMinionController = controller;
            this.minionId = id;
            this.token = token;
            this.m_20088_().m_135381_(LORD_ID, Optional.of(this.playerMinionController.getUUID()));
        });
    }

    public void m_6667_(@Nonnull DamageSource cause) {
        super.m_6667_(cause);
        if (this.playerMinionController != null) {
            this.getLordOpt().map(ILordPlayer::getPlayer).ifPresent(p -> p.m_5661_((Component)new TranslatableComponent("text.vampirism.minion.died", new Object[]{this.m_5446_()}), true));
            this.playerMinionController.markDeadAndReleaseMinionSlot(this.minionId, this.token);
            this.playerMinionController = null;
        }
    }

    public boolean m_7327_(@Nonnull Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entityIn.m_20254_(i * 4);
        }
        if (flag = entityIn.m_6469_((DamageSource)new MinionDamageSource(this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            ItemStack itemstack = this.m_21205_();
            if (entityIn instanceof Player) {
                Player player = (Player)entityIn;
                this.m_21424_(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            if (!this.f_19853_.f_46443_ && !itemstack.m_41619_() && entityIn instanceof LivingEntity) {
                itemstack.m_41720_().m_7579_(itemstack, (LivingEntity)entityIn, (LivingEntity)this);
                if (itemstack.m_41619_()) {
                    this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
            }
            this.m_19970_((LivingEntity)this, entityIn);
            this.m_21335_(entityIn);
        }
        return flag;
    }

    @Nonnull
    public ItemStack m_5584_(@Nonnull Level world, @Nonnull ItemStack stack) {
        if (stack.m_41614_()) {
            float healAmount = (float)stack.m_41720_().m_41473_().m_38744_() / 2.0f;
            this.m_5634_(healAmount);
        }
        return super.m_5584_(world, stack);
    }

    public Predicate<LivingEntity> getAttackPredicate(boolean onlyShould) {
        return onlyShould ? this.hardAttackPredicate.and(this.softAttackPredicate) : this.hardAttackPredicate;
    }

    public abstract List<IMinionTask<?, ?>> getAvailableTasks();

    @Override
    public Optional<IMinionTask.IMinionTaskDesc<?>> getCurrentTask() {
        return this.minionData != null ? Optional.of(((MinionData)this.minionData).getCurrentTaskDesc()) : Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<Player> getForceLookTarget() {
        return Optional.ofNullable(this.interactingPlayer);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public Optional<IMinionInventory> getInventory() {
        if (this.minionData != null) {
            return Optional.of(((MinionData)this.minionData).getInventory());
        }
        return Optional.empty();
    }

    @Nonnull
    public Iterable<ItemStack> m_6168_() {
        return (Iterable)this.getInventory().map(IMinionInventory::getInventoryArmor).orElse(EMPTY_LIST);
    }

    @Override
    @Nonnull
    public Optional<ILordPlayer> getLordOpt() {
        return Optional.ofNullable(this.getLord());
    }

    public Optional<T> getMinionData() {
        return Optional.ofNullable(this.minionData);
    }

    @Override
    public Optional<Integer> getMinionId() {
        return this.minionData == null ? Optional.empty() : Optional.of(this.minionId);
    }

    @Override
    public Optional<Pair<ResourceLocation, Boolean>> getOverlayPlayerProperties() {
        if (this.skinDetails == null) {
            this.getLordID().ifPresent(id -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PlayerSkinHelper.obtainPlayerSkinPropertiesAsync(new GameProfile(id, "Dummy"), p -> {
                this.skinDetails = p;
            })));
            this.skinDetails = PENDING_PROP;
        }
        return Optional.of(this.skinDetails);
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public float m_6134_() {
        return 0.8f + (float)this.convertCounter / 20.0f * 0.2f;
    }

    @Nonnull
    public EntityDimensions m_6972_(@Nonnull Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(this.m_6134_());
    }

    public boolean isTaskLocked() {
        return this.minionData != null && ((MinionData)this.minionData).isTaskLocked();
    }

    @Nonnull
    public Iterable<ItemStack> m_6167_() {
        return (Iterable)this.getInventory().map(IMinionInventory::getInventoryHands).orElse(EMPTY_LIST);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void loadUpdateFromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("data_type")) {
            try {
                MinionData data = MinionData.fromNBT(nbt);
                this.minionData = data;
                this.onMinionDataReceived(data);
                this.minionId = nbt.m_128451_("minion_id");
                super.m_6593_((Component)data.getFormattedName());
            }
            catch (ClassCastException e) {
                LOGGER.error("Failed to cast minion data. Maybe the correct data was not registered", (Throwable)e);
            }
        } else {
            LOGGER.warn("Received empty minion data");
        }
    }

    public void markAsConverted() {
        this.convertCounter = 20;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.checkoutMinionData();
    }

    public void onRemovedFromWorld() {
        if (this.playerMinionController != null) {
            this.playerMinionController.checkInMinion(this.minionId, this.token);
            this.minionData = null;
            this.playerMinionController = null;
        }
        super.onRemovedFromWorld();
    }

    @Nonnull
    public ItemStack m_6844_(@Nonnull EquipmentSlot slotIn) {
        return switch (slotIn.m_20743_()) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.Type.HAND -> this.getInventory().map(IMinionInventory::getInventoryHands).map(i -> (ItemStack)i.get(slotIn.m_20749_())).orElse(ItemStack.f_41583_);
            case EquipmentSlot.Type.ARMOR -> this.getInventory().map(IMinionInventory::getInventoryArmor).map(i -> (ItemStack)i.get(slotIn.m_20749_())).orElse(ItemStack.f_41583_);
        };
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag nbt) {
        UUID id;
        super.m_7378_(nbt);
        UUID uUID = id = nbt.m_128403_("lord") ? nbt.m_128342_("lord") : null;
        if (id != null && this.f_19853_ instanceof ServerLevel) {
            this.playerMinionController = MinionWorldData.getData((ServerLevel)this.f_19853_).getController(id);
            if (this.playerMinionController == null) {
                LOGGER.warn("Cannot get PlayerMinionController for {}", (Object)id);
            } else {
                this.minionId = nbt.m_128451_("minion_id");
                this.token = nbt.m_128451_("minion_token");
                this.m_20088_().m_135381_(LORD_ID, Optional.of(id));
            }
        }
    }

    public void onTaskChanged() {
        HelperLib.sync(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openAppearanceScreen() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.convertCounter = additionalData.m_130242_();
    }

    @Override
    @Deprecated
    public void recallMinion() {
        this.m_146870_();
    }

    public void m_8061_(@Nonnull EquipmentSlot slotIn, @Nonnull ItemStack stack) {
        if (this.minionData == null) {
            return;
        }
        switch (slotIn.m_20743_()) {
            case HAND: {
                this.getInventory().map(IMinionInventory::getInventoryHands).ifPresent(i -> i.set(slotIn.m_20749_(), (Object)stack));
                break;
            }
            case ARMOR: {
                this.getInventory().map(IMinionInventory::getInventoryArmor).ifPresent(i -> i.set(slotIn.m_20749_(), (Object)stack));
            }
        }
    }

    public Predicate<ItemStack> getEquipmentPredicate(EquipmentSlot slotType) {
        return itemStack -> !(itemStack.m_41720_() instanceof IFactionExclusiveItem) || this.getFaction().equals(((IFactionExclusiveItem)itemStack.m_41720_()).getExclusiveFaction((ItemStack)itemStack));
    }

    public void m_6593_(@Nullable Component name) {
    }

    public void m_21153_(float health) {
        super.m_21153_(health);
        if (this.minionData != null) {
            ((MinionData)this.minionData).setHealth(health);
        }
    }

    public void setInteractingPlayer(@Nullable Player player) {
        this.interactingPlayer = player;
    }

    public void m_6710_(@Nullable LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn == null || this.hardAttackPredicate.test(entitylivingbaseIn)) {
            super.m_6710_(entitylivingbaseIn);
        }
    }

    public abstract boolean shouldRenderLordSkin();

    public boolean m_6052_() {
        return true;
    }

    @Override
    public void writeFullUpdateToNBT(CompoundTag nbt) {
        if (this.minionData == null && this.f_19853_.m_6815_(this.m_142049_()) != null) {
            this.checkoutMinionData();
        }
        if (this.minionData != null) {
            ((MinionData)this.minionData).serializeNBT(nbt);
            nbt.m_128405_("minion_id", this.minionId);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.convertCounter);
    }

    protected boolean canConsume(ItemStack stack) {
        if (stack.m_41780_() != UseAnim.DRINK && stack.m_41780_() != UseAnim.EAT) {
            return false;
        }
        return !stack.m_41619_();
    }

    protected void consumeOffhand() {
        if (this.m_6117_()) {
            return;
        }
        if (this.f_21346_.m_25386_().findAny().isPresent()) {
            return;
        }
        ItemStack stack = this.getInventory().map(i -> i.m_8020_(1)).orElse(ItemStack.f_41583_);
        if (!this.canConsume(stack)) {
            return;
        }
        this.m_6672_(InteractionHand.OFF_HAND);
        this.m_146922_(this.m_6080_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(LORD_ID, Optional.empty());
    }

    @Nullable
    protected ILordPlayer getLord() {
        return this.getLordID().map(arg_0 -> ((Level)this.f_19853_).m_46003_(arg_0)).filter(LivingEntity::m_6084_).flatMap(p -> FactionPlayerHandler.getOpt(p).resolve()).orElse(null);
    }

    protected Optional<UUID> getLordID() {
        return (Optional)this.m_20088_().m_135370_(LORD_ID);
    }

    protected void m_6472_(@Nonnull DamageSource damageSource, float damage) {
        if (this.minionData != null) {
            ((MinionData)this.minionData).getInventory().damageArmor(damageSource, damage, this);
        }
    }

    protected boolean isLord(Player p) {
        return this.getLordID().map(id -> id.equals(p.m_142081_())).orElse(false);
    }

    protected boolean isValid() {
        return this.playerMinionController != null;
    }

    protected void onMinionDataReceived(@Nonnull T data) {
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (this.isLord(player)) {
            if (player instanceof ServerPlayer) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, playerInventory, playerIn) -> MinionContainer.create(id, playerInventory, this), (Component)new TranslatableComponent("text.vampirism.name").m_7220_((Component)this.getMinionData().map(MinionData::getFormattedName).orElse((MutableComponent)new TextComponent("Minion")))), buf -> buf.m_130130_(this.m_142049_()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, new ForceLookEntityGoal<MinionEntity>(this));
        this.f_21345_.m_25352_(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(4, (Goal)new FollowLordGoal(this, 1.1));
        this.f_21345_.m_25352_(9, (Goal)new MoveToTaskCenterGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 20.0f, 0.6f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && !MinionEntity.this.getCurrentTask().filter(t -> t.getTask() == MinionTasks.stay).isPresent();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new DefendAreaGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DefendLordGoal(this));
    }

    private void checkoutMinionData() {
        if (this.playerMinionController != null && this.minionData == null) {
            this.minionData = this.playerMinionController.checkoutMinion(this.minionId, this.token, this);
            if (this.minionData == null) {
                this.playerMinionController = null;
            } else {
                this.handleLoadedMinionData(this.minionData);
            }
        }
    }

    private void handleLoadedMinionData(@Nonnull T data) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)((MinionData)data).getMaxHealth());
        super.m_21153_(((MinionData)data).getHealth());
        super.m_6593_((Component)((MinionData)data).getFormattedName());
        try {
            this.onMinionDataReceived(data);
        }
        catch (ClassCastException e) {
            LOGGER.error("Failed to cast minion data. Maybe the correct data was not registered", (Throwable)e);
            this.m_146870_();
        }
    }
}

