/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.entity.IDefaultTaskMasterEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.container.TaskBoardContainer;
import de.teamlapen.vampirism.util.Helper;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HunterTaskMasterEntity
extends HunterBaseEntity
implements IDefaultTaskMasterEntity {
    private static final EntityDataAccessor<String> BIOME_TYPE = SynchedEntityData.m_135353_(HunterTaskMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    @Nullable
    private Player interactor;

    public static AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampirismEntity.getAttributeBuilder();
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder2 = builder.m_22268_(Attributes.f_22276_, 30.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder2.m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    public HunterTaskMasterEntity(EntityType<? extends HunterBaseEntity> type, Level world) {
        super(type, world, false);
        this.peaceful = true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!(this.interactor == null || this.interactor.m_6084_() && this.interactor.f_36096_ instanceof TaskBoardContainer)) {
            this.interactor = null;
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setBiomeType(VillagerType.m_204073_((Holder)worldIn.m_204166_(this.m_142538_())));
        return data;
    }

    @Override
    public VillagerType getBiomeType() {
        String key = (String)this.f_19804_.m_135370_(BIOME_TYPE);
        ResourceLocation id = new ResourceLocation(key);
        return (VillagerType)Registry.f_122868_.m_7745_(id);
    }

    protected void setBiomeType(VillagerType type) {
        this.f_19804_.m_135381_(BIOME_TYPE, (Object)Registry.f_122868_.m_7981_((Object)type).toString());
    }

    @Override
    @Nonnull
    public Optional<Player> getForceLookTarget() {
        return Optional.ofNullable(this.interactor);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6052_() {
        return Helper.isHunter((Player)Minecraft.m_91087_().f_91074_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BIOME_TYPE, (Object)Registry.f_122868_.m_122315_().toString());
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player playerEntity, @Nonnull InteractionHand hand) {
        if (this.f_19853_.f_46443_) {
            return Helper.isHunter(playerEntity) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (Helper.isHunter(playerEntity) && this.interactor == null && this.processInteraction(playerEntity, (Entity)this)) {
            this.m_21573_().m_26573_();
            this.interactor = playerEntity;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, new ForceLookEntityGoal<HunterTaskMasterEntity>(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, (double)0.7f, false, 300, () -> false));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 13.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, VampireBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }
}

