/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.entity.converted.BiteableEntryManager;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampirismEntityRegistry
implements IVampirismEntityRegistry {
    @Nonnull
    public static final BiteableEntryManager biteableEntryManager = new BiteableEntryManager();
    private static final Logger LOGGER = LogManager.getLogger();
    @Nonnull
    private final Map<EntityType<? extends PathfinderMob>, IConvertingHandler<?>> convertibles = new ConcurrentHashMap();
    @Nonnull
    private final Map<EntityType<? extends PathfinderMob>, ResourceLocation> convertibleOverlay = new ConcurrentHashMap<EntityType<? extends PathfinderMob>, ResourceLocation>();
    @Nonnull
    private final Map<ResourceLocation, Integer> bloodValues = Maps.newHashMap();
    private final Map<Class<? extends PathfinderMob>, Function<? extends PathfinderMob, IExtendedCreatureVampirism>> extendedCreatureConstructors = new ConcurrentHashMap<Class<? extends PathfinderMob>, Function<? extends PathfinderMob, IExtendedCreatureVampirism>>();
    private int bloodMultiplier = 100;
    private Function<IConvertingHandler.IDefaultHelper, IConvertingHandler<?>> defaultConvertingHandlerCreator;
    private boolean finished = false;

    @Override
    public void addConvertible(EntityType<? extends PathfinderMob> type, ResourceLocation overlayLocation) {
        this.addConvertible(type, overlayLocation, new DefaultConvertingHandler(null));
    }

    @Override
    public void addConvertible(EntityType<? extends PathfinderMob> type, ResourceLocation overlay_loc, IConvertingHandler.IDefaultHelper helper) {
        this.addConvertible(type, overlay_loc, this.defaultConvertingHandlerCreator.apply(helper));
    }

    @Override
    public void addConvertible(EntityType<? extends PathfinderMob> type, ResourceLocation overlay_loc, @Nonnull IConvertingHandler<?> handler) {
        if (this.finished) {
            throw new IllegalStateException("Register convertibles during InterModEnqueueEvent");
        }
        this.convertibles.put(type, handler);
        if (FMLEnvironment.dist.isClient() && overlay_loc != null) {
            this.convertibleOverlay.put(type, overlay_loc);
        }
    }

    @Override
    public <T extends PathfinderMob> void addCustomExtendedCreature(Class<? extends T> clazz, Function<T, IExtendedCreatureVampirism> constructor) {
        if (this.finished) {
            throw new IllegalStateException("Register extended creatures during InterModEnqueueEvent");
        }
        this.extendedCreatureConstructors.put(clazz, constructor);
    }

    public void applyNewResources(Map<ResourceLocation, Integer> valuesIn, int multiplier) {
        this.bloodValues.putAll(valuesIn);
        this.bloodMultiplier = multiplier;
        HashMap biteables = Maps.newHashMap();
        HashSet blacklist = Sets.newHashSet();
        float bloodValueMultiplier = (float)this.bloodMultiplier / 10.0f;
        IConvertingHandler<?> defaultHandler = this.defaultConvertingHandlerCreator.apply(null);
        for (Map.Entry<EntityType<PathfinderMob>, IConvertingHandler<?>> entry : this.convertibles.entrySet()) {
            ResourceLocation id = entry.getKey().getRegistryName();
            if (id == null) {
                LOGGER.warn("Cannot register convertible {} since there is no EntityString for it", entry.getKey());
                continue;
            }
            Integer blood = valuesIn.remove(id);
            if (blood == null) {
                LOGGER.warn("Missing blood value for convertible creature {} ({})", (Object)entry.getKey().m_20676_(), (Object)id);
                continue;
            }
            blood = Math.round((float)blood.intValue() * bloodValueMultiplier);
            LOGGER.debug("Registering convertible {} with blood {} and handler {}", (Object)entry.getKey().m_20676_().getString(), (Object)blood, (Object)entry.getValue().getClass().getName());
            BiteableEntry biteEntry = new BiteableEntry(blood, entry.getValue() == null ? defaultHandler : entry.getValue());
            biteables.put(id, biteEntry);
        }
        LOGGER.info("Registered {} convertibles", (Object)biteables.size());
        for (Map.Entry<Object, Object> entry : valuesIn.entrySet()) {
            int blood = Math.abs(Math.round((float)((Integer)entry.getValue()).intValue() * bloodValueMultiplier));
            if (blood == 0) {
                blacklist.add((ResourceLocation)entry.getKey());
                continue;
            }
            biteables.put((ResourceLocation)entry.getKey(), new BiteableEntry(blood));
        }
        biteableEntryManager.setNewBiteables(biteables, blacklist);
    }

    @Override
    @Nullable
    public IConvertedCreature<?> convert(PathfinderMob entity) {
        BiteableEntry b = biteableEntryManager.get(entity);
        if (b != null && b.convertingHandler != null) {
            return b.convertingHandler.createFrom(entity);
        }
        LOGGER.warn("Failed to find convertible entry for {}", (Object)entity);
        return null;
    }

    public void finishRegistration() {
        this.finished = true;
    }

    public int getBloodMultiplier() {
        return this.bloodMultiplier;
    }

    @Nonnull
    public Map<ResourceLocation, Integer> getBloodValues() {
        return this.bloodValues;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Map<EntityType<? extends PathfinderMob>, ResourceLocation> getConvertibleOverlay() {
        return this.convertibleOverlay;
    }

    @Override
    @Nullable
    public <T extends PathfinderMob> Function<T, IExtendedCreatureVampirism> getCustomExtendedCreatureConstructor(T entity) {
        return this.extendedCreatureConstructors.get(entity.getClass());
    }

    @Override
    @Nullable
    public BiteableEntry getEntry(PathfinderMob creature) {
        return biteableEntryManager.get(creature);
    }

    public void setDefaultConvertingHandlerCreator(Function<IConvertingHandler.IDefaultHelper, IConvertingHandler<?>> creator) {
        this.defaultConvertingHandlerCreator = creator;
    }
}

