/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;

public class DefaultConvertingHandler<T extends PathfinderMob>
implements IConvertingHandler<T> {
    private static final IConvertingHandler.IDefaultHelper defaultHelper = new IConvertingHandler.IDefaultHelper(){

        @Override
        public double getConvertedDMG(EntityType<? extends PathfinderMob> entityType) {
            AttributeSupplier map = DefaultAttributes.m_22297_(entityType);
            if (map.m_22258_(Attributes.f_22281_)) {
                return map.m_22253_(Attributes.f_22281_) * 1.3;
            }
            return BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_DMG;
        }

        @Override
        public double getConvertedKnockbackResistance(EntityType<? extends PathfinderMob> entityType) {
            AttributeSupplier map = DefaultAttributes.m_22297_(entityType);
            return map.m_22253_(Attributes.f_22278_) * 1.3;
        }

        @Override
        public double getConvertedMaxHealth(EntityType<? extends PathfinderMob> entityType) {
            AttributeSupplier map = DefaultAttributes.m_22297_(entityType);
            return map.m_22253_(Attributes.f_22276_) * 1.5;
        }

        @Override
        public double getConvertedSpeed(EntityType<? extends PathfinderMob> entityType) {
            AttributeSupplier map = DefaultAttributes.m_22297_(entityType);
            return Math.min(map.m_22253_(Attributes.f_22279_) * 1.2, 2.9);
        }
    };
    protected final IConvertingHandler.IDefaultHelper helper;

    public DefaultConvertingHandler(@Nullable IConvertingHandler.IDefaultHelper helper) {
        this.helper = Objects.requireNonNullElse(helper, defaultHelper);
    }

    @Override
    @Nullable
    public IConvertedCreature<T> createFrom(T entity) {
        return Helper.createEntity(ModEntities.converted_creature, entity.m_20193_()).map(convertedCreature -> {
            this.copyImportantStuff((ConvertedCreatureEntity<T>)convertedCreature, entity);
            convertedCreature.m_20084_(Mth.m_14062_((Random)convertedCreature.m_21187_()));
            convertedCreature.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 2));
            return convertedCreature;
        }).orElse(null);
    }

    public IConvertingHandler.IDefaultHelper getHelper() {
        return this.helper;
    }

    protected void copyImportantStuff(ConvertedCreatureEntity<T> converted, T entity) {
        converted.m_20359_((Entity)entity);
        converted.setEntityCreature(entity);
        converted.updateEntityAttributes();
        converted.m_21153_(converted.m_21233_() / 3.0f * 2.0f);
        converted.f_20883_ = ((PathfinderMob)entity).f_20883_;
        converted.f_20885_ = ((PathfinderMob)entity).f_20885_;
    }
}

