/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class SoulOrbEntity
extends Entity
implements ItemSupplier {
    public static final EntityDataAccessor<String> TYPE_PARAMETER = SynchedEntityData.m_135353_(SoulOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int delayBeforePickup;
    private Player player;
    private int age;
    @Nullable
    private ItemStack soulItemStack;

    public SoulOrbEntity(Level worldIn, double x, double y, double z, VARIANT type) {
        super(ModEntities.soul_orb, worldIn);
        this.setVariant(type);
        this.delayBeforePickup = 10;
        this.m_6034_(x, y, z);
        this.m_146922_((float)(Math.random() * 360.0));
        this.m_20334_((this.f_19796_.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.f_19796_.nextDouble() * 0.2 * 2.0, (this.f_19796_.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
    }

    public SoulOrbEntity(EntityType<? extends SoulOrbEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public VARIANT getVariant() {
        return VARIANT.valueOf((String)this.m_20088_().m_135370_(TYPE_PARAMETER));
    }

    private void setVariant(VARIANT type) {
        this.m_20088_().m_135381_(TYPE_PARAMETER, (Object)type.name());
    }

    @Nonnull
    public ItemStack m_7846_() {
        return this.getSoulItemStack();
    }

    @Nonnull
    public ItemStack getSoulItemStack() {
        if (this.soulItemStack == null) {
            this.soulItemStack = this.createSoulItemStack();
        }
        return this.soulItemStack;
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_20177_(@Nonnull Player player) {
        if (this.getVariant() == VARIANT.VAMPIRE) {
            return !Helper.isHunter(player) || player.m_5833_();
        }
        return true;
    }

    public void m_6123_(@Nonnull Player entityIn) {
        if (!this.f_19853_.f_46443_ && this.delayBeforePickup == 0 && Helper.isHunter(entityIn) && entityIn.m_150109_().m_36054_(this.getSoulItemStack())) {
            entityIn.m_7938_((Entity)this, 1);
            this.m_146870_();
        }
    }

    public void m_8119_() {
        double d1;
        Vec3 vec3d;
        super.m_8119_();
        if (this.delayBeforePickup > 0) {
            --this.delayBeforePickup;
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.m_204029_(FluidTags.f_13131_)) {
            vec3d = this.m_20184_();
            this.m_20334_(vec3d.f_82479_ * (double)0.99f, Math.min(vec3d.f_82480_ + (double)5.0E-4f, (double)0.06f), vec3d.f_82481_ * (double)0.99f);
        } else if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        }
        if (this.f_19853_.m_6425_(this.m_142538_()).m_205070_(FluidTags.f_13132_)) {
            this.m_20334_((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f, 0.2f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
            this.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + this.f_19796_.nextFloat() * 0.4f);
        }
        if (!this.f_19853_.m_45772_(this.m_142469_())) {
            this.m_20314_(this.m_20185_(), (this.m_142469_().f_82289_ + this.m_142469_().f_82292_) / 2.0, this.m_20189_());
        }
        if (this.age % 10 == 5 & (this.player == null || !this.player.m_6084_() || this.player.m_20280_((Entity)this) > 64.0)) {
            this.player = this.f_19853_.m_5788_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 8.0, EntitySelector.f_20408_.and(Helper::isHunter));
        }
        if (this.player != null && (d1 = (vec3d = new Vec3(this.player.m_20185_() - this.m_20185_(), this.player.m_20186_() + (double)this.player.m_20192_() / 2.0 - this.m_20186_(), this.player.m_20189_() - this.m_20189_())).m_82556_()) < 64.0) {
            double d2 = 1.0 - Math.sqrt(d1) / 8.0;
            this.m_20256_(this.m_20184_().m_82549_(vec3d.m_82541_().m_82490_(d2 * d2 * 0.1)));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float f = 0.98f;
        if (this.f_19861_) {
            BlockPos underPos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_142469_().f_82289_) - 1, Mth.m_14107_((double)this.m_20189_()));
            BlockState underState = this.f_19853_.m_8055_(underPos);
            f = underState.m_60734_().getFriction(underState, (LevelReader)this.f_19853_, underPos, (Entity)this) * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)f, (double)0.98f, (double)f));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, (double)-0.9f, 1.0));
        }
        ++this.age;
        if (this.age >= 6000) {
            this.m_146870_();
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("type", this.getVariant().name());
        compound.m_128405_("age", this.age);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(TYPE_PARAMETER, (Object)VARIANT.NONE.name());
    }

    @Nonnull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_7378_(CompoundTag compound) {
        this.setVariant(VARIANT.valueOf(compound.m_128461_("type")));
        this.age = compound.m_128451_("age");
        this.soulItemStack = null;
    }

    private ItemStack createSoulItemStack() {
        if (this.getVariant() == VARIANT.VAMPIRE) {
            return new ItemStack((ItemLike)ModItems.soul_orb_vampire);
        }
        return new ItemStack((ItemLike)ModItems.soul_orb_vampire);
    }

    public static enum VARIANT {
        NONE,
        VAMPIRE;

    }
}

