/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.items.IFactionSlayerItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.blockentity.TotemHelper;
import de.teamlapen.vampirism.blocks.CastleBricksBlock;
import de.teamlapen.vampirism.blocks.CastleSlabBlock;
import de.teamlapen.vampirism.blocks.CastleStairsBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.goals.GolemTargetNonVillageFactionGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.DifficultyCalculator;
import de.teamlapen.vampirism.util.Helper;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModEntityEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(ModEntityEventHandler.class);
    private static final Predicate<LivingEntity> nonVampireCheck = entity -> !Helper.isVampire((Entity)entity);
    private static final Object2BooleanMap<String> entityAIReplacementWarnMap = new Object2BooleanArrayMap();
    private final Set<ResourceLocation> unknownZombies = new HashSet<ResourceLocation>();
    private boolean skipAttackDamageOnceServer = false;
    private boolean skipAttackDamageOnceClient = false;
    private boolean warnAboutGolem = true;

    public static <T extends Mob, S extends LivingEntity, Q extends NearestAttackableTargetGoal<S>> void makeVampireFriendly(String name, T e, Class<Q> targetClass, Class<S> targetEntityClass, int attackPriority, BiFunction<T, Predicate<LivingEntity>, Q> replacement, Predicate<EntityType<? extends T>> typeCheck) {
        Goal target = null;
        for (WrappedGoal t : e.f_21346_.f_25345_) {
            Goal g = t.m_26015_();
            if (!targetClass.equals(g.getClass()) || t.m_26012_() != attackPriority || !targetEntityClass.equals(((NearestAttackableTargetGoal)g).f_26048_)) continue;
            target = g;
            break;
        }
        if (target != null) {
            e.f_21346_.m_25363_(target);
            EntityType type = e.m_6095_();
            if (typeCheck.test(type)) {
                e.f_21346_.m_25352_(attackPriority, (Goal)replacement.apply(e, nonVampireCheck));
            }
        } else if (entityAIReplacementWarnMap.getOrDefault((Object)name, true)) {
            LOGGER.warn("Could not replace {} attack target task for {}", (Object)name, (Object)e.m_6095_().m_20676_());
            entityAIReplacementWarnMap.put((Object)name, false);
        }
    }

    @SubscribeEvent
    public void onAttachCapabilityEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PathfinderMob) {
            event.addCapability(REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.createNewCapability((PathfinderMob)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        boolean client = EffectiveSide.get().isClient();
        if (!(!client ? this.skipAttackDamageOnceServer : this.skipAttackDamageOnceClient)) {
            Item item;
            ItemStack stack;
            if ("player".equals(event.getSource().m_19385_()) && event.getSource().m_7639_() instanceof Player && !(stack = ((Player)event.getSource().m_7639_()).m_21205_()).m_41619_() && (item = stack.m_41720_()) instanceof IFactionSlayerItem) {
                IFactionSlayerItem item2 = (IFactionSlayerItem)item;
                IFaction<?> faction = VampirismAPI.factionRegistry().getFaction(event.getEntity());
                if (faction != null && faction.equals(item2.getSlayedFaction())) {
                    float amt = event.getAmount() * item2.getDamageMultiplierForFaction(stack);
                    if (client) {
                        this.skipAttackDamageOnceClient = true;
                    } else {
                        this.skipAttackDamageOnceServer = true;
                    }
                    boolean result = event.getEntityLiving().m_6469_(event.getSource(), amt);
                    if (client) {
                        this.skipAttackDamageOnceClient = false;
                    } else {
                        this.skipAttackDamageOnceServer = false;
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        BlockPos pos = new BlockPos(event.getX() - (double)0.4f, event.getY(), event.getZ() - (double)0.4f).m_7495_();
        if (!event.getWorld().m_46805_(pos)) {
            return;
        }
        BlockState blockState = event.getWorld().m_8055_(pos);
        Block b = blockState.m_60734_();
        boolean deny = false;
        CastleBricksBlock.EnumVariant v = null;
        if (b instanceof CastleBricksBlock) {
            deny = true;
            v = ((CastleBricksBlock)b).getVariant();
        } else if (b instanceof CastleSlabBlock) {
            deny = true;
            v = ((CastleSlabBlock)b).getVariant();
        } else if (b instanceof CastleStairsBlock) {
            deny = true;
            v = ((CastleStairsBlock)b).getVariant();
        }
        if (deny && (v == CastleBricksBlock.EnumVariant.DARK_STONE || event.getEntity().getClassification(false) != VReference.VAMPIRE_CREATURE_TYPE)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR && event.getEntity() instanceof Player) {
            VampirePlayer.getOpt((Player)event.getEntity()).ifPresent(VampirePlayer::requestNaturalArmorUpdate);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().m_5776_()) {
            IAdjustableLevel entity2;
            Entity entity3 = event.getEntity();
            if (entity3 instanceof IAdjustableLevel && (entity2 = (IAdjustableLevel)entity3).getEntityLevel() == -1) {
                Difficulty d = DifficultyCalculator.findDifficultyForPos(event.getWorld(), event.getEntity().m_142538_(), 30);
                int l = entity2.suggestEntityLevel(d);
                if (l > entity2.getMaxEntityLevel()) {
                    l = entity2.getMaxEntityLevel();
                } else if (l < 0) {
                    event.setCanceled(true);
                }
                entity2.setEntityLevel(l);
                if (entity2 instanceof PathfinderMob) {
                    ((PathfinderMob)entity2).m_21153_(((PathfinderMob)entity2).m_21233_());
                }
            }
            if (((Boolean)VampirismConfig.BALANCE.creeperIgnoreVampire.get()).booleanValue() && event.getEntity() instanceof Creeper) {
                ((Creeper)event.getEntity()).f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)((Creeper)event.getEntity()), Player.class, 20.0f, 1.1, 1.3, Helper::isVampire));
                ModEntityEventHandler.makeVampireFriendly("creeper", (Creeper)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 1, (entity, predicate) -> new NearestAttackableTargetGoal((Mob)entity, Player.class, 10, true, false, predicate), type -> type == EntityType.f_20558_);
                return;
            }
            if (((Boolean)VampirismConfig.BALANCE.zombieIgnoreVampire.get()).booleanValue() && event.getEntity() instanceof Zombie) {
                ModEntityEventHandler.makeVampireFriendly("zombie", (Zombie)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 2, (entity, predicate) -> entity instanceof Drowned ? new NearestAttackableTargetGoal((Mob)entity, Player.class, 10, true, false, predicate.and(arg_0 -> ((Drowned)((Drowned)entity)).m_32395_(arg_0))) : new NearestAttackableTargetGoal((Mob)entity, Player.class, 10, true, false, predicate), type -> type == EntityType.f_20501_ || type == EntityType.f_20458_ || type == EntityType.f_20530_ || type == EntityType.f_20562_);
                ModEntityEventHandler.makeVampireFriendly("villager zombie", (Zombie)event.getEntity(), NearestAttackableTargetGoal.class, AbstractVillager.class, 3, (entity, predicate) -> new NearestAttackableTargetGoal((Mob)entity, AbstractVillager.class, 10, true, false, predicate), type -> type == EntityType.f_20501_ || type == EntityType.f_20458_ || type == EntityType.f_20530_ || type == EntityType.f_20562_);
                return;
            }
            if (((Boolean)VampirismConfig.BALANCE.skeletonIgnoreVampire.get()).booleanValue() && event.getEntity() instanceof Skeleton) {
                ModEntityEventHandler.makeVampireFriendly("skeleton", (Skeleton)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 2, (entity, predicate) -> new NearestAttackableTargetGoal((Mob)entity, Player.class, 10, true, false, predicate), type -> type == EntityType.f_20524_);
            }
            if (event.getEntity() instanceof IronGolem) {
                ((IronGolem)event.getEntity()).f_21346_.m_25352_(4, (Goal)new GolemTargetNonVillageFactionGoal((IronGolem)event.getEntity()));
                Goal mobTarget = null;
                for (WrappedGoal t2 : ((IronGolem)event.getEntity()).f_21346_.f_25345_) {
                    if (!(t2.m_26015_() instanceof NearestAttackableTargetGoal) || t2.m_26012_() != 3 || !Mob.class.equals((Object)((NearestAttackableTargetGoal)t2.m_26015_()).f_26048_)) continue;
                    mobTarget = t2.m_26015_();
                    break;
                }
                if (mobTarget != null) {
                    ((IronGolem)event.getEntity()).f_21346_.m_25363_(mobTarget);
                    ((IronGolem)event.getEntity()).f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)((IronGolem)event.getEntity()), Mob.class, 5, false, false, entity -> entity instanceof Enemy && !(entity instanceof IFactionEntity) && !(entity instanceof Creeper)));
                } else if (this.warnAboutGolem) {
                    LOGGER.warn("Could not replace villager iron golem target task");
                    this.warnAboutGolem = false;
                }
                return;
            }
            if (event.getEntity() instanceof Villager) {
                Optional<TotemBlockEntity> tile = TotemHelper.getTotemNearPos((ServerLevel)event.getWorld(), event.getEntity().m_142538_(), true);
                if (tile.filter(t -> VReference.HUNTER_FACTION.equals(t.getControllingFaction())).isPresent()) {
                    ExtendedCreature.getSafe(event.getEntity()).ifPresent(e -> e.setPoisonousBlood(true));
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public void onEntityLootingEvent(LootingLevelEvent event) {
        IItemWithTier.TIER hunterCoatTier;
        if (event.getDamageSource() != null && event.getDamageSource().m_7639_() instanceof Player && ((hunterCoatTier = VampirismPlayerAttributes.get((Player)((Player)event.getDamageSource().m_7639_())).getHuntSpecial().fullHunterCoat) == IItemWithTier.TIER.ENHANCED || hunterCoatTier == IItemWithTier.TIER.ULTIMATE)) {
            event.setLootingLevel(Math.min(event.getLootingLevel() + 1, 3));
        }
    }

    @SubscribeEvent
    public void onEntityVisibilityCheck(LivingEvent.LivingVisibilityEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && VampirismPlayerAttributes.get(player = (Player)entity).getHuntSpecial().isDisguised()) {
            event.modifyVisibility((VampirismPlayerAttributes.get((Player)((Player)event.getEntity())).getHuntSpecial().fullHunterCoat != null ? 0.5 : 1.0) * (Double)VampirismConfig.BALANCE.haDisguiseVisibilityMod.get());
        }
    }

    @SubscribeEvent
    public void onEyeHeightSet(EntityEvent.Size event) {
        if (event.getEntity() instanceof VampireBaseEntity || event.getEntity() instanceof HunterBaseEntity) {
            event.setNewEyeHeight(event.getOldEyeHeight() * 0.875f);
        }
    }

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof MinionEntity && event.getItem().m_41720_() instanceof PotionItem) {
            ItemStack stack = event.getResultStack();
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                event.setResultStack(new ItemStack((ItemLike)Items.f_42590_));
                return;
            }
            ((MinionEntity)event.getEntity()).getInventory().ifPresent(inv -> inv.addItemStack(new ItemStack((ItemLike)Items.f_42590_)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getTo().m_41720_() instanceof VampirismVampireSword) {
            ((VampirismVampireSword)event.getTo().m_41720_()).updateTrainedCached(event.getTo(), event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof PathfinderMob) {
            event.getEntity().m_20193_().m_46473_().m_6180_("vampirism_extended_creature");
            ExtendedCreature.getSafe(event.getEntity()).ifPresent(IExtendedCreatureVampirism::tick);
            event.getEntity().m_20193_().m_46473_().m_7238_();
        }
    }
}

