/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ExtendedCreature
implements ISyncable.ISyncableEntityCapabilityInst,
IExtendedCreatureVampirism {
    private static final String KEY_BLOOD = "bloodLevel";
    private static final String KEY_MAX_BLOOD = "maxBlood";
    private static final String POISONOUS_BLOOD = "poisonousBlood";
    public static final Capability<IExtendedCreatureVampirism> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IExtendedCreatureVampirism>(){});
    private final PathfinderMob entity;
    private final boolean canBecomeVampire;
    private boolean poisonousBlood;
    private boolean markForBloodCalculation = false;
    private int maxBlood;
    private int blood;

    public static LazyOptional<IExtendedCreatureVampirism> getSafe(Entity mob) {
        return mob.getCapability(CAP);
    }

    static <Q extends PathfinderMob> ICapabilityProvider createNewCapability(final Q creature) {
        return new ICapabilitySerializable<CompoundTag>(){
            final Function<Q, IExtendedCreatureVampirism> constructor;
            final IExtendedCreatureVampirism inst;
            final LazyOptional<IExtendedCreatureVampirism> opt;
            {
                this.constructor = VampirismAPI.entityRegistry().getCustomExtendedCreatureConstructor(creature);
                this.inst = this.constructor == null ? new ExtendedCreature(creature) : this.constructor.apply(creature);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.inst.loadData(nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveData(tag);
                return tag;
            }
        };
    }

    public ExtendedCreature(PathfinderMob entity) {
        this.entity = entity;
        BiteableEntry entry = VampirismAPI.entityRegistry().getEntry(entity);
        if (entry != null && entry.blood > 0) {
            this.maxBlood = entry.blood;
            this.canBecomeVampire = entry.convertible;
        } else {
            if (entry == null) {
                this.markForBloodCalculation = true;
            }
            this.maxBlood = -1;
            this.canBecomeVampire = false;
        }
        this.blood = this.maxBlood;
        this.poisonousBlood = false;
    }

    @Override
    public boolean canBeBitten(IVampire biter) {
        return this.getBlood() > 0;
    }

    @Override
    public boolean canBecomeVampire() {
        return this.canBecomeVampire;
    }

    @Override
    public int getBlood() {
        return this.blood;
    }

    @Override
    public void setBlood(int blood) {
        if (blood >= 0 && blood <= this.getMaxBlood() && this.getBlood() != -1) {
            this.blood = blood;
        }
    }

    @Override
    public float getBloodLevelRelative() {
        return (float)this.getBlood() / (float)this.getMaxBlood();
    }

    @Override
    public float getBloodSaturation() {
        return 1.0f;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.EXTENDED_CREATURE_KEY;
    }

    @Override
    public PathfinderMob getEntity() {
        return this.entity;
    }

    @Override
    public int getMaxBlood() {
        return this.maxBlood;
    }

    private void setMaxBlood(int blood) {
        this.maxBlood = blood;
        this.blood = blood;
    }

    @Override
    public int getTheEntityID() {
        return this.entity.m_142049_();
    }

    @Override
    public boolean hasPoisonousBlood() {
        return this.poisonousBlood;
    }

    @Override
    public void loadUpdateFromNBT(CompoundTag nbt) {
        if (nbt.m_128441_(KEY_BLOOD)) {
            this.setBlood(nbt.m_128451_(KEY_BLOOD));
        }
        if (nbt.m_128441_(KEY_MAX_BLOOD)) {
            this.setBlood(nbt.m_128451_(KEY_MAX_BLOOD));
        }
        if (nbt.m_128441_(POISONOUS_BLOOD)) {
            this.setPoisonousBlood(nbt.m_128471_(POISONOUS_BLOOD));
        }
    }

    @Override
    @Nullable
    public IConvertedCreature<?> makeVampire() {
        if (this.canBecomeVampire()) {
            this.blood = -1;
            IConvertedCreature<?> c = VampirismAPI.entityRegistry().convert(this.entity);
            if (c != null) {
                UtilLib.replaceEntity((LivingEntity)this.entity, (LivingEntity)((PathfinderMob)c));
            }
            return c;
        }
        return null;
    }

    @Override
    public int onBite(IVampire biter) {
        if (this.getBlood() <= 0) {
            return 0;
        }
        int amt = Math.max(1, this.getMaxBlood() / (biter instanceof VampirePlayer ? 6 : 2));
        if (amt >= this.blood) {
            amt = this.blood > 1 && biter.isAdvancedBiter() ? this.blood - 1 : this.blood;
        }
        this.blood -= amt;
        boolean killed = false;
        boolean converted = false;
        if (this.blood == 0) {
            if (this.canBecomeVampire && this.entity.m_21187_().nextBoolean()) {
                if (((Boolean)VampirismConfig.SERVER.infectCreaturesSanguinare.get()).booleanValue()) {
                    SanguinareEffect.addRandom((LivingEntity)this.entity, false);
                } else {
                    this.makeVampire();
                }
                converted = true;
            } else {
                this.entity.m_6469_(VReference.NO_BLOOD, 1000.0f);
                killed = true;
            }
        }
        this.sync();
        this.entity.m_6703_(biter.getRepresentingEntity());
        if (this.entity instanceof AgeableMob && ((AgeableMob)this.entity).m_146764_() < 0) {
            amt = Math.round((float)amt / 3.0f);
        }
        if (biter.isAdvancedBiter() && this.entity.m_21187_().nextInt(4) == 0) {
            amt = 2 * amt;
        }
        if (converted && biter instanceof IVampirePlayer) {
            ((IVampirePlayer)biter).getRepresentingPlayer().m_36220_(ModStats.infected_creatures);
        }
        return amt;
    }

    @Override
    public void setPoisonousBlood(boolean poisonous) {
        if (poisonous == !this.poisonousBlood) {
            this.poisonousBlood = poisonous;
            this.sync();
        }
    }

    @Override
    public void tick() {
        if (!this.entity.m_20193_().f_46443_) {
            if (this.blood == 0 && this.entity.f_19797_ % 20 == 10 && this.entity.m_21124_(ModEffects.sanguinare) == null) {
                this.entity.m_6469_(VReference.NO_BLOOD, 1000.0f);
            }
            if (this.blood > 0 && this.blood < this.getMaxBlood() && this.entity.f_19797_ % 40 == 8) {
                this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 41));
                this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 41, 2));
                if (this.entity.m_21187_().nextInt(BalanceMobProps.mobProps.BLOOD_REGEN_CHANCE) == 0) {
                    this.setBlood(this.getBlood() + 1);
                    this.sync();
                }
            }
        }
        if (this.markForBloodCalculation && VampirismEntityRegistry.biteableEntryManager.init()) {
            BiteableEntry entry = VampirismEntityRegistry.biteableEntryManager.calculate(this.entity);
            if (entry != null) {
                this.setMaxBlood(entry.blood);
            }
            this.markForBloodCalculation = false;
        }
    }

    public String toString() {
        return super.toString() + " for entity (" + this.entity.toString() + ") [B" + this.blood + ",MB" + this.maxBlood + ",CV" + this.canBecomeVampire + "]";
    }

    @Override
    public void writeFullUpdateToNBT(CompoundTag nbt) {
        nbt.m_128405_(KEY_BLOOD, this.getBlood());
        nbt.m_128405_(KEY_MAX_BLOOD, this.getBlood());
        nbt.m_128379_(POISONOUS_BLOOD, this.hasPoisonousBlood());
    }

    @Override
    public void loadData(CompoundTag compound) {
        if (compound.m_128441_(KEY_MAX_BLOOD)) {
            this.setMaxBlood(compound.m_128451_(KEY_MAX_BLOOD));
        }
        if (compound.m_128441_(KEY_BLOOD)) {
            this.setBlood(compound.m_128451_(KEY_BLOOD));
        }
        if (compound.m_128441_(POISONOUS_BLOOD)) {
            this.setPoisonousBlood(compound.m_128471_(POISONOUS_BLOOD));
        }
    }

    @Override
    public void saveData(CompoundTag compound) {
        compound.m_128405_(KEY_BLOOD, this.blood);
        compound.m_128405_(KEY_MAX_BLOOD, this.maxBlood);
        compound.m_128379_(POISONOUS_BLOOD, this.poisonousBlood);
    }

    private void sync() {
        HelperLib.sync(this, (Entity)this.getEntity(), false);
    }

    private void sync(CompoundTag data) {
        HelperLib.sync(this, data, (Entity)this.getEntity(), false);
    }
}

