/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.particle.GenericParticleData;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class DarkBloodProjectileEntity
extends AbstractHurtingProjectile {
    protected float directDamage = 4.0f;
    protected float indirectDamage = 2.0f;
    private boolean initialNoClip = false;
    private float motionFactor = 0.97f;
    private boolean excludeShooter = false;
    private boolean gothrough;
    private int maxTicks = 40;

    public DarkBloodProjectileEntity(EntityType<? extends DarkBloodProjectileEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public DarkBloodProjectileEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(ModEntities.dark_blood_projectile, shooter, accelX, accelY, accelZ, worldIn);
    }

    public DarkBloodProjectileEntity(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(ModEntities.dark_blood_projectile, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("direct_damage", this.directDamage);
        compound.m_128350_("indirect_damage", this.indirectDamage);
        compound.m_128379_("gothrough", this.gothrough);
        compound.m_128405_("max_ticks", this.maxTicks);
        compound.m_128350_("motion_factor", this.motionFactor);
    }

    public void explode(int distanceSq, @Nullable Entity excludeEntity) {
        Entity shootingEntity = this.m_37282_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82400_((double)distanceSq / 2.0), EntitySelector.f_20402_.and(EntitySelector.f_20408_));
        for (Entity e : list) {
            if (this.excludeShooter && e == shootingEntity || e == excludeEntity || !(e instanceof LivingEntity)) continue;
            LivingEntity entity = (LivingEntity)e;
            if (!(e.m_20280_((Entity)this) < (double)distanceSq)) continue;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1));
            entity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)this.m_37282_()), this.indirectDamage);
        }
        if (!this.f_19853_.f_46443_) {
            ModParticles.spawnParticlesServer(this.f_19853_, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "spell_1"), 7, 0xA01010, 0.2f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 40, 1.0, 1.0, 1.0, 0.0);
            ModParticles.spawnParticlesServer(this.f_19853_, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "spell_6"), 10, 0x700505), this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 1.0, 1.0, 1.0, 0.0);
        }
        this.m_146870_();
    }

    public void excludeShooter() {
        this.excludeShooter = true;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float m_6143_() {
        return 0.5f;
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        return false;
    }

    public void setDamage(float direct, float indirect) {
        this.directDamage = direct;
        this.indirectDamage = indirect;
    }

    public void setGothrough(boolean gothrough) {
        this.gothrough = gothrough;
    }

    public void setInitialNoClip() {
        this.initialNoClip = true;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.directDamage = compound.m_128457_("direct_damage");
        this.indirectDamage = compound.m_128457_("indirect_damage");
        this.gothrough = compound.m_128471_("gothrough");
        this.maxTicks = compound.m_128451_("max_ticks");
        this.motionFactor = compound.m_128457_("motion_factor");
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            Vec3 center = this.m_20182_();
            ModParticles.spawnParticlesClient(this.f_19853_, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "spell_4"), 4, 0xA01010, 0.0f), center.f_82479_, center.f_82480_, center.f_82481_, 5, this.m_6143_(), this.f_19796_);
            if (this.f_19797_ % 3 == 0) {
                ModParticles.spawnParticleClient(this.f_19853_, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "effect_4"), 12, 0xC01010, 0.4f), center.f_82479_, center.f_82480_, center.f_82481_);
            }
        }
        if (this.f_19797_ > this.maxTicks) {
            if (!this.f_19853_.m_5776_()) {
                this.explode(4, null);
            } else {
                this.m_146870_();
            }
        }
    }

    protected float m_6884_() {
        return this.motionFactor;
    }

    public void setMotionFactor(float factor) {
        this.motionFactor = factor;
    }

    @Nonnull
    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123768_;
    }

    protected void m_6532_(@Nonnull HitResult result) {
        if (!this.f_19853_.f_46443_) {
            if (this.initialNoClip && this.f_19797_ > 20 && result.m_6662_() == HitResult.Type.BLOCK) {
                return;
            }
            Entity entity = null;
            if (result.m_6662_() == HitResult.Type.ENTITY) {
                entity = ((EntityHitResult)result).m_82443_();
                if (entity instanceof DarkBloodProjectileEntity) {
                    return;
                }
                this.hitEntity(entity);
            }
            if (!this.gothrough) {
                this.explode(4, entity);
            }
        }
    }

    protected boolean m_5931_() {
        return false;
    }

    private void hitEntity(Entity entity) {
        entity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)this.m_37282_()), this.directDamage);
        if (entity instanceof LivingEntity && this.f_19796_.nextInt(3) == 0) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100));
            ((LivingEntity)entity).m_147240_(1.0, -this.m_20184_().f_82479_, -this.m_20184_().f_82481_);
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1));
        }
    }
}

